/*
 * ============================================================================
 * GNU Lesser General Public License
 * ============================================================================
 *
 * Rieps - Free Java  postscript API
 * Copyright (C) 2007 TIIE http://www.tiie.fr
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 * 
 * TIIE/RIE Technologies
 * Z.A de la Duquerie
 * 37390 Chanceaux sur Choisille FRANCE
 * http://www.tiie.fr
 *
 * main developper : Yves Piel ( yvespielusenet AT free.fr )
 */

/*
 * AskForUnknownFontPanel.java
 *
 * Created on 1 mars 2007, 17:03
 */

/*
 * Modification history:
 *  Author________ Reference Date_______ Modification___________________________
 *  Eliott Bartley #EB080825 2008y08M25d Commented out sections that are not
 *                                        1.5 compatible
 */

package com.rie.rieps.engine.fonts;

import java.awt.Font;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JDialog;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.text.DefaultFormatter;

/**
 *
 * @author  Yves Piel
 */
public class AskForUnknownFontPanel extends javax.swing.JPanel {
    
    private JDialog jd;
    private Font awt;
    private String[] availableDevicePSFont;
    
    private boolean linked = false;
    
    /** Creates new form AskForUnknownFontPanel */
    public AskForUnknownFontPanel(JDialog jd, Font awt, String[] availableDevicePSFont) {
        this.jd = jd;
        this.awt =awt;
        this.availableDevicePSFont = availableDevicePSFont;
        initComponents();
    }
    
    public boolean isLinked() {
        return linked;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jcbStyle = new javax.swing.JCheckBox();
        jrbPlain = new javax.swing.JRadioButton();
        jrbItalic = new javax.swing.JRadioButton();
        jrbBold = new javax.swing.JRadioButton();
        jcbSize = new javax.swing.JCheckBox();
        jtfAWTSize = new javax.swing.JTextField();
        jtfAWTName = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jtfMatA = new javax.swing.JTextField();
        jtfMatB = new javax.swing.JTextField();
        jtfMatC = new javax.swing.JTextField();
        jtfMatD = new javax.swing.JTextField();
        jtfMatE = new javax.swing.JTextField();
        jtfMatF = new javax.swing.JTextField();
        jcbPSFamily = new javax.swing.JComboBox();
        jtfPSSize = new JFormattedTextField(new DecimalFormat("##0.00"));
        jbLink = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)), "AWT/System Font"));
        if(this.awt.getStyle() == Font.ITALIC+Font.BOLD || this.awt.getStyle() == Font.BOLD){
            this.jrbBold.setSelected(true);
        }

        if(this.awt.getStyle() == Font.ITALIC+Font.BOLD || this.awt.getStyle() == Font.ITALIC){
            this.jrbItalic.setSelected(true);
        }
        jLabel1.setText("Family :");

        jcbStyle.setText("Style :");
        jcbStyle.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jcbStyle.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jcbStyle.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jcbStyleItemStateChanged(evt);
            }
        });

        jrbPlain.setText("Plain");
        jrbPlain.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jrbPlain.setMargin(new java.awt.Insets(0, 0, 0, 0));

        jrbItalic.setText("Italic");
        jrbItalic.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jrbItalic.setMargin(new java.awt.Insets(0, 0, 0, 0));

        jrbBold.setText("Bold");
        jrbBold.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jrbBold.setMargin(new java.awt.Insets(0, 0, 0, 0));

        jcbSize.setText("Size :");
        jcbSize.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jcbSize.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jcbSize.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jcbSizeItemStateChanged(evt);
            }
        });

        jtfAWTSize.setEditable(false);
        this.jtfAWTSize.setText(this.awt.getSize2D()+"");

        jtfAWTName.setEditable(false);
        this.jtfAWTName.setText(this.awt.getFamily());

        //{ #EB080825 {
        /*}
        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jcbStyle)
                    .addComponent(jcbSize)
                    .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 57, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(19, 19, 19)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jrbPlain)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jrbItalic)
                        .addGap(6, 6, 6)
                        .addComponent(jrbBold))
                    .addComponent(jtfAWTSize, javax.swing.GroupLayout.PREFERRED_SIZE, 38, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jtfAWTName, javax.swing.GroupLayout.DEFAULT_SIZE, 457, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jtfAWTName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel1))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jcbStyle)
                    .addComponent(jrbPlain)
                    .addComponent(jrbItalic)
                    .addComponent(jrbBold))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jcbSize)
                    .addComponent(jtfAWTSize, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );
        //} */

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)), "Postscript Font"));
        jLabel2.setText("Family :");

        jLabel3.setText("Size :");

        jLabel4.setText("Matrix :");

        jtfMatA.setToolTipText("To set the matrix, set the font size to 0.0");
        jtfMatA.setPreferredSize(new java.awt.Dimension(69, 19));

        jtfMatB.setToolTipText("To set the matrix, set the font size to 0.0");
        jtfMatB.setPreferredSize(new java.awt.Dimension(69, 19));

        jtfMatC.setToolTipText("To set the matrix, set the font size to 0.0");
        jtfMatC.setPreferredSize(new java.awt.Dimension(69, 19));

        jtfMatD.setToolTipText("To set the matrix, set the font size to 0.0");
        jtfMatD.setPreferredSize(new java.awt.Dimension(69, 19));

        jtfMatE.setToolTipText("To set the matrix, set the font size to 0.0");
        jtfMatE.setPreferredSize(new java.awt.Dimension(69, 19));

        jtfMatF.setToolTipText("To set the matrix, set the font size to 0.0");
        jtfMatF.setPreferredSize(new java.awt.Dimension(69, 19));

        jcbPSFamily.setEditable(true);
        jcbPSFamily.setModel(new DefaultComboBoxModel(this.availableDevicePSFont));
        this.jcbPSFamily.setSelectedItem("");

        //{ #EB080825 {
        /*}
        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jLabel4)
                    .addComponent(jLabel2)
                    .addComponent(jLabel3))
                .addGap(35, 35, 35)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jcbPSFamily, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(jtfPSSize, javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jtfMatA, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jtfMatB, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jtfMatC, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jtfMatD, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jtfMatE, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jtfMatF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(18, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(jcbPSFamily, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(jtfPSSize, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(jtfMatA, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jtfMatB, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jtfMatC, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jtfMatD, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jtfMatE, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jtfMatF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        //} */

        jbLink.setText("Link");
        jbLink.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbLinkActionPerformed(evt);
            }
        });

        jButton2.setText("Cancel");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        //{ #EB080825 {
        /*}
        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jButton2)
                        .addGap(11, 11, 11)
                        .addComponent(jbLink, javax.swing.GroupLayout.PREFERRED_SIZE, 70, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButton2)
                    .addComponent(jbLink))
                .addContainerGap(16, Short.MAX_VALUE))
        );
        //} */
    }// </editor-fold>//GEN-END:initComponents

    private void jcbSizeItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jcbSizeItemStateChanged
        if(evt.getStateChange() == evt.SELECTED){
            this.jcbStyle.setSelected(true);
            this.jtfPSSize.setValue(new Float(this.awt.getSize2D()));
        }
    }//GEN-LAST:event_jcbSizeItemStateChanged

    private void jcbStyleItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jcbStyleItemStateChanged
        if(evt.getStateChange() == evt.DESELECTED){
            this.jcbSize.setSelected(false);
        }
    }//GEN-LAST:event_jcbStyleItemStateChanged
    
    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        this.jd.dispose();
    }//GEN-LAST:event_jButton2ActionPerformed
    
    private void jbLinkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbLinkActionPerformed
        if(!this.valide()){
            return;
        }
        this.linked = true;
        jd.dispose();
    }//GEN-LAST:event_jbLinkActionPerformed
    
    private boolean valide(){
        boolean ret = true;
        String family = ((String)this.jcbPSFamily.getSelectedItem()).trim();
        if(family.compareTo("") == 0){
            JOptionPane.showMessageDialog(null, "Postscript font family name is malformed", "The font family name is empty.", JOptionPane.ERROR_MESSAGE);
            ret = false;
        }
        return ret;
    }
    
    /** Return the ID of the linked AWT Font.
     * The ID is like : FontFamily[-style][-size]
     */
    public String getAWTID(){
        StringBuffer sb = new StringBuffer();
        
        sb.append(this.awt.getFamily());
        
        if(this.jcbStyle.isSelected()){
            sb.append("-");
            sb.append(this.awt.getStyle());
            
            if(this.jcbSize.isSelected()){
                sb.append("-");
                sb.append(this.awt.getSize2D());
            }
        }
        
        return sb.toString();
    }
    
    
    public PSFont getPSFont(){
        PSFont psfnt = new PSFont();
        psfnt = psfnt.setName(((String)this.jcbPSFamily.getSelectedItem()).trim());
        
        Number n = (Number)this.jtfPSSize.getValue();
        float f  = 0f;
        if(n != null){
            f = n.floatValue();
        }
        psfnt = psfnt.setSize(f);
        
        String atA = this.jtfMatA.getText().trim();
        String atB = this.jtfMatB.getText().trim();
        String atC = this.jtfMatC.getText().trim();
        String atD = this.jtfMatD.getText().trim();
        String atE = this.jtfMatE.getText().trim();
        String atF = this.jtfMatF.getText().trim();
        
        if(atA.compareTo("") != 0){
            psfnt = psfnt.setMatrix_a(atA);
        }
        
        if(atB.compareTo("") != 0){
            psfnt = psfnt.setMatrix_b(atB);
        }
        
        if(atC.compareTo("") != 0){
            psfnt = psfnt.setMatrix_c(atC);
        }
        
        if(atD.compareTo("") != 0){
            psfnt = psfnt.setMatrix_d(atD);
        }
        
        if(atE.compareTo("") != 0){
            psfnt = psfnt.setMatrix_e(atE);
        }
        
        if(atF.compareTo("") != 0){
            psfnt = psfnt.setMatrix_f(atF);
        }
        
        return psfnt;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JButton jbLink;
    private javax.swing.JComboBox jcbPSFamily;
    private javax.swing.JCheckBox jcbSize;
    private javax.swing.JCheckBox jcbStyle;
    private javax.swing.JRadioButton jrbBold;
    private javax.swing.JRadioButton jrbItalic;
    private javax.swing.JRadioButton jrbPlain;
    private javax.swing.JTextField jtfAWTName;
    private javax.swing.JTextField jtfAWTSize;
    private javax.swing.JTextField jtfMatA;
    private javax.swing.JTextField jtfMatB;
    private javax.swing.JTextField jtfMatC;
    private javax.swing.JTextField jtfMatD;
    private javax.swing.JTextField jtfMatE;
    private javax.swing.JTextField jtfMatF;
    private javax.swing.JFormattedTextField jtfPSSize;
    // End of variables declaration//GEN-END:variables
    
}
