/*
 * Decompiled with CFR 0.152.
 */
package JSci.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JComponent;

public abstract class JDoubleBufferedComponent
extends JComponent {
    private Image buffer = null;
    private boolean doRedraw = true;

    public JDoubleBufferedComponent() {
        super.setDoubleBuffered(false);
    }

    public final void paintComponent(Graphics graphics) {
        Insets insets = this.getInsets();
        if (this.doRedraw) {
            this.doRedraw = false;
            int n = this.getWidth() - insets.left - insets.right;
            int n2 = this.getHeight() - insets.top - insets.bottom;
            this.buffer = this.createImage(n, n2);
            if (this.buffer == null) {
                return;
            }
            Graphics graphics2 = this.buffer.getGraphics();
            Color color = graphics2.getColor();
            graphics2.setColor(this.getBackground());
            graphics2.fillRect(insets.left, insets.top, n, n2);
            graphics2.setColor(color);
            this.offscreenPaint(graphics2);
        }
        graphics.drawImage(this.buffer, insets.left, insets.top, null);
    }

    public final void update(Graphics graphics) {
        this.paint(graphics);
    }

    public final void printComponent(Graphics graphics) {
        this.offscreenPaint(graphics);
    }

    public final void setDoubleBuffered(boolean bl) {
        throw new IllegalArgumentException();
    }

    public final boolean isDoubleBuffered() {
        return true;
    }

    public final void redraw() {
        this.doRedraw = true;
        this.repaint();
    }

    protected final Graphics getOffscreenGraphics() {
        return this.buffer != null ? this.buffer.getGraphics() : null;
    }

    protected abstract void offscreenPaint(Graphics var1);
}

