/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.vectors;

import JSci.maths.ExtraMath;
import JSci.maths.Mapping;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.AbstractIntegerVector;
import JSci.maths.vectors.ComplexVector;
import JSci.maths.vectors.IntegerVector;
import JSci.maths.vectors.MathVector;
import JSci.maths.vectors.VectorDimensionException;

public class DoubleVector
extends AbstractDoubleVector {
    protected double[] vector;

    public DoubleVector(int n) {
        super(n);
        this.vector = new double[n];
    }

    public DoubleVector(double[] dArray) {
        super(dArray.length);
        this.vector = dArray;
    }

    public boolean equals(Object object, double d) {
        if (object != null && object instanceof AbstractDoubleVector && this.N == ((AbstractDoubleVector)object).N) {
            AbstractDoubleVector abstractDoubleVector = (AbstractDoubleVector)object;
            double d2 = 0.0;
            for (int i = 0; i < this.N; ++i) {
                double d3 = this.vector[i] - abstractDoubleVector.getComponent(i);
                d2 += d3 * d3;
            }
            return d2 <= d * d;
        }
        return false;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(8 * this.N);
        for (n = 0; n < this.N - 1; ++n) {
            stringBuffer.append(this.vector[n]);
            stringBuffer.append(',');
        }
        stringBuffer.append(this.vector[n]);
        return stringBuffer.toString();
    }

    public AbstractIntegerVector toIntegerVector() {
        int[] nArray = new int[this.N];
        for (int i = 0; i < this.N; ++i) {
            nArray[i] = Math.round((float)this.vector[i]);
        }
        return new IntegerVector(nArray);
    }

    public AbstractComplexVector toComplexVector() {
        return new ComplexVector(this.vector, new double[this.N]);
    }

    public double getComponent(int n) {
        if (n >= 0 && n < this.N) {
            return this.vector[n];
        }
        throw new VectorDimensionException(MathVector.getInvalidComponentMsg(n));
    }

    public void setComponent(int n, double d) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException(MathVector.getInvalidComponentMsg(n));
        }
        this.vector[n] = d;
    }

    public double norm(int n) {
        double d = Math.pow(Math.abs(this.vector[0]), n);
        for (int i = 1; i < this.N; ++i) {
            d += Math.pow(Math.abs(this.vector[i]), n);
        }
        return Math.pow(d, 1.0 / (double)n);
    }

    public double norm() {
        double d = this.vector[0];
        for (int i = 1; i < this.N; ++i) {
            d = ExtraMath.hypot(d, this.vector[i]);
        }
        return d;
    }

    public double infNorm() {
        double d = Math.abs(this.vector[0]);
        for (int i = 1; i < this.N; ++i) {
            double d2 = Math.abs(this.vector[i]);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public AbelianGroup.Member negate() {
        double[] dArray = new double[this.N];
        dArray[0] = -this.vector[0];
        for (int i = 1; i < this.N; ++i) {
            dArray[i] = -this.vector[i];
        }
        return new DoubleVector(dArray);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof AbstractDoubleVector) {
            return this.add((AbstractDoubleVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector add(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector instanceof DoubleVector) {
            return this.add((DoubleVector)abstractDoubleVector);
        }
        if (this.N == abstractDoubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vector[0] + abstractDoubleVector.getComponent(0);
            for (int i = 1; i < this.N; ++i) {
                dArray[i] = this.vector[i] + abstractDoubleVector.getComponent(i);
            }
            return new DoubleVector(dArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public DoubleVector add(DoubleVector doubleVector) {
        if (this.N == doubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vector[0] + doubleVector.vector[0];
            for (int i = 1; i < this.N; ++i) {
                dArray[i] = this.vector[i] + doubleVector.vector[i];
            }
            return new DoubleVector(dArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof AbstractDoubleVector) {
            return this.subtract((AbstractDoubleVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector subtract(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector instanceof DoubleVector) {
            return this.subtract((DoubleVector)abstractDoubleVector);
        }
        if (this.N == abstractDoubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vector[0] - abstractDoubleVector.getComponent(0);
            for (int i = 1; i < this.N; ++i) {
                dArray[i] = this.vector[i] - abstractDoubleVector.getComponent(i);
            }
            return new DoubleVector(dArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public DoubleVector subtract(DoubleVector doubleVector) {
        if (this.N == doubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vector[0] - doubleVector.vector[0];
            for (int i = 1; i < this.N; ++i) {
                dArray[i] = this.vector[i] - doubleVector.vector[i];
            }
            return new DoubleVector(dArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector scalarMultiply(double d) {
        double[] dArray = new double[this.N];
        dArray[0] = d * this.vector[0];
        for (int i = 1; i < this.N; ++i) {
            dArray[i] = d * this.vector[i];
        }
        return new DoubleVector(dArray);
    }

    public VectorSpace.Member scalarDivide(Field.Member member) {
        if (member instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector scalarDivide(double d) {
        double[] dArray = new double[this.N];
        dArray[0] = this.vector[0] / d;
        for (int i = 1; i < this.N; ++i) {
            dArray[i] = this.vector[i] / d;
        }
        return new DoubleVector(dArray);
    }

    public double scalarProduct(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector instanceof DoubleVector) {
            return this.scalarProduct((DoubleVector)abstractDoubleVector);
        }
        if (this.N == abstractDoubleVector.N) {
            double d = this.vector[0] * abstractDoubleVector.getComponent(0);
            for (int i = 1; i < this.N; ++i) {
                d += this.vector[i] * abstractDoubleVector.getComponent(i);
            }
            return d;
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public double scalarProduct(DoubleVector doubleVector) {
        if (this.N == doubleVector.N) {
            double d = this.vector[0] * doubleVector.vector[0];
            for (int i = 1; i < this.N; ++i) {
                d += this.vector[i] * doubleVector.vector[i];
            }
            return d;
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractDoubleVector mapComponents(Mapping mapping) {
        double[] dArray = new double[this.N];
        dArray[0] = mapping.map(this.vector[0]);
        for (int i = 1; i < this.N; ++i) {
            dArray[i] = mapping.map(this.vector[i]);
        }
        return new DoubleVector(dArray);
    }
}

