/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.statistics;

import JSci.maths.SpecialMath;
import JSci.maths.statistics.OutOfRangeException;
import JSci.maths.statistics.ProbabilityDistribution;

public final class WeibullDistribution
extends ProbabilityDistribution {
    private double shape;

    public WeibullDistribution(double d) {
        if (d <= 0.0) {
            throw new OutOfRangeException("The shape parameter should be positive.");
        }
        this.shape = d;
    }

    public double getShapeParameter() {
        return this.shape;
    }

    public double getMean() {
        return SpecialMath.gamma(1.0 + 1.0 / this.shape);
    }

    public double getVariance() {
        return SpecialMath.gamma(1.0 + 2.0 / this.shape) - this.getMean() * this.getMean();
    }

    public double probability(double d) {
        this.checkRange(d, 0.0, Double.MAX_VALUE);
        double d2 = Math.pow(d, this.shape);
        return this.shape * d2 / d * Math.exp(-d2);
    }

    public double cumulative(double d) {
        this.checkRange(d, 0.0, Double.MAX_VALUE);
        return 1.0 - Math.exp(-Math.pow(d, this.shape));
    }

    public double inverse(double d) {
        this.checkRange(d);
        return Math.pow(-Math.log(1.0 - d), 1.0 / this.shape);
    }
}

