/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.maths.ArrayMath;
import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.DimensionException;
import JSci.maths.LinearMath;
import JSci.maths.MaximumIterationsExceededException;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractComplexSquareMatrix;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import JSci.maths.matrices.Matrix;
import JSci.maths.matrices.MatrixDimensionException;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.ComplexVector;

public class ComplexSquareMatrix
extends AbstractComplexSquareMatrix {
    protected final double[][] matrixRe;
    protected final double[][] matrixIm;

    public ComplexSquareMatrix(double[][] dArray, double[][] dArray2) {
        super(dArray.length);
        if (!ArrayMath.isSquare(dArray)) {
            throw new MatrixDimensionException("Array is not square.");
        }
        if (!ArrayMath.isSquare(dArray2)) {
            throw new MatrixDimensionException("Array is not square.");
        }
        this.matrixRe = dArray;
        this.matrixIm = dArray2;
    }

    public ComplexSquareMatrix(int n) {
        this(new double[n][n], new double[n][n]);
    }

    public ComplexSquareMatrix(Complex[][] complexArray) {
        this(complexArray.length);
        for (int i = 0; i < this.numRows; ++i) {
            if (complexArray[i].length != complexArray.length) {
                throw new MatrixDimensionException("Array is not square.");
            }
            for (int j = 0; j < this.numCols; ++j) {
                this.matrixRe[i][j] = complexArray[i][j].real();
                this.matrixIm[i][j] = complexArray[i][j].imag();
            }
        }
    }

    public ComplexSquareMatrix(AbstractComplexVector[] abstractComplexVectorArray) {
        this(abstractComplexVectorArray.length);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                this.matrixRe[i][j] = abstractComplexVectorArray[j].getComponent(i).real();
                this.matrixIm[i][j] = abstractComplexVectorArray[j].getComponent(i).imag();
            }
        }
    }

    public boolean equals(AbstractComplexMatrix abstractComplexMatrix, double d) {
        if (abstractComplexMatrix != null && this.numRows == abstractComplexMatrix.rows() && this.numCols == abstractComplexMatrix.columns()) {
            double d2 = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    double d3 = this.matrixRe[i][j] - abstractComplexMatrix.getRealElement(i, j);
                    double d4 = this.matrixIm[i][j] - abstractComplexMatrix.getImagElement(i, j);
                    d2 += d3 * d3 + d4 * d4;
                }
            }
            return d2 <= d * d;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                stringBuffer.append(Complex.toString(this.matrixRe[i][j], this.matrixIm[i][j]));
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public AbstractDoubleMatrix real() {
        return new DoubleSquareMatrix(this.matrixRe);
    }

    public AbstractDoubleMatrix imag() {
        return new DoubleSquareMatrix(this.matrixIm);
    }

    public Complex getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            return new Complex(this.matrixRe[n][n2], this.matrixIm[n][n2]);
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public double getRealElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            return this.matrixRe[n][n2];
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public double getImagElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            return this.matrixIm[n][n2];
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, Complex complex) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols) {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.matrixRe[n][n2] = complex.real();
        this.matrixIm[n][n2] = complex.imag();
    }

    public void setElement(int n, int n2, double d, double d2) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols) {
            throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
        }
        this.matrixRe[n][n2] = d;
        this.matrixIm[n][n2] = d2;
    }

    public double infNorm() {
        double d = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.numCols; ++j) {
                d2 += Math.sqrt(this.matrixRe[i][j] * this.matrixRe[i][j] + this.matrixIm[i][j] * this.matrixIm[i][j]);
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                d += this.matrixRe[i][j] * this.matrixRe[i][j] + this.matrixIm[i][j] * this.matrixIm[i][j];
            }
        }
        return Math.sqrt(d);
    }

    public Complex det() {
        if (this.numRows == 2) {
            return new Complex(this.matrixRe[0][0] * this.matrixRe[1][1] - this.matrixIm[0][0] * this.matrixIm[1][1] - this.matrixRe[0][1] * this.matrixRe[1][0] + this.matrixIm[0][1] * this.matrixIm[1][0], this.matrixRe[0][0] * this.matrixIm[1][1] + this.matrixIm[0][0] * this.matrixRe[1][1] - this.matrixRe[0][1] * this.matrixIm[1][0] - this.matrixIm[0][1] * this.matrixRe[1][0]);
        }
        ComplexSquareMatrix[] complexSquareMatrixArray = (ComplexSquareMatrix[])this.luDecompose(null);
        double d = complexSquareMatrixArray[1].matrixRe[0][0];
        double d2 = complexSquareMatrixArray[1].matrixIm[0][0];
        for (int i = 1; i < this.numRows; ++i) {
            double d3 = d * complexSquareMatrixArray[1].matrixRe[i][i] - d2 * complexSquareMatrixArray[1].matrixIm[i][i];
            d2 = d * complexSquareMatrixArray[1].matrixIm[i][i] + d2 * complexSquareMatrixArray[1].matrixRe[i][i];
            d = d3;
        }
        return new Complex(d * (double)this.LUpivot[this.numRows], d2 * (double)this.LUpivot[this.numRows]);
    }

    public Complex trace() {
        double d = this.matrixRe[0][0];
        double d2 = this.matrixIm[0][0];
        for (int i = 1; i < this.numRows; ++i) {
            d += this.matrixRe[i][i];
            d2 += this.matrixIm[i][i];
        }
        return new Complex(d, d2);
    }

    public AbelianGroup.Member negate() {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = -this.matrixRe[i][0];
            dArray2[i][0] = -this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = -this.matrixRe[i][j];
                dArray2[i][j] = -this.matrixIm[i][j];
            }
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public AbstractComplexSquareMatrix add(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (abstractComplexSquareMatrix instanceof ComplexSquareMatrix) {
            return this.add((ComplexSquareMatrix)abstractComplexSquareMatrix);
        }
        if (this.numRows == abstractComplexSquareMatrix.rows() && this.numCols == abstractComplexSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i][0] = this.matrixRe[i][0] + abstractComplexSquareMatrix.getElement(i, 0).real();
                dArray2[i][0] = this.matrixIm[i][0] + abstractComplexSquareMatrix.getElement(i, 0).imag();
                for (int j = 1; j < this.numCols; ++j) {
                    dArray[i][j] = this.matrixRe[i][j] + abstractComplexSquareMatrix.getElement(i, j).real();
                    dArray2[i][j] = this.matrixIm[i][j] + abstractComplexSquareMatrix.getElement(i, j).imag();
                }
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix add(ComplexSquareMatrix complexSquareMatrix) {
        if (this.numRows == complexSquareMatrix.numRows && this.numCols == complexSquareMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i][0] = this.matrixRe[i][0] + complexSquareMatrix.matrixRe[i][0];
                dArray2[i][0] = this.matrixIm[i][0] + complexSquareMatrix.matrixIm[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    dArray[i][j] = this.matrixRe[i][j] + complexSquareMatrix.matrixRe[i][j];
                    dArray2[i][j] = this.matrixIm[i][j] + complexSquareMatrix.matrixIm[i][j];
                }
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexSquareMatrix subtract(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (abstractComplexSquareMatrix instanceof ComplexSquareMatrix) {
            return this.subtract((ComplexSquareMatrix)abstractComplexSquareMatrix);
        }
        if (this.numRows == abstractComplexSquareMatrix.rows() && this.numCols == abstractComplexSquareMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i][0] = this.matrixRe[i][0] - abstractComplexSquareMatrix.getElement(i, 0).real();
                dArray2[i][0] = this.matrixIm[i][0] - abstractComplexSquareMatrix.getElement(i, 0).imag();
                for (int j = 1; j < this.numCols; ++j) {
                    dArray[i][j] = this.matrixRe[i][j] - abstractComplexSquareMatrix.getElement(i, j).real();
                    dArray2[i][j] = this.matrixIm[i][j] - abstractComplexSquareMatrix.getElement(i, j).imag();
                }
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix subtract(ComplexSquareMatrix complexSquareMatrix) {
        if (this.numRows == complexSquareMatrix.numRows && this.numCols == complexSquareMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i][0] = this.matrixRe[i][0] - complexSquareMatrix.matrixRe[i][0];
                dArray2[i][0] = this.matrixIm[i][0] - complexSquareMatrix.matrixIm[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    dArray[i][j] = this.matrixRe[i][j] - complexSquareMatrix.matrixRe[i][j];
                    dArray2[i][j] = this.matrixIm[i][j] - complexSquareMatrix.matrixIm[i][j];
                }
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexMatrix scalarMultiply(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = this.matrixRe[i][0] * d - this.matrixIm[i][0] * d2;
            dArray2[i][0] = this.matrixRe[i][0] * d2 + this.matrixIm[i][0] * d;
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = this.matrixRe[i][j] * d - this.matrixIm[i][j] * d2;
                dArray2[i][j] = this.matrixRe[i][j] * d2 + this.matrixIm[i][j] * d;
            }
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix scalarMultiply(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        double[][] dArray2 = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = d * this.matrixRe[i][0];
            dArray2[i][0] = d * this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = d * this.matrixRe[i][j];
                dArray2[i][j] = d * this.matrixIm[i][j];
            }
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public AbstractComplexVector multiply(AbstractComplexVector abstractComplexVector) {
        if (this.numCols == abstractComplexVector.dimension()) {
            double[] dArray = new double[this.numRows];
            double[] dArray2 = new double[this.numRows];
            for (int i = 0; i < this.numRows; ++i) {
                Complex complex = abstractComplexVector.getComponent(0);
                dArray[i] = this.matrixRe[i][0] * complex.real() - this.matrixIm[i][0] * complex.imag();
                dArray2[i] = this.matrixIm[i][0] * complex.real() + this.matrixRe[i][0] * complex.imag();
                for (int j = 1; j < this.numCols; ++j) {
                    complex = abstractComplexVector.getComponent(j);
                    int n = i;
                    dArray[n] = dArray[n] + (this.matrixRe[i][j] * complex.real() - this.matrixIm[i][j] * complex.imag());
                    int n2 = i;
                    dArray2[n2] = dArray2[n2] + (this.matrixIm[i][j] * complex.real() + this.matrixRe[i][j] * complex.imag());
                }
            }
            return new ComplexVector(dArray, dArray2);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractComplexSquareMatrix multiply(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        if (abstractComplexSquareMatrix instanceof ComplexSquareMatrix) {
            return this.multiply((ComplexSquareMatrix)abstractComplexSquareMatrix);
        }
        if (this.numCols == abstractComplexSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    Complex complex = abstractComplexSquareMatrix.getElement(0, j);
                    dArray[i][j] = this.matrixRe[i][0] * complex.real() - this.matrixIm[i][0] * complex.imag();
                    dArray2[i][j] = this.matrixIm[i][0] * complex.real() + this.matrixRe[i][0] * complex.imag();
                    for (int k = 1; k < this.numCols; ++k) {
                        complex = abstractComplexSquareMatrix.getElement(k, j);
                        double[] dArray3 = dArray[i];
                        int n = j;
                        dArray3[n] = dArray3[n] + (this.matrixRe[i][k] * complex.real() - this.matrixIm[i][k] * complex.imag());
                        double[] dArray4 = dArray2[i];
                        int n2 = j;
                        dArray4[n2] = dArray4[n2] + (this.matrixIm[i][k] * complex.real() + this.matrixRe[i][k] * complex.imag());
                    }
                }
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexSquareMatrix multiply(ComplexSquareMatrix complexSquareMatrix) {
        if (this.numCols == complexSquareMatrix.numRows) {
            double[][] dArray = new double[this.numRows][this.numCols];
            double[][] dArray2 = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    dArray[i][j] = this.matrixRe[i][0] * complexSquareMatrix.matrixRe[0][j] - this.matrixIm[i][0] * complexSquareMatrix.matrixIm[0][j];
                    dArray2[i][j] = this.matrixIm[i][0] * complexSquareMatrix.matrixRe[0][j] + this.matrixRe[i][0] * complexSquareMatrix.matrixIm[0][j];
                    for (int k = 1; k < this.numCols; ++k) {
                        double[] dArray3 = dArray[i];
                        int n = j;
                        dArray3[n] = dArray3[n] + (this.matrixRe[i][k] * complexSquareMatrix.matrixRe[k][j] - this.matrixIm[i][k] * complexSquareMatrix.matrixIm[k][j]);
                        double[] dArray4 = dArray2[i];
                        int n2 = j;
                        dArray4[n2] = dArray4[n2] + (this.matrixIm[i][k] * complexSquareMatrix.matrixRe[k][j] + this.matrixRe[i][k] * complexSquareMatrix.matrixIm[k][j]);
                    }
                }
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractComplexSquareMatrix directSum(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        int n;
        int n2;
        double[][] dArray = new double[this.numRows + abstractComplexSquareMatrix.numRows][this.numCols + abstractComplexSquareMatrix.numCols];
        double[][] dArray2 = new double[this.numRows + abstractComplexSquareMatrix.numRows][this.numCols + abstractComplexSquareMatrix.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                dArray[n2][n] = this.matrixRe[n2][n];
                dArray2[n2][n] = this.matrixIm[n2][n];
            }
        }
        for (n2 = 0; n2 < abstractComplexSquareMatrix.numRows; ++n2) {
            for (n = 0; n < abstractComplexSquareMatrix.numCols; ++n) {
                Complex complex = abstractComplexSquareMatrix.getElement(n2, n);
                dArray[n2 + this.numRows][n + this.numCols] = complex.real();
                dArray2[n2 + this.numRows][n + this.numCols] = complex.imag();
            }
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public AbstractComplexSquareMatrix tensor(AbstractComplexSquareMatrix abstractComplexSquareMatrix) {
        double[][] dArray = new double[this.numRows * abstractComplexSquareMatrix.numRows][this.numCols * abstractComplexSquareMatrix.numCols];
        double[][] dArray2 = new double[this.numRows * abstractComplexSquareMatrix.numRows][this.numCols * abstractComplexSquareMatrix.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int n = 0;
                while (n < abstractComplexSquareMatrix.numRows) {
                    for (int k = 0; k < abstractComplexSquareMatrix.numCols; ++k) {
                        Complex complex = abstractComplexSquareMatrix.getElement(n, k);
                        dArray[i * abstractComplexSquareMatrix.numRows + n][j * abstractComplexSquareMatrix.numCols + k] = this.matrixRe[i][j] * complex.real() - this.matrixIm[i][j] * complex.imag();
                        dArray2[i * abstractComplexSquareMatrix.numRows + n][j * abstractComplexSquareMatrix.numCols + k] = this.matrixIm[i][j] * complex.real() + this.matrixRe[i][j] * complex.imag();
                    }
                    ++j;
                }
            }
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix hermitianAdjoint() {
        double[][] dArray = new double[this.numCols][this.numRows];
        double[][] dArray2 = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[0][i] = this.matrixRe[i][0];
            dArray2[0][i] = -this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                dArray[j][i] = this.matrixRe[i][j];
                dArray2[j][i] = -this.matrixIm[i][j];
            }
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public AbstractComplexMatrix conjugate() {
        double[][] dArray = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = -this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = -this.matrixIm[i][j];
            }
        }
        return new ComplexSquareMatrix(this.matrixRe, dArray);
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.numCols][this.numRows];
        double[][] dArray2 = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[0][i] = this.matrixRe[i][0];
            dArray2[0][i] = this.matrixIm[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                dArray[j][i] = this.matrixRe[i][j];
                dArray2[j][i] = this.matrixIm[i][j];
            }
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public AbstractComplexSquareMatrix inverse() {
        int n;
        int n2 = this.numRows;
        double[][] dArray = new double[n2][n2];
        double[][] dArray2 = new double[n2][n2];
        double[][] dArray3 = new double[n2][n2];
        double[][] dArray4 = new double[n2][n2];
        ComplexSquareMatrix[] complexSquareMatrixArray = (ComplexSquareMatrix[])this.luDecompose(null);
        double d = complexSquareMatrixArray[0].matrixRe[0][0] * complexSquareMatrixArray[0].matrixRe[0][0] + complexSquareMatrixArray[0].matrixIm[0][0] * complexSquareMatrixArray[0].matrixIm[0][0];
        dArray[0][0] = complexSquareMatrixArray[0].matrixRe[0][0] / d;
        dArray2[0][0] = -complexSquareMatrixArray[0].matrixIm[0][0] / d;
        d = complexSquareMatrixArray[1].matrixRe[0][0] * complexSquareMatrixArray[1].matrixRe[0][0] + complexSquareMatrixArray[1].matrixIm[0][0] * complexSquareMatrixArray[1].matrixIm[0][0];
        dArray3[0][0] = complexSquareMatrixArray[1].matrixRe[0][0] / d;
        dArray4[0][0] = -complexSquareMatrixArray[1].matrixIm[0][0] / d;
        for (n = 1; n < n2; ++n) {
            d = complexSquareMatrixArray[0].matrixRe[n][n] * complexSquareMatrixArray[0].matrixRe[n][n] + complexSquareMatrixArray[0].matrixIm[n][n] * complexSquareMatrixArray[0].matrixIm[n][n];
            dArray[n][n] = complexSquareMatrixArray[0].matrixRe[n][n] / d;
            dArray2[n][n] = -complexSquareMatrixArray[0].matrixIm[n][n] / d;
            d = complexSquareMatrixArray[1].matrixRe[n][n] * complexSquareMatrixArray[1].matrixRe[n][n] + complexSquareMatrixArray[1].matrixIm[n][n] * complexSquareMatrixArray[1].matrixIm[n][n];
            dArray3[n][n] = complexSquareMatrixArray[1].matrixRe[n][n] / d;
            dArray4[n][n] = -complexSquareMatrixArray[1].matrixIm[n][n] / d;
        }
        for (n = 0; n < n2 - 1; ++n) {
            for (int i = n + 1; i < n2; ++i) {
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                for (int j = n; j < i; ++j) {
                    d2 -= complexSquareMatrixArray[0].matrixRe[i][j] * dArray[j][n] - complexSquareMatrixArray[0].matrixIm[i][j] * dArray2[j][n];
                    d3 -= complexSquareMatrixArray[0].matrixIm[i][j] * dArray[j][n] + complexSquareMatrixArray[0].matrixRe[i][j] * dArray2[j][n];
                    d4 -= dArray3[n][j] * complexSquareMatrixArray[1].matrixRe[j][i] - dArray4[n][j] * complexSquareMatrixArray[1].matrixIm[j][i];
                    d5 -= dArray4[n][j] * complexSquareMatrixArray[1].matrixRe[j][i] + dArray3[n][j] * complexSquareMatrixArray[1].matrixIm[j][i];
                }
                d = complexSquareMatrixArray[0].matrixRe[i][i] * complexSquareMatrixArray[0].matrixRe[i][i] + complexSquareMatrixArray[0].matrixIm[i][i] * complexSquareMatrixArray[0].matrixIm[i][i];
                dArray[i][n] = (d2 * complexSquareMatrixArray[0].matrixRe[i][i] + d3 * complexSquareMatrixArray[0].matrixIm[i][i]) / d;
                dArray2[i][n] = (d3 * complexSquareMatrixArray[0].matrixRe[i][i] - d2 * complexSquareMatrixArray[0].matrixIm[i][i]) / d;
                d = complexSquareMatrixArray[1].matrixRe[i][i] * complexSquareMatrixArray[1].matrixRe[i][i] + complexSquareMatrixArray[1].matrixIm[i][i] * complexSquareMatrixArray[1].matrixIm[i][i];
                dArray3[n][i] = (d4 * complexSquareMatrixArray[1].matrixRe[i][i] + d5 * complexSquareMatrixArray[1].matrixIm[i][i]) / d;
                dArray4[n][i] = (d5 * complexSquareMatrixArray[1].matrixRe[i][i] - d4 * complexSquareMatrixArray[1].matrixIm[i][i]) / d;
            }
        }
        double[][] dArray5 = new double[n2][n2];
        double[][] dArray6 = new double[n2][n2];
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4;
            for (n4 = 0; n4 < i; ++n4) {
                for (n3 = i; n3 < n2; ++n3) {
                    double[] dArray7 = dArray5[i];
                    int n5 = this.LUpivot[n4];
                    dArray7[n5] = dArray7[n5] + (dArray3[i][n3] * dArray[n3][n4] - dArray4[i][n3] * dArray2[n3][n4]);
                    double[] dArray8 = dArray6[i];
                    int n6 = this.LUpivot[n4];
                    dArray8[n6] = dArray8[n6] + (dArray4[i][n3] * dArray[n3][n4] + dArray3[i][n3] * dArray2[n3][n4]);
                }
            }
            for (n4 = i; n4 < n2; ++n4) {
                for (n3 = n4; n3 < n2; ++n3) {
                    double[] dArray9 = dArray5[i];
                    int n7 = this.LUpivot[n4];
                    dArray9[n7] = dArray9[n7] + (dArray3[i][n3] * dArray[n3][n4] - dArray4[i][n3] * dArray2[n3][n4]);
                    double[] dArray10 = dArray6[i];
                    int n8 = this.LUpivot[n4];
                    dArray10[n8] = dArray10[n8] + (dArray4[i][n3] * dArray[n3][n4] + dArray3[i][n3] * dArray2[n3][n4]);
                }
            }
        }
        return new ComplexSquareMatrix(dArray5, dArray6);
    }

    public final AbstractComplexSquareMatrix[] luDecompose(int[] nArray) {
        int n;
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        int n2 = this.numRows;
        double[][] dArray = new double[n2][n2];
        double[][] dArray2 = new double[n2][n2];
        double[][] dArray3 = new double[n2][n2];
        double[][] dArray4 = new double[n2][n2];
        if (nArray == null) {
            nArray = new int[n2 + 1];
        }
        for (n = 0; n < n2; ++n) {
            nArray[n] = n;
        }
        nArray[n2] = 1;
        for (n = 0; n < n2; ++n) {
            double d;
            int n3;
            double d2;
            double d3;
            double d4;
            for (int i = 0; i < n; ++i) {
                double d5 = this.matrixRe[nArray[i]][n];
                d4 = this.matrixIm[nArray[i]][n];
                for (int j = 0; j < i; ++j) {
                    d5 -= dArray3[i][j] * dArray3[j][n] - dArray4[i][j] * dArray4[j][n];
                    d4 -= dArray4[i][j] * dArray3[j][n] + dArray3[i][j] * dArray4[j][n];
                }
                dArray3[i][n] = d5;
                dArray4[i][n] = d4;
            }
            double d6 = 0.0;
            int n4 = n;
            for (int i = n; i < n2; ++i) {
                double d7 = this.matrixRe[nArray[i]][n];
                double d8 = this.matrixIm[nArray[i]][n];
                for (int j = 0; j < n; ++j) {
                    d7 -= dArray3[i][j] * dArray3[j][n] - dArray4[i][j] * dArray4[j][n];
                    d8 -= dArray4[i][j] * dArray3[j][n] + dArray3[i][j] * dArray4[j][n];
                }
                dArray3[i][n] = d7;
                dArray4[i][n] = d8;
                double d9 = d7 * d7 + d8 * d8;
                if (!(d9 > d6)) continue;
                d6 = d9;
                n4 = i;
            }
            if (n4 != n) {
                double[] dArray5 = dArray3[n];
                dArray3[n] = dArray3[n4];
                dArray3[n4] = dArray5;
                dArray5 = dArray4[n];
                dArray4[n] = dArray4[n4];
                dArray4[n4] = dArray5;
                int n5 = nArray[n];
                nArray[n] = nArray[n4];
                nArray[n4] = n5;
                nArray[n2] = -nArray[n2];
            }
            d4 = dArray3[n][n];
            double d10 = dArray4[n][n];
            if (Math.abs(d4) < Math.abs(d10)) {
                d3 = d4 / d10;
                d2 = d4 * d3 + d10;
                for (n3 = n + 1; n3 < n2; ++n3) {
                    d = (dArray3[n3][n] * d3 + dArray4[n3][n]) / d2;
                    dArray4[n3][n] = (dArray4[n3][n] * d3 - dArray3[n3][n]) / d2;
                    dArray3[n3][n] = d;
                }
                continue;
            }
            d3 = d10 / d4;
            d2 = d4 + d10 * d3;
            for (n3 = n + 1; n3 < n2; ++n3) {
                d = (dArray3[n3][n] + dArray4[n3][n] * d3) / d2;
                dArray4[n3][n] = (dArray4[n3][n] - dArray3[n3][n] * d3) / d2;
                dArray3[n3][n] = d;
            }
        }
        for (n = 0; n < n2; ++n) {
            dArray[n][n] = 1.0;
            for (int i = n + 1; i < n2; ++i) {
                dArray[i][n] = dArray3[i][n];
                dArray2[i][n] = dArray4[i][n];
                dArray3[i][n] = 0.0;
                dArray4[i][n] = 0.0;
            }
        }
        this.LU = new ComplexSquareMatrix[2];
        this.LU[0] = new ComplexSquareMatrix(dArray, dArray2);
        this.LU[1] = new ComplexSquareMatrix(dArray3, dArray4);
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public AbstractComplexSquareMatrix[] luDecompose() {
        int n;
        int n2 = this.numRows;
        double[][] dArray = new double[n2][n2];
        double[][] dArray2 = new double[n2][n2];
        double[][] dArray3 = new double[n2][n2];
        double[][] dArray4 = new double[n2][n2];
        for (n = 0; n < n2; ++n) {
            double d;
            int n3;
            double d2;
            double d3;
            int n4;
            double d4;
            double d5;
            int n5;
            for (n5 = 0; n5 < n; ++n5) {
                d5 = this.matrixRe[n5][n];
                d4 = this.matrixIm[n5][n];
                for (n4 = 0; n4 < n5; ++n4) {
                    d5 -= dArray3[n5][n4] * dArray3[n4][n] - dArray4[n5][n4] * dArray4[n4][n];
                    d4 -= dArray4[n5][n4] * dArray3[n4][n] + dArray3[n5][n4] * dArray4[n4][n];
                }
                dArray3[n5][n] = d5;
                dArray4[n5][n] = d4;
            }
            for (n5 = n; n5 < n2; ++n5) {
                d5 = this.matrixRe[n5][n];
                d4 = this.matrixIm[n5][n];
                for (n4 = 0; n4 < n; ++n4) {
                    d5 -= dArray3[n5][n4] * dArray3[n4][n] - dArray4[n5][n4] * dArray4[n4][n];
                    d4 -= dArray4[n5][n4] * dArray3[n4][n] + dArray3[n5][n4] * dArray4[n4][n];
                }
                dArray3[n5][n] = d5;
                dArray4[n5][n] = d4;
            }
            double d6 = dArray3[n][n];
            double d7 = dArray4[n][n];
            if (Math.abs(d6) < Math.abs(d7)) {
                d3 = d6 / d7;
                d2 = d6 * d3 + d7;
                for (n3 = n + 1; n3 < n2; ++n3) {
                    d = (dArray3[n3][n] * d3 + dArray4[n3][n]) / d2;
                    dArray4[n3][n] = (dArray4[n3][n] * d3 - dArray3[n3][n]) / d2;
                    dArray3[n3][n] = d;
                }
                continue;
            }
            d3 = d7 / d6;
            d2 = d6 + d7 * d3;
            for (n3 = n + 1; n3 < n2; ++n3) {
                d = (dArray3[n3][n] + dArray4[n3][n] * d3) / d2;
                dArray4[n3][n] = (dArray4[n3][n] - dArray3[n3][n] * d3) / d2;
                dArray3[n3][n] = d;
            }
        }
        for (n = 0; n < n2; ++n) {
            dArray[n][n] = 1.0;
            for (int i = n + 1; i < n2; ++i) {
                dArray[i][n] = dArray3[i][n];
                dArray2[i][n] = dArray4[i][n];
                dArray3[i][n] = 0.0;
                dArray4[i][n] = 0.0;
            }
        }
        AbstractComplexSquareMatrix[] abstractComplexSquareMatrixArray = new ComplexSquareMatrix[]{new ComplexSquareMatrix(dArray, dArray2), new ComplexSquareMatrix(dArray3, dArray4)};
        return abstractComplexSquareMatrixArray;
    }

    public AbstractComplexSquareMatrix[] polarDecompose() {
        Complex complex;
        double[] dArray;
        int n = this.numRows;
        AbstractComplexVector[] abstractComplexVectorArray = new AbstractComplexVector[n];
        try {
            dArray = LinearMath.eigenSolveHermitian(this, abstractComplexVectorArray);
        }
        catch (MaximumIterationsExceededException maximumIterationsExceededException) {
            return null;
        }
        double[][] dArray2 = new double[n][n];
        double[][] dArray3 = new double[n][n];
        double[][] dArray4 = new double[n][n];
        double[][] dArray5 = new double[n][n];
        for (int i = 0; i < n; ++i) {
            double d = Math.abs(dArray[i]);
            complex = abstractComplexVectorArray[i].getComponent(0).conjugate();
            dArray2[i][0] = dArray[i] * complex.real() / d;
            dArray3[i][0] = dArray[i] * complex.imag() / d;
            dArray4[i][0] = d * complex.real();
            dArray5[i][0] = d * complex.imag();
            for (int j = 1; j < n; ++j) {
                complex = abstractComplexVectorArray[i].getComponent(j).conjugate();
                dArray2[i][j] = dArray[i] * complex.real() / d;
                dArray3[i][j] = dArray[i] * complex.imag() / d;
                dArray4[i][j] = d * complex.real();
                dArray5[i][j] = d * complex.imag();
            }
        }
        double[][] dArray6 = new double[n][n];
        double[][] dArray7 = new double[n][n];
        double[][] dArray8 = new double[n][n];
        double[][] dArray9 = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                complex = abstractComplexVectorArray[0].getComponent(i);
                dArray6[i][j] = dArray2[0][j] * complex.real() - dArray3[0][j] * complex.imag();
                dArray7[i][j] = dArray3[0][j] * complex.real() + dArray2[0][j] * complex.imag();
                dArray8[i][j] = dArray4[0][j] * complex.real() - dArray5[0][j] * complex.imag();
                dArray9[i][j] = dArray5[0][j] * complex.real() + dArray4[0][j] * complex.imag();
                for (int k = 1; k < n; ++k) {
                    complex = abstractComplexVectorArray[k].getComponent(i);
                    double[] dArray10 = dArray6[i];
                    int n2 = j;
                    dArray10[n2] = dArray10[n2] + (dArray2[k][j] * complex.real() - dArray3[k][j] * complex.imag());
                    double[] dArray11 = dArray7[i];
                    int n3 = j;
                    dArray11[n3] = dArray11[n3] + (dArray3[k][j] * complex.real() + dArray2[k][j] * complex.imag());
                    double[] dArray12 = dArray8[i];
                    int n4 = j;
                    dArray12[n4] = dArray12[n4] + (dArray4[k][j] * complex.real() - dArray5[k][j] * complex.imag());
                    double[] dArray13 = dArray9[i];
                    int n5 = j;
                    dArray13[n5] = dArray13[n5] + (dArray5[k][j] * complex.real() + dArray4[k][j] * complex.imag());
                }
            }
        }
        AbstractComplexSquareMatrix[] abstractComplexSquareMatrixArray = new ComplexSquareMatrix[]{new ComplexSquareMatrix(dArray6, dArray7), new ComplexSquareMatrix(dArray8, dArray9)};
        return abstractComplexSquareMatrixArray;
    }

    public AbstractComplexMatrix mapElements(ComplexMapping complexMapping) {
        Complex[][] complexArray = new Complex[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            complexArray[i][0] = complexMapping.map(this.matrixRe[i][0], this.matrixIm[i][0]);
            for (int j = 1; j < this.numCols; ++j) {
                complexArray[i][j] = complexMapping.map(this.matrixRe[i][j], this.matrixIm[i][j]);
            }
        }
        return new ComplexSquareMatrix(complexArray);
    }
}

