/*
 * Decompiled with CFR 0.152.
 */
package com.rie.rieps.simpletest;

import com.rie.rieps.engine.Document;
import com.rie.rieps.engine.Frame;
import com.rie.rieps.engine.Job;
import com.rie.rieps.engine.LineFormat;
import com.rie.rieps.engine.Page;
import com.rie.rieps.engine.TextParameter;
import com.rie.rieps.engine.color.Gray;
import com.rie.rieps.engine.fonts.PSFont;
import com.rie.rieps.engine.image.SmallGrayImage;
import com.rie.rieps.simpletest.GenPSFile;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.net.URL;
import javax.imageio.ImageIO;

public class VerySimpleExample {
    public static void main(String[] args) {
        try {
            if (args.length <= 0) {
                System.out.println("Test the Rieps java postscript library.\nUSAGE : java -cp rieps.jar com.rie.rieps.simpletest.VerySimpleExample output.ps");
                System.exit(0);
            }
            URL url = GenPSFile.class.getResource("duke.jpg");
            BufferedImage bufferedImage = ImageIO.read(url);
            SmallGrayImage bwi = new SmallGrayImage(0);
            bwi.load(bufferedImage);
            FileOutputStream os = new FileOutputStream(args[0]);
            Job job = Job.createPSTopLeftOriginJob(os, 595.0f, 842.0f);
            job.setAvailableDeviceFont(new String[]{"Times-Roman", "Helvetica", "Courier", "Times-Italic", "Times-Bold", "Helvetica-Bold"});
            job.askForUnmappedAWTFont(true);
            job.echoFontMapping(true);
            job.open();
            Document doc = job.createDocument(2);
            doc.open();
            Page p = doc.createPage();
            PSFont fnt = job.getPSFontFromAWT(new Font("DIALOG", 0, 12));
            String txt = "Here is a very long text into a frame. The text is vertically and horizontally centered. Broder of a frame can be configured for each side. You can choose the background color too and the text color. Moreover, you can set text padding and clip the text into the frame if it's too height.";
            LineFormat lf0 = new LineFormat(4.0f, new Gray(0.5f));
            LineFormat lf1 = new LineFormat(1.0f, new int[]{3, 5}, 0, Gray.BLACK);
            Frame frm = new Frame(100.0f, 100.0f, 100.0f, 200.0f, 15.0f, 15.0f, 15.0f, 15.0f, lf0, lf0, lf1, lf1, true, new Gray(0.8f), 30.0f, txt, fnt, new TextParameter(1, 1, Gray.BLACK, 30.0f, false));
            p.drawFrame(frm);
            frm = new Frame(300.0f, 200.0f, 100.0f, 200.0f, 15.0f, 15.0f, 15.0f, 15.0f, lf0, lf1, lf0, lf1, true, new Gray(0.8f), -30.0f, txt, fnt, new TextParameter(1, 1, Gray.BLACK, -30.0f, true));
            p.drawFrame(frm);
            p.setColor(new Gray(0.95f));
            p.setLineFormat(lf1);
            p.drawEllipse(150.0f, 550.0f, 100.0f, 150.0f, 50.0f, true, true);
            p.setColor(new Gray(0.95f));
            p.setLineFormat(lf0);
            p.drawRect(350.0f, 550.0f, 200.0f, 150.0f, 50.0f, 25.0f, true, true);
            doc.showPage(p);
            p.drawImage(500.0f, 200.0f, bwi, 100.0f, 100.0f);
            doc.showPage(p);
            doc.close();
            job.close();
        }
        catch (Exception e) {
            System.err.println("Error in the example : " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }
}

