/*
 * Decompiled with CFR 0.152.
 */
package Util;

import java.text.Format;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18N {
    private I18N() {
    }

    public static String get(String name, Object ... params) {
        String message = I18N.getMessage(name);
        I18N.resolveParams(params);
        return I18N.formatMessage(message, 0, params);
    }

    private static String getMessage(String name) {
        Locale locale = Locale.getDefault();
        ResourceBundle bundle = ResourceBundle.getBundle("UI.res.locale.messages", locale);
        return bundle.getString(name);
    }

    private static void resolveParams(Object[] params) {
        for (int paramIndex = 0; paramIndex < params.length; ++paramIndex) {
            try {
                String message;
                if (!(params[paramIndex] instanceof String) || (message = I18N.getMessage(params[paramIndex].toString())) == null) continue;
                params[paramIndex] = message;
                continue;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
    }

    private static String formatMessage(String message, int firstParam, Object[] params) {
        if (params != null && firstParam < params.length) {
            Locale locale = Locale.getDefault();
            MessageFormat parser = new MessageFormat("");
            parser.setLocale(locale);
            parser.applyPattern(message);
            Format[] formats = parser.getFormatsByArgumentIndex();
            for (int paramIndex = 0; paramIndex < formats.length; ++paramIndex) {
                if (!(params[firstParam + paramIndex] instanceof String)) continue;
                params[firstParam + paramIndex] = I18N.formatMessage(params[firstParam + paramIndex].toString(), firstParam + formats.length, params);
            }
            message = parser.format(I18N.getParams(params, firstParam, firstParam + formats.length));
        }
        return message;
    }

    private static Object[] getParams(Object[] params, int firstParam, int lastParam) {
        Object[] newParams = null;
        if (firstParam < lastParam) {
            newParams = new Object[lastParam - firstParam];
            for (int i = firstParam; i < lastParam; ++i) {
                newParams[i - firstParam] = params[i];
            }
        }
        return newParams;
    }
}

