/*
 * Decompiled with CFR 0.152.
 */
package Util;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.text.DecimalFormatSymbols;

public class GEVAHelper {
    public static Component mainWindow;

    private GEVAHelper() {
    }

    public static String quote(String string) {
        if (string.indexOf(32) != -1) {
            string = "\"" + string + "\"";
        }
        return string;
    }

    private static String parsePrepare(String value) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        char group = symbols.getGroupingSeparator();
        char decimal = symbols.getDecimalSeparator();
        return value.trim().replace(String.valueOf(group), "").replace(decimal, '.');
    }

    public static int parseInt(String value) {
        return Integer.parseInt(GEVAHelper.parsePrepare(value));
    }

    public static float parseFloat(String value) {
        return Float.parseFloat(GEVAHelper.parsePrepare(value));
    }

    public static double parseDouble(String value) {
        return Double.parseDouble(GEVAHelper.parsePrepare(value));
    }

    public static String[] prune(String[] a) {
        int c = 0;
        for (int i = 0; i < a.length; ++i) {
            a[i] = a[i].trim();
        }
        for (String b : a) {
            if (b.length() == 0) continue;
            ++c;
        }
        String[] d = new String[c];
        c = 0;
        for (String b : a) {
            if (b.length() == 0) continue;
            d[c++] = b;
        }
        return d;
    }

    public static String[] trim(String[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = a[i].trim();
        }
        return a;
    }

    public static void gridAdd(Container container, Container control, int gridX, int gridY, double weightX) {
        GEVAHelper.gridAdd(container, control, gridX, gridY, 1, 1, weightX, 0.0);
    }

    public static void gridAdd(Container container, Container control, int gridX, int gridY, int gridW, int gridH, double weightX, double weightY) {
        container.add((Component)control, new GridBagConstraints(gridX, gridY, gridW, gridH, weightX, weightY, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
    }
}

