/*
 * Decompiled with CFR 0.152.
 */
package UI.Run.JSci;

import UI.Run.JSci.GEVAGraphColours;
import UI.Run.JSci.GEVAGraphStatistics;
import Util.I18N;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

class GEVAGraphSeries {
    private Data data = new Data();
    private GEVAGraphSeries errorSeries;
    private int errorSeriesRefCount = 0;
    private float scale = 1.0f;
    private float offset = 0.0f;
    private Color colour;
    private boolean visible = true;
    private boolean selected = false;
    private Statistics statistics = new Statistics();

    public GEVAGraphSeries() {
        this.setColour(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int length() {
        Data data = this.data;
        synchronized (data) {
            return this.data.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(float value) {
        if (value < this.statistics.extremaMin) {
            this.statistics.extremaMin = value;
        }
        if (value > this.statistics.extremaMax) {
            this.statistics.extremaMax = value;
        }
        Data data = this.data;
        synchronized (data) {
            this.data.add(Float.valueOf(value));
        }
    }

    public float get(int dataIndex) {
        Data data = this.data;
        synchronized (data) {
            try {
                return ((Float)this.data.get(dataIndex)).floatValue();
            }
            catch (IndexOutOfBoundsException e) {
                if (dataIndex == this.data.size() && this.isErrorSeries()) {
                    return 0.0f;
                }
                throw e;
            }
        }
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    public void setOffset(float offset) {
        this.offset = offset;
    }

    public float getOffset() {
        return this.offset;
    }

    public void setColour(Color colour) {
        this.colour = colour != null ? colour : new Color(GEVAGraphColours.colourIndexes[(int)(Math.random() * (double)GEVAGraphColours.colourIndexes.length)]);
    }

    public Color getColour() {
        return this.colour;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public GEVAGraphStatistics getStatistics() {
        return this.statistics;
    }

    public void setErrorSeries(GEVAGraphSeries errorSeries) {
        if (this == errorSeries) {
            throw new IllegalArgumentException(I18N.get("ui.err.grse.seri", new Object[0]));
        }
        if (this.errorSeries == errorSeries) {
            return;
        }
        if (this.errorSeries != null) {
            --this.errorSeries.errorSeriesRefCount;
            assert (this.errorSeries.errorSeriesRefCount >= 0) : this.errorSeries.errorSeriesRefCount;
        }
        this.errorSeries = errorSeries;
        if (this.errorSeries != null) {
            ++this.errorSeries.errorSeriesRefCount;
            assert (this.errorSeries.errorSeriesRefCount > 0) : this.errorSeries.errorSeriesRefCount;
        }
    }

    public GEVAGraphSeries getErrorSeries() {
        return this.errorSeries;
    }

    public boolean isErrorSeries() {
        return this.errorSeriesRefCount > 0;
    }

    public class Statistics
    implements GEVAGraphStatistics {
        private float extremaMin = Float.MAX_VALUE;
        private float extremaMax = Float.MIN_VALUE;

        @Override
        public float getExtremaMin() {
            return this.extremaMin;
        }

        @Override
        public float getExtremaMax() {
            return this.extremaMax;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public float calcMean() {
            float total = 0.0f;
            Data data = GEVAGraphSeries.this.data;
            synchronized (data) {
                Iterator i$ = GEVAGraphSeries.this.data.iterator();
                while (i$.hasNext()) {
                    float datum = ((Float)i$.next()).floatValue();
                    total += datum;
                }
                return total / (float)GEVAGraphSeries.this.data.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public float calcMedian() {
            Data median;
            Data data = GEVAGraphSeries.this.data;
            synchronized (data) {
                median = new Data(GEVAGraphSeries.this.data);
            }
            Collections.sort(median);
            int mid = median.size() / 2;
            if (median.size() == 0) {
                return 0.0f;
            }
            if (median.size() % 2 == 1) {
                return ((Float)median.get(mid)).floatValue();
            }
            return (((Float)median.get(mid - 1)).floatValue() + ((Float)median.get(mid)).floatValue()) / 2.0f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public float calcStandardDeviation() {
            Data dataEx;
            float mean = this.calcMean();
            Data data = GEVAGraphSeries.this.data;
            synchronized (data) {
                dataEx = new Data(GEVAGraphSeries.this.data);
            }
            float wideMean = 0.0f;
            Iterator i$ = dataEx.iterator();
            while (i$.hasNext()) {
                float datum = ((Float)i$.next()).floatValue();
                wideMean += (float)Math.pow(datum - mean, 2.0);
            }
            return (float)Math.sqrt(wideMean /= (float)dataEx.size());
        }
    }

    private static class Data
    extends ArrayList<Float> {
        public Data() {
        }

        public Data(Data data) {
            super(data);
        }
    }
}

