/*
 * Decompiled with CFR 0.152.
 */
package UI.Run.JSci;

import JSci.awt.Graph2DModel;
import JSci.awt.GraphDataListener;
import UI.Run.JSci.GEVAGraphSeries;
import UI.Run.JSci.GEVAGraphStatistics;
import Util.I18N;
import java.awt.Color;
import java.util.ArrayList;

public class GEVAGraphModel
implements Graph2DModel {
    private Serii serii = new Serii();
    private int activeSeries = 0;
    private int topSeries = -1;

    public int addSeries() {
        this.serii.add(new GEVAGraphSeries());
        return this.serii.size() - 1;
    }

    public void addData(double[] data) {
        int i = 0;
        for (GEVAGraphSeries series : this.serii) {
            series.add((float)data[i++]);
        }
    }

    public float getXExtremaMin() {
        return 0.0f;
    }

    public float getXExtremaMax() {
        if (this.serii.size() == 0 || ((GEVAGraphSeries)this.serii.get(0)).length() < 10) {
            return 10.0f;
        }
        return ((GEVAGraphSeries)this.serii.get(0)).length();
    }

    public float calcYExtremaMin() {
        float minimum = Float.MAX_VALUE;
        for (GEVAGraphSeries series : this.serii) {
            if (!series.isVisible() || series.isErrorSeries() || !(series.getStatistics().getExtremaMin() * series.getScale() + series.getOffset() < minimum)) continue;
            minimum = series.getStatistics().getExtremaMin() * series.getScale() + series.getOffset();
        }
        if (minimum == Float.MAX_VALUE) {
            minimum = 0.0f;
        }
        return minimum;
    }

    public float calcYExtremaMax() {
        float maximum = Float.MIN_VALUE;
        for (GEVAGraphSeries series : this.serii) {
            if (!series.isVisible() || series.isErrorSeries() || !(series.getStatistics().getExtremaMax() * series.getScale() + series.getOffset() > maximum)) continue;
            maximum = series.getStatistics().getExtremaMax() * series.getScale() + series.getOffset();
        }
        if (maximum == Float.MIN_VALUE) {
            maximum = 100.0f;
        }
        return maximum;
    }

    public int getSeriesLength(int seriesIndex) {
        return ((GEVAGraphSeries)this.serii.get(seriesIndex)).length();
    }

    public GEVAGraphStatistics getSeriesStatistics(int seriesIndex) {
        return ((GEVAGraphSeries)this.serii.get(seriesIndex)).getStatistics();
    }

    public void setSeriesScale(int seriesIndex, float scale) {
        ((GEVAGraphSeries)this.serii.get(seriesIndex)).setScale(scale);
    }

    public float getSeriesScale(int seriesIndex) {
        return ((GEVAGraphSeries)this.serii.get(seriesIndex)).getScale();
    }

    public void setSeriesOffset(int seriesIndex, float offset) {
        ((GEVAGraphSeries)this.serii.get(seriesIndex)).setOffset(offset);
    }

    public float getSeriesOffset(int seriesIndex) {
        return ((GEVAGraphSeries)this.serii.get(seriesIndex)).getOffset();
    }

    public void setSeriesColour(int seriesIndex, Color colour) {
        ((GEVAGraphSeries)this.serii.get(seriesIndex)).setColour(colour);
    }

    public Color getSeriesColour(int seriesIndex) {
        return ((GEVAGraphSeries)this.serii.get(seriesIndex)).getColour();
    }

    public void setSeriesVisible(int seriesIndex, boolean visible) {
        ((GEVAGraphSeries)this.serii.get(seriesIndex)).setVisible(visible);
    }

    public boolean isSeriesVisible(int seriesIndex) {
        return ((GEVAGraphSeries)this.serii.get(seriesIndex)).isVisible();
    }

    public void setSeriesSelected(int seriesIndex, boolean selected) {
        ((GEVAGraphSeries)this.serii.get(seriesIndex)).setSelected(selected);
    }

    public boolean isSeriesSelected(int seriesIndex) {
        return ((GEVAGraphSeries)this.serii.get(seriesIndex)).isSelected();
    }

    public void setSeriesErrorSeries(int seriesIndex, int errorIndex) {
        if (seriesIndex == errorIndex) {
            throw new IllegalArgumentException(I18N.get("ui.err.grmo.seri", new Object[0]));
        }
        ((GEVAGraphSeries)this.serii.get(seriesIndex)).setErrorSeries((GEVAGraphSeries)this.serii.get(errorIndex));
    }

    public int getSeriesErrorSeries(int seriesIndex) {
        GEVAGraphSeries errorIndex = ((GEVAGraphSeries)this.serii.get(seriesIndex)).getErrorSeries();
        if (errorIndex == null) {
            return -1;
        }
        return this.serii.indexOf(errorIndex);
    }

    public boolean isSeriesErrorSeries(int seriesIndex) {
        return ((GEVAGraphSeries)this.serii.get(seriesIndex)).isErrorSeries();
    }

    public float getSeriesValueAt(int seriesIndex, int dataIndex) {
        return ((GEVAGraphSeries)this.serii.get(seriesIndex)).get(dataIndex);
    }

    public float getSeriesValue(int seriesIndex) {
        GEVAGraphSeries series = (GEVAGraphSeries)this.serii.get(seriesIndex);
        if (series.length() > 0) {
            return series.get(series.length() - 1);
        }
        return 0.0f;
    }

    public void setSeriesOnTop(int seriesIndex) {
        this.topSeries = seriesIndex;
    }

    @Override
    public float getXCoord(int dataIndex) {
        return dataIndex;
    }

    @Override
    public float getYCoord(int dataIndex) {
        return ((GEVAGraphSeries)this.serii.get(this.activeSeries)).get(dataIndex) * ((GEVAGraphSeries)this.serii.get(this.activeSeries)).getScale() + ((GEVAGraphSeries)this.serii.get(this.activeSeries)).getOffset();
    }

    public float getZCoord(int dataIndex) {
        int errorSeries = this.getSeriesErrorSeries(this.activeSeries);
        return ((GEVAGraphSeries)this.serii.get(errorSeries)).get(dataIndex) * ((GEVAGraphSeries)this.serii.get(this.activeSeries)).getScale() * ((GEVAGraphSeries)this.serii.get(errorSeries)).getScale();
    }

    public Color getColour() {
        return this.getSeriesColour(this.activeSeries);
    }

    public Color getErrorColour() {
        if (!this.hasErrorSeries()) {
            return null;
        }
        return this.getSeriesColour(this.getSeriesErrorSeries(this.activeSeries));
    }

    public boolean isVisible() {
        return this.isSeriesVisible(this.activeSeries);
    }

    public boolean isErrorVisible() {
        if (!this.hasErrorSeries()) {
            return false;
        }
        return this.isSeriesVisible(this.getSeriesErrorSeries(this.activeSeries));
    }

    public boolean isSelected() {
        return this.isSeriesSelected(this.activeSeries);
    }

    public boolean hasErrorSeries() {
        return this.getSeriesErrorSeries(this.activeSeries) != -1;
    }

    public boolean isErrorSeries() {
        return this.isSeriesErrorSeries(this.activeSeries);
    }

    @Override
    public int seriesLength() {
        return ((GEVAGraphSeries)this.serii.get(this.activeSeries)).length();
    }

    @Override
    public void firstSeries() {
        this.activeSeries = this.topSeries == 0 ? 1 : 0;
    }

    @Override
    public boolean nextSeries() {
        if (this.lastSeries()) {
            return false;
        }
        if (this.activeSeries == this.topSeries) {
            this.activeSeries = this.serii.size();
        } else {
            ++this.activeSeries;
            if (this.activeSeries == this.topSeries) {
                ++this.activeSeries;
            }
            if (this.activeSeries == this.serii.size() && this.topSeries != -1) {
                this.activeSeries = this.topSeries;
            }
        }
        return !this.lastSeries();
    }

    public boolean lastSeries() {
        return this.activeSeries >= this.serii.size();
    }

    @Override
    public void addGraphDataListener(GraphDataListener listener) {
    }

    @Override
    public void removeGraphDataListener(GraphDataListener listener) {
    }

    private static class Serii
    extends ArrayList<GEVAGraphSeries> {
        private Serii() {
        }
    }
}

