/*
 * Decompiled with CFR 0.152.
 */
package UI.Run.JSci;

import java.awt.Color;

public class GEVAGraphColours {
    public static final int[] colourIndexes = new int[]{0, 128, 139, 205, 255, 25600, 32768, 32896, 35723, 49151, 52945, 64154, 65280, 65407, 65535, 65535, 1644912, 2003199, 2142890, 0x228B22, 3050327, 0x2F4F4F, 3329330, 3978097, 4251856, 4286945, 4620980, 4734347, 4772300, 4915330, 5597999, 6266528, 6591981, 6737322, 0x696969, 6970061, 7048739, 7372944, 0x778899, 8087790, 8190976, 0x7FFF00, 8388564, 0x800000, 0x800080, 0x808000, 0x808080, 8900331, 8900346, 9055202, 0x8B0000, 0x8B008B, 9127187, 9419919, 0x90EE90, 9662683, 9699539, 10025880, 10040012, 10145074, 10506797, 0xA52A2A, 0xA9A9A9, 11393254, 11403055, 0xAFEEEE, 11584734, 11591910, 0xB22222, 12092939, 12211667, 12357519, 12433259, 0xC0C0C0, 13047173, 0xCD5C5C, 13468991, 13789470, 13808780, 0xD3D3D3, 14204888, 14315734, 14329120, 14423100, 0xDCDCDC, 0xDDA0DD, 14596231, 0xE0FFFF, 15132410, 15308410, 0xEE82EE, 0xEEE8AA, 0xF08080, 15787660, 0xF0F8FF, 0xF0FFF0, 0xF0FFFF, 16113331, 16119260, 0xF5F5F5, 0xF5FFFA, 0xF8F8FF, 16416882, 16426080, 16444375, 16445670, 16448210, 16643558, 0xFF0000, 0xFF00FF, 16716947, 16729344, 16737095, 16738740, 16744272, 16747520, 16752762, 16753920, 16758465, 16761035, 16766720, 16767673, 16768685, 16770229, 16770244, 16770273, 16772045, 16773077, 0xFFF0F5, 0xFFF5EE, 16775388, 16775885, 0xFFFAF0, 0xFFFAFA, 0xFFFF00, 0xFFFFE0, 0xFFFFF0, 0xFFFFFF};
    public static final String[] colourNames = new String[]{"black", "navy", "dark blue", "medium blue", "blue", "dark green", "green", "teal", "dark cyan", "deep sky-blue", "dark turquoise", "medium spring-green", "lime", "spring-green", "aqua", "cyan", "midnight-blue", "dodger-blue", "light sea-green", "forest-green", "sea-green", "dark slate-gray", "lime-green", "medium sea-green", "turquoise", "royal-blue", "steel-blue", "dark slate-blue", "medium turquoise", "indigo", "dark olive-green", "cadet-blue", "cornflower-blue", "medium aquamarine", "dim gray", "slate-blue", "olive-drab", "slate-gray", "light slate-gray", "medium slate-blue", "lawn-green", "chartreuse", "aqua-marine", "maroon", "purple", "olive", "gray", "sky-blue", "light sky-blue", "blue-violet", "dark red", "dark magenta", "saddle-brown", "dark sea-green", "light green", "medium purple", "dark violet", "pale-green", "dark orchid", "yellow-green", "sienna", "brown", "dark gray", "light blue", "green-yellow", "pale violet-red", "light steel-blue", "powder-blue", "fire-brick", "dark goldenrod", "medium orchid", "rosy-brown", "dark khaki", "silver", "medium violet-red", "indian-red", "peru", "chocolate", "tan", "light gray", "thistle", "orchid", "goldenrod", "crimson", "gainsboro", "plum", "burlywood", "light cyan", "lavender", "dark salmon", "violet", "pale goldenrod", "light coral", "khaki", "alice-blue", "honeydew", "azure", "wheat", "beige", "white-smoke", "mint-cream", "ghost-white", "salmon", "sandy-brown", "antique-white", "linen", "light goldenrod-yellow", "old lace", "red", "fuchsia", "deep pink", "orange-red", "tomato", "hot pink", "coral", "dark orange", "light salmon", "orange", "light pink", "pink", "gold", "peach-puff", "navajo-white", "moccasin", "bisque", "misty-rose", "blanched-almond", "papaya-whip", "lavender-blush", "seashell", "corn-silk", "lemon-chiffon", "floral-white", "snow", "yellow", "light yellow", "ivory", "white"};

    private GEVAGraphColours() {
    }

    public static String getColourName(Color colour) {
        double bestDistance = Double.MAX_VALUE;
        String name = null;
        int nameIndex = 0;
        for (int colourIndex : colourIndexes) {
            int x = colour.getRed() - ((colourIndex & 0xFF0000) >> 16);
            int y = colour.getGreen() - ((colourIndex & 0xFF00) >> 8);
            int z = colour.getBlue() - (colourIndex & 0xFF);
            if (x == 0 && y == 0 && z == 0) {
                return colourNames[nameIndex];
            }
            double distance = x * x + y * y + z * z;
            if (distance < bestDistance) {
                bestDistance = distance;
                name = colourNames[nameIndex];
            }
            ++nameIndex;
        }
        return name;
    }

    public static Color getNamedColour(String name) {
        for (int i = 0; i < colourNames.length; ++i) {
            if (!colourNames[i].equalsIgnoreCase(name)) continue;
            return new Color(colourIndexes[i]);
        }
        return null;
    }

    public static boolean isBright(Color colour) {
        return (colour.getRed() * 299 + colour.getGreen() * 587 + colour.getBlue() * 114) / 1000 >= 128;
    }
}

