/*
 * Decompiled with CFR 0.152.
 */
package UI.Run.JSci;

import JSci.awt.Graph2DModel;
import JSci.awt.GraphDataEvent;
import JSci.swing.JGraph2D;
import UI.Run.JSci.GEVAGraphModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;

public class GEVAGraph
extends JGraph2D {
    private int interleave = 0;

    public GEVAGraph(Graph2DModel model) {
        super(model);
        super.setGridLines(true);
        super.setBorder(BorderFactory.createEtchedBorder());
    }

    @Override
    public void dataChanged(GraphDataEvent event) {
    }

    @Override
    protected void offscreenPaint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.offscreenPaint(graphics);
    }

    @Override
    protected void drawData(Graphics graphics) {
        assert (this.model instanceof GEVAGraphModel) : this.model.getClass().getName();
        assert (graphics instanceof Graphics2D) : graphics.getClass().getName();
        GEVAGraphModel model = (GEVAGraphModel)this.model;
        Graphics2D graphicsEx = (Graphics2D)graphics;
        Stroke defaultPen = graphicsEx.getStroke();
        AveragePoint p1 = null;
        AveragePoint p2 = null;
        AveragePoint p3 = null;
        AveragePoint p4 = null;
        int lastX = 0;
        boolean hasError = false;
        this.interleave = 0;
        model.firstSeries();
        while (!model.lastSeries()) {
            if (model.isVisible() && !model.isErrorSeries()) {
                Stroke graphPen;
                hasError = model.isErrorVisible();
                if (!hasError) {
                    graphics.setColor(model.getColour());
                }
                if (model.isSelected()) {
                    graphPen = new BasicStroke(4.0f);
                    graphicsEx.setStroke(graphPen);
                } else {
                    graphPen = defaultPen;
                    graphicsEx.setStroke(graphPen);
                }
                p4 = null;
                p3 = null;
                p2 = null;
                p1 = null;
                int start = (int)super.getXMinimum() - 1;
                int end = (int)super.getXMaximum() + 2;
                if (start < 0) {
                    start = 0;
                }
                if (end > model.seriesLength()) {
                    end = model.seriesLength();
                }
                for (int i = start; i < end; ++i) {
                    int x = this.getX(model.getXCoord(i));
                    if (i == start) {
                        lastX = x;
                    } else if (x != lastX) {
                        this.drawDatum(graphicsEx, defaultPen, graphPen, model, p1, p2, p3, p4);
                        p1 = p2;
                        p2 = null;
                        p3 = p4;
                        p4 = null;
                        lastX = x;
                    }
                    if (p2 == null) {
                        p2 = new AveragePoint(x, model.getYCoord(i));
                    } else {
                        p2.setY(model.getYCoord(i));
                    }
                    if (!hasError) continue;
                    if (p4 == null) {
                        p4 = new AveragePoint(0, model.getZCoord(i));
                        continue;
                    }
                    p4.setY(model.getZCoord(i));
                }
                if (p2 != null) {
                    this.drawDatum(graphicsEx, defaultPen, graphPen, model, p1, p2, p3, p4);
                }
            }
            model.nextSeries();
        }
    }

    private void drawDatum(Graphics2D graphics, Stroke errorPen, Stroke graphPen, GEVAGraphModel model, AveragePoint p1, AveragePoint p2, AveragePoint p3, AveragePoint p4) {
        assert (p2 != null) : "p2, why are you null?";
        if (p4 != null) {
            graphics.setColor(model.getErrorColour());
            graphics.setStroke(errorPen);
            if (p1 == null || p1.getX() + 1 >= p2.getX()) {
                graphics.drawLine(p2.getX(), this.getY(p2.getY() - p4.getY()), p2.getX(), this.getY(p2.getY() + p4.getY()));
            } else {
                Polygon polygon = new Polygon();
                polygon.addPoint(p1.getX() + 1, this.getY(p1.getY() - p3.getY()));
                polygon.addPoint(p2.getX() + 1, this.getY(p2.getY() - p4.getY()));
                polygon.addPoint(p2.getX() + 1, this.getY(p2.getY() + p4.getY()));
                polygon.addPoint(p1.getX() + 1, this.getY(p1.getY() + p3.getY()));
                graphics.fillPolygon(polygon);
            }
            if (p1 != null) {
                graphics.setColor(model.getColour());
                graphics.setStroke(graphPen);
                graphics.drawLine(p1.getX(), this.getY(p1.getY()), p2.getX(), this.getY(p2.getY()));
            }
        } else if (p1 != null) {
            graphics.drawLine(p1.getX(), this.getY(p1.getY()), p2.getX(), this.getY(p2.getY()));
        }
    }

    protected int getX(float x) {
        return super.dataToScreen((float)x, (float)0.0f).x;
    }

    protected int getY(float y) {
        return super.dataToScreen((float)0.0f, (float)y).y;
    }

    public void setXExtremaSafe(float minimum, float maximum) {
        assert (this.model instanceof GEVAGraphModel) : this.model.getClass().getName();
        if (Float.isInfinite(minimum) || Float.isNaN(minimum) || Float.isInfinite(minimum) || Float.isNaN(minimum)) {
            minimum = ((GEVAGraphModel)this.model).getXExtremaMin();
            maximum = ((GEVAGraphModel)this.model).getXExtremaMax();
        }
        if (maximum < minimum) {
            float temp = minimum;
            minimum = maximum;
            maximum = temp;
        }
        if ((double)(maximum - minimum) < 0.01) {
            maximum = minimum + 0.01f;
        }
        super.setXExtrema(minimum, maximum);
    }

    public void setYExtremaSafe(float minimum, float maximum) {
        assert (this.model instanceof GEVAGraphModel) : this.model.getClass().getName();
        if (Float.isInfinite(minimum) || Float.isNaN(minimum) || Float.isInfinite(minimum) || Float.isNaN(minimum)) {
            minimum = ((GEVAGraphModel)this.model).getXExtremaMin();
            maximum = ((GEVAGraphModel)this.model).getXExtremaMax();
        }
        if (maximum < minimum) {
            float temp = minimum;
            minimum = maximum;
            maximum = temp;
        }
        if ((double)(maximum - minimum) < 0.01) {
            maximum = minimum + 0.01f;
        }
        if (maximum == minimum) {
            super.setYExtrema(0.0f, maximum);
        } else {
            super.setYExtrema(minimum, maximum);
        }
    }

    @Override
    protected void drawXLabel(Graphics graphics, double value, Point point) {
        if (this.interleave == 0) {
            super.drawXLabel(graphics, value, point);
        }
        this.interleave = (this.interleave + 1) % 2;
    }

    public float calcSeriesValueAt(int seriesIndex, int screenX) {
        assert (this.model instanceof GEVAGraphModel) : this.model.getClass().getName();
        GEVAGraphModel model = (GEVAGraphModel)this.model;
        Point2D.Float p1 = super.screenToData(new Point(screenX, 0));
        Point2D.Float p2 = super.screenToData(new Point(screenX + 1, 0));
        int startIndex = (int)p1.x;
        int endIndex = (int)p2.x;
        if (startIndex == endIndex) {
            ++endIndex;
        }
        float value = 0.0f;
        for (int dataIndex = startIndex; dataIndex < endIndex; ++dataIndex) {
            try {
                value += model.getSeriesValueAt(seriesIndex, dataIndex);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                break;
            }
        }
        if (endIndex - startIndex > 1) {
            return value / (float)(endIndex - startIndex);
        }
        return value;
    }

    public float getDataIndexAt(int screenX) {
        return super.screenToData((Point)new Point((int)screenX, (int)0)).x;
    }

    public float getDataValueAt(int screenY) {
        return super.screenToData((Point)new Point((int)0, (int)screenY)).y;
    }

    public float getDataIndexBetween(int screenX, int screenU) {
        return super.screenToData((Point)new Point((int)screenX, (int)0)).x - super.screenToData((Point)new Point((int)screenU, (int)0)).x;
    }

    public float getDataValueBetween(int screenY, int screenV) {
        return super.screenToData((Point)new Point((int)0, (int)screenY)).y - super.screenToData((Point)new Point((int)0, (int)screenV)).y;
    }

    class AveragePoint {
        private int x;
        private double y;
        private int step;

        public AveragePoint() {
            this.x = 0;
            this.y = 0.0;
            this.step = 0;
        }

        public AveragePoint(int x, int y) {
            this.x = x;
            this.y = y;
            this.step = 1;
        }

        public AveragePoint(int x, float y) {
            this.x = x;
            this.y = y;
            this.step = 1;
        }

        public void setX(int x) {
            this.x = x;
        }

        public void setY(int y) {
            this.y += (double)y;
            ++this.step;
        }

        public void setY(float y) {
            this.y += (double)y;
            ++this.step;
        }

        public int getX() {
            return this.x;
        }

        public float getY() {
            if (this.step == 0) {
                return 0.0f;
            }
            return (float)(this.y / (double)this.step);
        }
    }
}

