/*
 * Decompiled with CFR 0.152.
 */
package UI.Run;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class GEVAStreamReader
extends Thread {
    public static final int ID_STD_OUT = 0;
    public static final int ID_ERR_OUT = 1;
    private StreamListeners streamListeners = new StreamListeners();
    private InputStream stream;
    private int streamId;

    public GEVAStreamReader(ThreadGroup threadGroup, InputStream stream, int streamId) {
        super(threadGroup, threadGroup.getName());
        this.stream = stream;
        this.streamId = streamId;
        this.start();
    }

    @Override
    public void run() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.stream));
            while ((line = reader.readLine()) != null) {
                this.fireStreamListeners(line, this.streamId);
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
        this.fireStreamListeners(null, this.streamId);
    }

    public void addStreamListener(Listener streamListener) {
        this.streamListeners.add(streamListener);
    }

    void fireStreamListeners(String line, int streamId) {
        for (Listener streamListener : this.streamListeners) {
            streamListener.streamListener(new Event(line, streamId));
        }
    }

    public static class Event {
        private String line;
        private int streamId;
        private boolean endOfStream;

        public Event(String line, int streamId) {
            this.line = line;
            this.streamId = streamId;
            this.endOfStream = line == null;
        }

        public String getLine() {
            return this.line;
        }

        public int getStreamId() {
            return this.streamId;
        }

        public boolean isEndOfStream() {
            return this.endOfStream;
        }
    }

    public static interface Listener {
        public void streamListener(Event var1);
    }

    private static class StreamListeners
    extends ArrayList<Listener> {
        private StreamListeners() {
        }
    }
}

