/*
 * Decompiled with CFR 0.152.
 */
package UI.Run;

import UI.Run.GEVAStreamReader;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class GEVAStreamParser<E extends Event>
implements GEVAStreamReader.Listener {
    public static final int ID_STD_OUT = 0;
    public static final int ID_ERR_OUT = 1;
    private Listeners listeners = new Listeners();
    private static Extensions globalExtensions = null;
    private Extensions extensions;

    public static void begin() {
        globalExtensions = new Extensions();
    }

    public static void end() {
        globalExtensions = null;
    }

    public GEVAStreamParser() {
        assert (globalExtensions != null) : "Wrap all GEVAStreamParser (+subtype) allocations in begin/end";
        this.extensions = globalExtensions;
    }

    @Override
    public final void streamListener(GEVAStreamReader.Event event) {
        if (event.isEndOfStream()) {
            this.fireParseListener();
        } else if (event.getLine() != null) {
            this.parseLine(new Line(event));
        }
    }

    public void injectLine(String text, int streamId) {
        this.parseLine(new Line(new GEVAStreamReader.Event(text, streamId)));
    }

    public void injectLine(String text) {
        this.parseLine(new Line(new GEVAStreamReader.Event(text, 0)));
    }

    protected abstract void parseLine(Line var1);

    public void addParserListener(Listener<E> listener) {
        this.listeners.add(listener);
    }

    public void removeParserListener(Listener<E> listener) {
        this.listeners.remove(listener);
    }

    protected void fireParserListener(E event) {
        for (Listener listener : this.listeners) {
            listener.lineParsed(event);
        }
    }

    private void fireParseListener() {
        for (Listener listener : this.listeners) {
            listener.streamParsed();
        }
    }

    public static abstract class Extension {
        public abstract Object getData(int var1);

        public abstract void setData(int var1, Object var2);

        public abstract int getLength();
    }

    protected class Line {
        private GEVAStreamReader.Event event;

        protected Line(GEVAStreamReader.Event event) {
            this.event = event;
        }

        public String getLine() {
            return this.event.getLine();
        }

        public int getStreamId() {
            return this.event.getStreamId();
        }

        public boolean isEndOfStream() {
            return this.event.isEndOfStream();
        }

        public Extension getExtension(String name) {
            return (Extension)GEVAStreamParser.this.extensions.get(name);
        }

        public void setExtension(String name, Extension extension) {
            GEVAStreamParser.this.extensions.put(name, extension);
        }
    }

    protected static class LineEvent
    extends Event {
        private String line;

        public LineEvent(String line) {
            this.line = line;
        }

        public String getLine() {
            return this.line;
        }
    }

    protected static class Event {
        protected Event() {
        }
    }

    protected static interface Listener<E> {
        public void lineParsed(E var1);

        public void streamParsed();
    }

    private static class Extensions
    extends HashMap<String, Extension> {
        private Extensions() {
        }
    }

    private class Listeners
    extends ArrayList<Listener<E>> {
        private Listeners() {
        }
    }
}

