/*
 * Decompiled with CFR 0.152.
 */
package UI.Run;

import UI.GEVAConfig;
import UI.GEVAFitness;
import UI.GEVAMessage;
import UI.Run.GEVAConfigurationStreamParser;
import UI.Run.GEVAErrorStreamParser;
import UI.Run.GEVAGlobalStreamParser;
import UI.Run.GEVAGraphPane;
import UI.Run.GEVAGraphStreamParser;
import UI.Run.GEVALSystemPane;
import UI.Run.GEVALSystemStreamParser;
import UI.Run.GEVAOutputPane;
import UI.Run.GEVAPane;
import UI.Run.GEVAPaneManager;
import UI.Run.GEVARunning;
import UI.Run.GEVAStandardStreamParser;
import UI.Run.GEVAStreamParser;
import UI.Run.GEVAStreamReader;
import Util.GEVAUncaught;
import Util.I18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GEVARun
extends JDialog
implements WindowListener,
GEVAPaneManager,
GEVAStreamParser.Listener<GEVAGlobalStreamParser.Event> {
    private Process gevaProcess;
    private GEVAStreamReader gevaInputReader;
    private GEVAStreamReader gevaErrorReader;
    private JPanel guiToolBar;
    private JButton cmdStop;
    private JButton cmdClose;
    private JTabbedPane pages;
    private GEVAGlobalStreamParser globalParser;
    private GEVAConfigurationStreamParser configParser;
    private GEVAStandardStreamParser standardParser;
    private GEVAErrorStreamParser errorParser;
    private GEVAGraphStreamParser.LabelStreamParser labelParser;
    private GEVAGraphStreamParser.DataStreamParser dataParser;
    private GEVALSystemStreamParser lsystemParser;
    private Panes panes = new Panes();
    private JPanel guiStatusBar;

    public GEVARun(Dialog owner, String propertiesFilePath, GEVAFitness fitness) {
        super(owner);
        this.init(propertiesFilePath, fitness);
    }

    public GEVARun(Frame owner, String propertiesFilePath, GEVAFitness fitness) {
        super(owner);
        this.init(propertiesFilePath, fitness);
    }

    private void init(String propertiesFilePath, GEVAFitness fitness) {
        this.initialiseUI();
        this.run(propertiesFilePath, fitness);
    }

    private void initialiseUI() {
        this.pages = new JTabbedPane();
        this.guiToolBar = new JPanel(new FlowLayout(0, 2, 2));
        this.guiStatusBar = new JPanel(new FlowLayout(0, 2, 2));
        this.cmdStop = new JButton(I18N.get("ui.run.ctrl.stop", new Object[0]));
        this.guiToolBar.add(this.cmdStop);
        this.cmdClose = new JButton(I18N.get("ui.run.ctrl.exit", new Object[0]));
        this.guiToolBar.add(this.cmdClose);
        this.guiToolBar.add(new JSeparator(1));
        GEVAOutputPane guiOutput = new GEVAOutputPane(this);
        GEVAGraphPane guiGraph = new GEVAGraphPane(this);
        GEVALSystemPane guiLSystem = new GEVALSystemPane(this);
        GEVAStreamParser.begin();
        this.globalParser = new GEVAGlobalStreamParser();
        this.configParser = new GEVAConfigurationStreamParser();
        this.standardParser = new GEVAStandardStreamParser();
        this.errorParser = new GEVAErrorStreamParser();
        GEVAGraphStreamParser graphParser = new GEVAGraphStreamParser();
        this.labelParser = graphParser.new GEVAGraphStreamParser.LabelStreamParser();
        this.dataParser = graphParser.new GEVAGraphStreamParser.DataStreamParser();
        this.lsystemParser = new GEVALSystemStreamParser();
        GEVAStreamParser.end();
        this.globalParser.addParserListener(this);
        this.configParser.addParserListener(guiGraph.getConfigListenee());
        this.standardParser.addParserListener(guiOutput.getStandardListenee());
        this.errorParser.addParserListener(guiOutput.getErrorListenee());
        this.labelParser.addParserListener(guiGraph.getLabelListenee());
        this.dataParser.addParserListener(guiGraph.getDataListenee());
        this.lsystemParser.addParserListener(guiLSystem);
        this.pages.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GEVARun.this.pages_onChange();
            }
        });
        this.cmdStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GEVARun.this.cmdStop_onClick();
            }
        });
        this.cmdClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GEVARun.this.cmdClose_onClick();
            }
        });
        this.cmdClose.setVisible(false);
        super.addWindowListener(this);
        super.setDefaultCloseOperation(0);
        super.getContentPane().setLayout(new BorderLayout());
        super.getContentPane().add((Component)this.guiToolBar, "North");
        super.getContentPane().add((Component)this.pages, "Center");
        super.getContentPane().add((Component)this.guiStatusBar, "South");
        super.setSize(640, 480);
        super.setVisible(true);
    }

    private void run(String propertiesFilePath, GEVAFitness fitness) {
        String classPath = fitness.getJar();
        if (classPath == null) {
            this.errorParser.injectLine(I18N.get("ui.run.stop", new Object[0]));
            return;
        }
        String command = GEVAConfig.getJavaName();
        command = command + fitness.getCmd();
        if (classPath != null && classPath.length() != 0) {
            command = command + " -cp " + classPath;
        }
        if (GEVAConfig.getHeapSize() != null) {
            command = command + " -Xmx" + GEVAConfig.getHeapSize();
        }
        if (GEVAConfig.isServer()) {
            command = command + " -server";
        }
        command = command + " " + GEVAConfig.getClassName();
        command = command + " -properties_file " + propertiesFilePath;
        try {
            this.gevaProcess = GEVAConfig.getWorkingAbsPath() == null || GEVAConfig.getWorkingAbsPath().length() == 0 ? Runtime.getRuntime().exec(command) : Runtime.getRuntime().exec(command, null, new File(GEVAConfig.getWorkingAbsPath()));
            this.standardParser.injectLine(I18N.get("ui.run.rcmd", new Object[0]) + " " + command);
            this.standardParser.injectLine(I18N.get("ui.run.wkpa", new Object[0]) + " " + new File(GEVAConfig.getWorkingAbsPath()));
            this.gevaInputReader = new GEVAStreamReader((ThreadGroup)GEVAUncaught.output, this.gevaProcess.getInputStream(), 0);
            this.gevaErrorReader = new GEVAStreamReader((ThreadGroup)GEVAUncaught.error, this.gevaProcess.getErrorStream(), 1);
            this.setTitle(I18N.get("ui.run.begn", new Object[0]));
            this.gevaInputReader.addStreamListener(this.globalParser);
            this.gevaInputReader.addStreamListener(this.configParser);
            this.gevaInputReader.addStreamListener(this.lsystemParser);
            this.gevaInputReader.addStreamListener(this.dataParser);
            this.gevaInputReader.addStreamListener(this.labelParser);
            this.gevaInputReader.addStreamListener(this.standardParser);
            this.gevaErrorReader.addStreamListener(this.errorParser);
        }
        catch (IOException e) {
            if (this.gevaProcess != null) {
                this.gevaProcess.destroy();
                this.gevaProcess = null;
            }
            GEVAMessage.showMessage((Component)this, I18N.get("ui.run.err", e), 64, new String[0]);
            e.printStackTrace();
        }
    }

    @Override
    public void addPane(GEVAPane pane, String title) {
        GEVAPaneDetails paneDetails = (GEVAPaneDetails)this.panes.get(pane);
        if (paneDetails == null) {
            paneDetails = new GEVAPaneDetails(title);
            this.panes.put(pane, paneDetails);
        }
    }

    @Override
    public void viewPane(GEVAPane pane) {
        this.viewPane(pane, null);
    }

    @Override
    public void viewPane(GEVAPane pane, String reason) {
        GEVAPaneDetails paneDetails = (GEVAPaneDetails)this.panes.get(pane);
        if (paneDetails == null) {
            throw new IllegalStateException(I18N.get("ui.err.cons.abev", new Object[0]));
        }
        if (paneDetails.getIndex() == -1) {
            this.pages.addTab(paneDetails.getTitle(), pane);
            paneDetails.setIndex(this.pages.getTabCount() - 1);
        }
        if (reason != null) {
            if (paneDetails.isViewed(reason)) {
                return;
            }
            paneDetails.setViewed(reason);
        }
        this.pages.setSelectedIndex(paneDetails.getIndex());
    }

    @Override
    public boolean isViewingPane(GEVAPane pane) {
        GEVAPaneDetails paneDetails = (GEVAPaneDetails)this.panes.get(pane);
        if (paneDetails == null) {
            return false;
        }
        return this.pages.getSelectedIndex() == paneDetails.getIndex();
    }

    @Override
    public void addPaneTool(GEVAPane pane, Component component) {
        GEVAPaneDetails paneDetails = (GEVAPaneDetails)this.panes.get(pane);
        if (paneDetails == null) {
            throw new IllegalStateException(I18N.get("ui.err.cons.abea", new Object[0]));
        }
        paneDetails.addTool(component);
        if (this.isViewingPane(pane)) {
            this.guiToolBar.add(component);
        }
    }

    @Override
    public void removePaneTool(GEVAPane pane, Component component) {
        GEVAPaneDetails paneDetails = (GEVAPaneDetails)this.panes.get(pane);
        if (paneDetails == null) {
            throw new IllegalStateException(I18N.get("ui.err.cons.aber", new Object[0]));
        }
        paneDetails.removeTool(component);
        if (this.isViewingPane(pane)) {
            this.guiToolBar.remove(component);
        }
    }

    @Override
    public void addPaneStatus(GEVAPane pane, Component component) {
        GEVAPaneDetails paneDetails = (GEVAPaneDetails)this.panes.get(pane);
        if (paneDetails == null) {
            throw new IllegalStateException(I18N.get("ui.err.cons.abea", new Object[0]));
        }
        paneDetails.addStatus(component);
    }

    @Override
    public void removePaneStatus(GEVAPane pane, Component component) {
        GEVAPaneDetails paneDetails = (GEVAPaneDetails)this.panes.get(pane);
        if (paneDetails == null) {
            throw new IllegalStateException(I18N.get("ui.err.cons.aber", new Object[0]));
        }
        paneDetails.removeStatus(component);
    }

    void pages_onChange() {
        for (GEVAPaneDetails pane : this.panes.values()) {
            for (GEVAPaneDetails.GEVAPaneToolDetails tool : pane.getTools()) {
                if (pane.getIndex() == this.pages.getSelectedIndex()) {
                    this.guiToolBar.add(tool.component);
                    continue;
                }
                this.guiToolBar.remove(tool.component);
            }
        }
        this.guiToolBar.paintImmediately(this.guiToolBar.getBounds());
    }

    void cmdStop_onClick() {
        this.gevaProcess.destroy();
        this.gevaProcess = null;
    }

    void cmdClose_onClick() {
        this.close();
    }

    public void close() {
        this.windowClosing(null);
    }

    @Override
    public void lineParsed(GEVAGlobalStreamParser.Event event) {
    }

    @Override
    public void streamParsed() {
        this.setTitle(I18N.get("ui.run.fins", new Object[0]));
        this.cmdStop.setVisible(false);
        this.cmdClose.setVisible(true);
    }

    @Override
    public void windowClosing(WindowEvent event) {
        if (this.gevaProcess != null && (this.gevaInputReader != null && this.gevaInputReader.isAlive() || this.gevaErrorReader != null && this.gevaErrorReader.isAlive())) {
            if (GEVAMessage.showMessage((Component)this, I18N.get("ui.run.geru.wrn", new Object[0]), 37, new String[0]) == 1) {
                this.cmdStop_onClick();
            } else {
                return;
            }
        }
        this.dispose();
        GEVARunning.remove(this);
    }

    @Override
    public void windowActivated(WindowEvent event) {
    }

    @Override
    public void windowClosed(WindowEvent event) {
    }

    @Override
    public void windowDeactivated(WindowEvent event) {
    }

    @Override
    public void windowDeiconified(WindowEvent event) {
    }

    @Override
    public void windowIconified(WindowEvent event) {
    }

    @Override
    public void windowOpened(WindowEvent event) {
    }

    class GEVAPaneDetails {
        private int index = -1;
        private String title;
        private ReasonViewed reasonViewed = new ReasonViewed();
        private Tools tools = new Tools();
        private Statuses statuses = new Statuses();

        public GEVAPaneDetails(String title) {
            this.title = title;
            this.index = -1;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            if (this.index == -1) {
                this.index = index;
            }
        }

        public String getTitle() {
            return this.title;
        }

        public void setViewed(String reason) {
            this.reasonViewed.put(reason, true);
        }

        public boolean isViewed(String reason) {
            if (!this.reasonViewed.containsKey(reason)) {
                return false;
            }
            return (Boolean)this.reasonViewed.get(reason);
        }

        public void addTool(Component component) {
            this.tools.add(new GEVAPaneToolDetails(component));
        }

        public void removeTool(Component component) {
            Iterator tool = this.tools.iterator();
            while (tool.hasNext()) {
                if (((GEVAPaneToolDetails)tool.next()).component != component) continue;
                tool.remove();
                return;
            }
        }

        public Tools getTools() {
            return this.tools;
        }

        public void addStatus(Component component) {
            if (this.statuses.containsKey(component)) {
                this.removeStatus(component);
            }
            JPanel status = new JPanel();
            status.setLayout(new FlowLayout(0, 2, 2));
            status.setBorder(BorderFactory.createLoweredBevelBorder());
            status.add(component);
            GEVARun.this.guiStatusBar.add(status);
            this.statuses.put(component, status);
        }

        public void removeStatus(Component component) {
            JPanel status = (JPanel)this.statuses.get(component);
            if (status == null) {
                return;
            }
            this.statuses.remove(component);
            status.remove(component);
            GEVARun.this.guiStatusBar.remove(status);
        }

        public class GEVAPaneToolDetails {
            public Component component;

            public GEVAPaneToolDetails(Component component) {
                this.component = component;
            }
        }

        private class Statuses
        extends HashMap<Component, JPanel> {
            private Statuses() {
            }
        }

        private class Tools
        extends ArrayList<GEVAPaneToolDetails> {
            private Tools() {
            }
        }

        private class ReasonViewed
        extends HashMap<String, Boolean> {
            private ReasonViewed() {
            }
        }
    }

    private static class Panes
    extends HashMap<GEVAPane, GEVAPaneDetails> {
        private Panes() {
        }
    }
}

