/*
 * Decompiled with CFR 0.152.
 */
package UI.Run;

import UI.Run.GEVAErrorStreamParser;
import UI.Run.GEVAPane;
import UI.Run.GEVAPaneManager;
import UI.Run.GEVAStandardStreamParser;
import UI.Run.GEVAStreamParser;
import Util.I18N;
import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

class GEVAOutputPane
extends GEVAPane {
    private JTextPane txtOutput;
    private StandardListener standardListener = new StandardListener();
    private ErrorListener errorListener = new ErrorListener();

    public GEVAOutputPane(GEVAPaneManager paneManager) {
        super(paneManager, I18N.get("ui.run.cons.name", new Object[0]));
        super.setLayout(new BorderLayout());
        this.txtOutput = new JTextPane();
        this.txtOutput.setEditable(false);
        StyleConstants.setFontFamily(this.txtOutput.addStyle("out", null), "Monospaced");
        StyleConstants.setForeground(this.txtOutput.addStyle("err", this.txtOutput.getStyle("out")), Color.red);
        JPanel guiNoWrap = new JPanel();
        guiNoWrap.setLayout(new BorderLayout());
        guiNoWrap.add(this.txtOutput);
        JScrollPane guiScroll = new JScrollPane(guiNoWrap);
        super.add(guiScroll);
    }

    private void addOutput(String line, Style style) {
        boolean autoScroll = false;
        if (this.txtOutput.getCaretPosition() == this.txtOutput.getDocument().getLength()) {
            autoScroll = true;
        }
        try {
            this.txtOutput.getDocument().insertString(this.txtOutput.getDocument().getLength(), line + "\n", style);
        }
        catch (BadLocationException e) {
            this.txtOutput.setText(this.txtOutput.getText() + line + "\n");
        }
        if (autoScroll) {
            this.txtOutput.setCaretPosition(this.txtOutput.getDocument().getLength());
        }
    }

    public StandardListener getStandardListenee() {
        return this.standardListener;
    }

    public ErrorListener getErrorListenee() {
        return this.errorListener;
    }

    public class ErrorListener
    implements GEVAStreamParser.Listener<GEVAErrorStreamParser.Event> {
        @Override
        public void lineParsed(GEVAErrorStreamParser.Event event) {
            GEVAOutputPane.super.viewMe();
            GEVAOutputPane.this.addOutput(event.getLine(), GEVAOutputPane.this.txtOutput.getStyle("err"));
        }

        @Override
        public void streamParsed() {
        }
    }

    public class StandardListener
    implements GEVAStreamParser.Listener<GEVAStandardStreamParser.Event> {
        @Override
        public void lineParsed(GEVAStandardStreamParser.Event event) {
            GEVAOutputPane.super.viewMe("out");
            GEVAOutputPane.this.addOutput(event.getLine(), GEVAOutputPane.this.txtOutput.getStyle("out"));
        }

        @Override
        public void streamParsed() {
        }
    }
}

