/*
 * Decompiled with CFR 0.152.
 */
package UI.Run;

import UI.Run.GEVAGraphPaneCategory;
import UI.Run.GEVAGraphPaneItem;
import java.util.ArrayList;
import java.util.HashMap;

public class GEVAGraphPaneConfig {
    private static Configurations configurations = new Configurations();

    private GEVAGraphPaneConfig() {
    }

    public static void reset() {
        configurations = new Configurations();
    }

    public static void addCategory(String name, GEVAGraphPaneCategory category) {
        if (configurations.containsKey(name)) {
            Categories categories = (Categories)configurations.get(name);
            categories.add(category);
        } else {
            Categories categories = new Categories();
            categories.add(category);
            configurations.put(name, categories);
        }
    }

    public static Categories getCategories(String name) {
        Categories categories = (Categories)configurations.get(name);
        if (categories == null) {
            categories = new Categories();
        }
        return categories;
    }

    public static GEVAGraphPaneCategory getCategoryWithItem(String name, String itemName) {
        for (GEVAGraphPaneCategory category : GEVAGraphPaneConfig.getCategories(name)) {
            if (category.getItem(itemName) == null) continue;
            return category;
        }
        return null;
    }

    public static GEVAGraphPaneItem getItem(String name, String itemName) {
        for (GEVAGraphPaneCategory category : GEVAGraphPaneConfig.getCategories(name)) {
            GEVAGraphPaneItem item = category.getItem(itemName);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public static GEVAGraphPaneItem getItem(String name, String categoryName, String itemName) {
        GEVAGraphPaneItem item;
        Categories primaryCategories = GEVAGraphPaneConfig.getCategories(name);
        for (GEVAGraphPaneCategory category : primaryCategories) {
            item = category.getItem(itemName);
            if (item == null) continue;
            return item;
        }
        for (Categories categories : configurations.values()) {
            if (categories == primaryCategories) continue;
            for (GEVAGraphPaneCategory category : categories) {
                item = category.getItem(itemName);
                if (item == null) continue;
                return item;
            }
        }
        return null;
    }

    public static class Categories
    extends ArrayList<GEVAGraphPaneCategory> {
    }

    private static class Configurations
    extends HashMap<String, Categories> {
        private Configurations() {
        }
    }
}

