/*
 * Decompiled with CFR 0.152.
 */
package UI.Run;

import UI.Run.GEVAConfigurationStreamParser;
import UI.Run.GEVAGraphPaneCategory;
import UI.Run.GEVAGraphPaneConfig;
import UI.Run.GEVAGraphPaneItem;
import UI.Run.GEVAGraphStreamParser;
import UI.Run.GEVAPane;
import UI.Run.GEVAPaneManager;
import UI.Run.GEVAStreamParser;
import UI.Run.JSci.GEVAGraph;
import UI.Run.JSci.GEVAGraphColours;
import UI.Run.JSci.GEVAGraphModel;
import UI.Run.JSci.GEVAGraphStatistics;
import Util.FileNameExtensionFilter;
import Util.GEVAHelper;
import Util.GEVAUncaught;
import Util.I18N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GEVAGraphPane
extends GEVAPane
implements Runnable,
MouseMotionListener,
MouseListener {
    private static final String[] scaleRatios = new String[]{"1000:1", "100:1", "50:1", "10:1", "5:1", "2:1", "1:1", "1:2", "1:5", "1:10", "1:50", "1:100", "1:1000"};
    private GEVAGraph guiGraph;
    private GEVAGraphModel model;
    private JTabbedPane guiCategories;
    private JLabel guiStatus;
    private LabelListener labelListener = new LabelListener();
    private DataListener dataListener = new DataListener();
    private ConfigListener configListener = new ConfigListener();
    private GEVAGraphPaneSerii serii = new GEVAGraphPaneSerii();
    private Thread graphUpdater = null;
    private boolean hoverMode = false;
    private int generations = 0;
    private long startTime = -1L;
    private int mouseX = 0;
    private int mouseY = 0;
    private int mouseU = 0;
    private int mouseV = 0;
    private int mouseB = 0;
    private float graphX = 0.0f;
    private float graphY = 0.0f;
    private float graphU = 1.0f;
    private float graphV = 1.0f;
    private boolean graphF = false;

    public GEVAGraphPane(GEVAPaneManager paneManager) {
        super(paneManager, I18N.get("ui.run.graf.name", new Object[0]));
        super.setLayout(new BorderLayout());
        super.addMouseMotionListener(this);
        super.addMouseListener(this);
        this.model = new GEVAGraphModel();
        this.guiGraph = new GEVAGraph(this.model);
        this.guiCategories = new JTabbedPane();
        this.guiStatus = new JLabel();
        JButton cmdButton = new JButton(I18N.get("ui.run.graf.ctrl.saim", new Object[0]), new ImageIcon(ClassLoader.getSystemResource("UI/res/save.png")));
        super.addTool(cmdButton);
        cmdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GEVAGraphPane.this.cmdSave_onClick();
            }
        });
        super.addTool(new JSeparator(1));
        cmdButton = new JButton(I18N.get("ui.run.graf.ctrl.regr", new Object[0]));
        super.addTool(cmdButton);
        cmdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GEVAGraphPane.this.graphX = 0.0f;
                GEVAGraphPane.this.graphY = 0.0f;
                GEVAGraphPane.this.graphU = 1.0f;
                GEVAGraphPane.this.graphV = 1.0f;
                GEVAGraphPane.this.redraw();
            }
        });
        for (GEVAGraphPaneCategory category : GEVAGraphPaneConfig.getCategories("GEVA")) {
            JPanel guiStatistics = new JPanel(new GridBagLayout());
            this.gridAddI18NLabel(guiStatistics, "visi", 0);
            this.gridAddI18NLabel(guiStatistics, "hili", 1);
            this.gridAddI18NLabel(guiStatistics, "name", 2);
            this.gridAddI18NLabel(guiStatistics, "valu", 3);
            this.gridAddI18NLabel(guiStatistics, "mini", 4);
            this.gridAddI18NLabel(guiStatistics, "maxi", 5);
            this.gridAddI18NLabel(guiStatistics, "mean", 6);
            this.gridAddI18NLabel(guiStatistics, "medi", 7);
            this.gridAddI18NLabel(guiStatistics, "stdd", 8);
            this.gridAddI18NLabel(guiStatistics, "scal", 9);
            this.gridAddI18NLabel(guiStatistics, "offs", 10);
            this.gridAddI18NLabel(guiStatistics, "colr", 11);
            this.guiCategories.addTab(category.getName(), guiStatistics);
            category.setContainer(guiStatistics);
        }
        super.addStatus(this.guiStatus);
        super.add((Component)this.guiGraph, "Center");
        super.add((Component)this.guiCategories, "South");
    }

    private void gridAddI18NLabel(JPanel guiStatistics, String label, int gridX) {
        GEVAHelper.gridAdd(guiStatistics, new JLabel(I18N.get("ui.run.graf.labl." + label, new Object[0])), gridX, 0, 0.0);
    }

    private void cmdSave_onClick() {
        JFileChooser chooser = new JFileChooser();
        BufferedImage image = new BufferedImage(this.guiGraph.getWidth(), this.guiGraph.getHeight(), 1);
        this.guiGraph.paint(image.getGraphics());
        for (String format : ImageIO.getReaderFormatNames()) {
            FileNameExtensionFilter filter = new FileNameExtensionFilter(format, format);
            chooser.setFileFilter(filter);
        }
        if (chooser.showSaveDialog(this) == 0) {
            String filename = chooser.getSelectedFile().toString();
            if (!filename.toLowerCase().endsWith("." + chooser.getFileFilter())) {
                filename = filename + "." + chooser.getFileFilter();
            }
            try {
                ImageIO.write((RenderedImage)image, chooser.getFileFilter().toString(), new File(filename));
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    public LabelListener getLabelListenee() {
        return this.labelListener;
    }

    public DataListener getDataListenee() {
        return this.dataListener;
    }

    public ConfigListener getConfigListenee() {
        return this.configListener;
    }

    private void calcETA(int generation) {
        long currentTime = System.currentTimeMillis();
        if (this.startTime == -1L) {
            this.startTime = currentTime;
        } else {
            try {
                long deltaTime = currentTime - this.startTime;
                long eta = (long)((double)deltaTime / (double)(generation - 1) * (double)(this.generations - 1));
                eta -= deltaTime;
                eta += 999L;
                int seconds = (int)((eta /= 1000L) % 60L);
                int minutes = (int)((eta /= 60L) % 60L);
                int hours = (int)((eta /= 60L) % 24L);
                String format = (eta /= 24L) > 0L ? "({0,number,0}) {1,number,00}:{2,number,00}:{3,number,00}" : (hours > 0 ? "{1,number,0}:{2,number,00}:{3,number,00}" : (minutes > 0 ? "{2,number,0}:{3,number,00}" : "{3,number,0}"));
                this.guiStatus.setText(I18N.get("ui.run.graf.stat.time", format, eta, hours, minutes, seconds));
            }
            catch (ArithmeticException e) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        long renderTime = 0L;
        long statsTime = 0L;
        while (this.graphUpdater != null) {
            try {
                long time;
                if (statsTime <= 0L) {
                    time = System.currentTimeMillis();
                    for (GEVAGraphPaneSeries series : this.serii) {
                        series.updateStatistics();
                    }
                    statsTime = (System.currentTimeMillis() - time) * 10L;
                }
                if (renderTime <= 0L) {
                    time = System.currentTimeMillis();
                    this.redraw();
                    renderTime = (System.currentTimeMillis() - time) * 5L;
                    if (!this.hoverMode) {
                        this.value();
                    }
                }
                Thread.sleep(100L);
                statsTime -= 100L;
                renderTime -= 100L;
            }
            catch (InterruptedException e) {}
        }
        for (GEVAGraphPaneSeries series : this.serii) {
            series.updateStatistics();
        }
        this.redraw();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.hover(e.getX());
        this.mouseX = this.mouseU = e.getX();
        this.mouseY = this.mouseV = e.getY();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.hover(e.getX());
        switch (this.mouseB) {
            case 1: {
                this.graphX -= this.guiGraph.getDataIndexBetween(e.getX(), this.mouseX) / this.graphU;
                this.graphY -= this.guiGraph.getDataValueBetween(e.getY(), this.mouseY) / this.graphV;
                this.redraw();
                break;
            }
            case 3: {
                this.graphU *= -((float)(e.getX() - this.mouseX)) / 100.0f + 1.0f;
                this.graphV *= (float)(e.getY() - this.mouseY) / 100.0f + 1.0f;
                if ((double)this.graphU < 0.001) {
                    this.graphU = 0.001f;
                }
                if ((double)this.graphV < 0.001) {
                    this.graphV = 0.001f;
                }
                this.graphF = true;
                this.redraw();
            }
        }
        this.mouseX = e.getX();
        this.mouseY = e.getY();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.hoverMode = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.hoverMode = false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseB = e.getButton();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseB = 0;
    }

    protected void hover(int x) {
        try {
            for (GEVAGraphPaneSeries series : this.serii) {
                series.updateValue(this.guiGraph.calcSeriesValueAt(series.seriesId, x));
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    protected void value() {
        for (GEVAGraphPaneSeries series : this.serii) {
            series.updateValue(this.model.getSeriesValue(series.seriesId));
        }
    }

    public void rebound() {
        this.guiGraph.setXExtremaSafe((this.model.getXExtremaMin() + this.graphX) * this.graphU, ((float)this.generations + this.graphX) * this.graphU);
        this.guiGraph.setYExtremaSafe((this.model.calcYExtremaMin() + this.graphY) * this.graphV, (this.model.calcYExtremaMax() + this.graphY) * this.graphV);
    }

    public void redraw() {
        float fixX = 0.0f;
        float fixY = 0.0f;
        if (this.graphF) {
            fixX = this.guiGraph.getDataIndexAt(this.mouseU);
            fixY = this.guiGraph.getDataValueAt(this.mouseV);
        }
        this.rebound();
        if (this.graphF) {
            this.graphX -= (this.guiGraph.getDataIndexAt(this.mouseU) - fixX) / this.graphU;
            this.graphY -= (this.guiGraph.getDataValueAt(this.mouseV) - fixY) / this.graphV;
            this.rebound();
            this.graphF = false;
        }
        this.guiGraph.redraw();
    }

    class GEVAGraphPaneSeries {
        private int seriesId;
        private String name;
        private JCheckBox chkVisible;
        private JRadioButton optSelect;
        private JLabel lblName;
        private JLabel lblValue;
        private JLabel lblMinimum;
        private JLabel lblMaximum;
        private JLabel lblMean;
        private JLabel lblMedian;
        private JLabel lblStdDev;
        private JComboBox cboScale;
        private JSpinner numOffset;
        private GEVAColourChooser cboColour;

        public GEVAGraphPaneSeries(String name, int seriesId, GEVAGraphPaneCategory category) {
            this.seriesId = seriesId;
            this.name = name;
            this.chkVisible = new JCheckBox();
            this.optSelect = new JRadioButton();
            this.lblName = new JLabel(name);
            this.lblValue = new JLabel();
            this.lblMinimum = new JLabel();
            this.lblMaximum = new JLabel();
            this.lblMean = new JLabel();
            this.lblMedian = new JLabel();
            this.lblStdDev = new JLabel();
            this.cboScale = new JComboBox<String>(scaleRatios);
            this.numOffset = new JSpinner(new SpinnerNumberModel(0.0, -3.4028234663852886E38, 3.4028234663852886E38, 1.0));
            this.cboColour = new GEVAColourChooser();
            if (category != null && category.getItem(name) != null) {
                this.lblName.setText(category.getItem(name).getTitle());
            }
            this.chkVisible.setSelected(true);
            this.chkVisible.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    GEVAGraphPaneSeries.this.chkVisible_onClick();
                }
            });
            this.optSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GEVAGraphPaneSeries.this.optSelect_onClick();
                }
            });
            this.cboScale.setSelectedItem("1:1");
            this.cboScale.setEditable(true);
            this.cboScale.setMinimumSize(new Dimension(50, 0));
            this.cboScale.setPreferredSize(new Dimension(70, 0));
            this.cboScale.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GEVAGraphPaneSeries.this.cboScale_onChange();
                }
            });
            this.numOffset.setMinimumSize(new Dimension(50, 0));
            this.numOffset.setPreferredSize(new Dimension(70, 0));
            this.numOffset.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    GEVAGraphPaneSeries.this.numOffset_onChange();
                }
            });
            for (int colourIndex : GEVAGraphColours.colourIndexes) {
                this.cboColour.addItem(new Color(colourIndex));
            }
            this.cboColour.setMinimumSize(new Dimension(30, 0));
            this.cboColour.setPreferredSize(new Dimension(100, 0));
            this.cboColour.setSelectedItem(GEVAGraphPane.this.model.getSeriesColour(seriesId));
            this.cboColour.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GEVAGraphPaneSeries.this.cboColour_onClick();
                }
            });
            if (category != null) {
                GEVAGraphPaneItem item = category.getItem(name);
                boolean show = false;
                boolean bold = false;
                if (item != null) {
                    if (item.getVisible() == GEVAGraphPaneItem.VISIBLE_SHOW) {
                        show = true;
                    } else if (item.getVisible() == GEVAGraphPaneItem.VISIBLE_BOLD) {
                        bold = true;
                        show = true;
                    }
                }
                this.chkVisible.setSelected(show);
                this.optSelect.setSelected(bold);
            }
            if (category != null && category.getContainer() != null) {
                Container container = category.getContainer();
                GEVAHelper.gridAdd(container, this.chkVisible, 0, seriesId + 1, 0.0);
                GEVAHelper.gridAdd(container, this.optSelect, 1, seriesId + 1, 0.0);
                GEVAHelper.gridAdd(container, this.lblName, 2, seriesId + 1, 1.0);
                GEVAHelper.gridAdd(container, this.lblValue, 3, seriesId + 1, 1.0);
                GEVAHelper.gridAdd(container, this.lblMinimum, 4, seriesId + 1, 1.0);
                GEVAHelper.gridAdd(container, this.lblMaximum, 5, seriesId + 1, 1.0);
                GEVAHelper.gridAdd(container, this.lblMean, 6, seriesId + 1, 1.0);
                GEVAHelper.gridAdd(container, this.lblMedian, 7, seriesId + 1, 1.0);
                GEVAHelper.gridAdd(container, this.lblStdDev, 8, seriesId + 1, 1.0);
                GEVAHelper.gridAdd(container, this.cboScale, 9, seriesId + 1, 1.0);
                GEVAHelper.gridAdd(container, this.numOffset, 10, seriesId + 1, 1.0);
                GEVAHelper.gridAdd(container, this.cboColour, 11, seriesId + 1, 1.0);
            } else {
                System.out.println("No configuration for [" + name + "]");
            }
        }

        public void setErrorSeries(boolean errorSeries) {
            this.optSelect.setVisible(!errorSeries);
            this.numOffset.setVisible(!errorSeries);
        }

        private void chkVisible_onClick() {
            GEVAGraphPane.this.model.setSeriesVisible(this.seriesId, this.chkVisible.isSelected());
            GEVAGraphPane.this.redraw();
        }

        private void optSelect_onClick() {
            for (GEVAGraphPaneSeries series : GEVAGraphPane.this.serii) {
                if (series == this) continue;
                series.optSelect.setSelected(false);
                GEVAGraphPane.this.model.setSeriesSelected(series.seriesId, false);
            }
            GEVAGraphPane.this.model.setSeriesSelected(this.seriesId, this.optSelect.isSelected());
            if (this.optSelect.isSelected()) {
                GEVAGraphPane.this.model.setSeriesOnTop(this.seriesId);
            } else {
                GEVAGraphPane.this.model.setSeriesOnTop(-1);
            }
            GEVAGraphPane.this.redraw();
        }

        private void cboScale_onChange() {
            float scale;
            try {
                String[] ratio = this.cboScale.getSelectedItem().toString().split("[:/]");
                scale = Float.parseFloat(ratio[0]);
                if (ratio.length > 1) {
                    scale /= Float.parseFloat(ratio[1]);
                }
            }
            catch (NumberFormatException e) {
                scale = 1.0f;
            }
            GEVAGraphPane.this.model.setSeriesScale(this.seriesId, scale);
            GEVAGraphPane.this.redraw();
        }

        private void numOffset_onChange() {
            GEVAGraphPane.this.model.setSeriesOffset(this.seriesId, new Float((Double)this.numOffset.getValue()).floatValue());
            GEVAGraphPane.this.redraw();
        }

        private void cboColour_onClick() {
            assert (this.cboColour.getSelectedItem() instanceof Color) : this.cboColour.getSelectedItem().getClass().getName();
            GEVAGraphPane.this.model.setSeriesColour(this.seriesId, (Color)this.cboColour.getSelectedItem());
            GEVAGraphPane.this.redraw();
        }

        public void setColour(Color colour) {
            this.cboColour.setSelectedItem(colour);
        }

        public void updateValue(float value) {
            this.updateStatistic(this.lblValue, value);
        }

        public void updateStatistics() {
            GEVAGraphStatistics statistics = GEVAGraphPane.this.model.getSeriesStatistics(this.seriesId);
            this.updateStatistic(this.lblMinimum, statistics.getExtremaMin());
            this.updateStatistic(this.lblMaximum, statistics.getExtremaMax());
            this.updateStatistic(this.lblMean, statistics.calcMean());
            this.updateStatistic(this.lblMedian, statistics.calcMedian());
            this.updateStatistic(this.lblStdDev, statistics.calcStandardDeviation());
        }

        private void updateStatistic(JLabel label, float value) {
            label.setText(String.format("%.3f", Float.valueOf(value)));
        }

        public class GEVAColourChooser
        extends JComboBox {
            public GEVAColourChooser() {
                this.initialise();
            }

            public GEVAColourChooser(Vector<?> items) {
                super(items);
                this.initialise();
            }

            public GEVAColourChooser(Object[] items) {
                super(items);
                this.initialise();
            }

            public GEVAColourChooser(ComboBoxModel aModel) {
                super(aModel);
                this.initialise();
            }

            public void initialise() {
                this.setRenderer(new GEVAColourItem());
            }

            class GEVAColourItem
            extends JPanel
            implements ListCellRenderer {
                private JPanel guiColour;
                private JLabel txtColour;

                public GEVAColourItem() {
                    super.setOpaque(true);
                    super.setLayout(new FlowLayout(0, 2, 0));
                    this.guiColour = new JPanel();
                    this.guiColour.setPreferredSize(new Dimension(super.getFont().getSize(), super.getFont().getSize()));
                    this.txtColour = new JLabel();
                    GEVAHelper.gridAdd(this, this.guiColour, 0, 0, 1.0);
                    GEVAHelper.gridAdd(this, this.txtColour, 1, 0, 1.0);
                }

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    if (isSelected) {
                        this.setBackground(list.getSelectionBackground());
                        this.setForeground(list.getSelectionForeground());
                    } else {
                        this.setBackground(list.getBackground());
                        this.setForeground(list.getForeground());
                    }
                    if (value instanceof Color) {
                        Color colour = (Color)value;
                        this.guiColour.setBackground(colour);
                        this.txtColour.setText(GEVAGraphColours.getColourName(colour));
                    }
                    return this;
                }
            }
        }
    }

    static class GEVAGraphPaneSerii
    extends ArrayList<GEVAGraphPaneSeries> {
        GEVAGraphPaneSerii() {
        }

        public GEVAGraphPaneSeries get(String label) {
            for (GEVAGraphPaneSeries series : this) {
                if (!series.name.equals(label)) continue;
                return series;
            }
            return null;
        }
    }

    class GEVAGraphTabPane
    extends JPanel {
        private JTabbedPane pane;
        private JCheckBox chkVisible;

        public GEVAGraphTabPane(JTabbedPane pane) {
            super(new FlowLayout(0, 0, 0));
            assert (pane != null) : "Where's the pane at";
            super.setOpaque(false);
            this.pane = pane;
            this.chkVisible = new JCheckBox();
            this.chkVisible.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            JLabel lblTitle = new JLabel();
            lblTitle.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            super.add(this.chkVisible);
            super.add(lblTitle);
        }
    }

    public class ConfigListener
    implements GEVAStreamParser.Listener<GEVAConfigurationStreamParser.Event> {
        @Override
        public void lineParsed(GEVAConfigurationStreamParser.Event event) {
            GEVAGraphPane.this.generations = event.getGenerations();
        }

        @Override
        public void streamParsed() {
        }
    }

    public class DataListener
    implements GEVAStreamParser.Listener<GEVAGraphStreamParser.DataStreamParser.Event> {
        @Override
        public void lineParsed(GEVAGraphStreamParser.DataStreamParser.Event event) {
            GEVAGraphPane.this.model.addData(event.getData());
            GEVAGraphPane.this.calcETA((int)GEVAGraphPane.this.model.getSeriesValue(GEVAGraphPane.this.serii.get("Gen").seriesId));
            if (GEVAGraphPane.this.graphUpdater == null) {
                GEVAGraphPane.this.graphUpdater = new Thread((ThreadGroup)GEVAUncaught.graph, GEVAGraphPane.this);
                GEVAGraphPane.this.graphUpdater.start();
            }
        }

        @Override
        public void streamParsed() {
            if (GEVAGraphPane.this.graphUpdater != null) {
                GEVAGraphPane.this.graphUpdater = null;
                GEVAGraphPane.this.generations = (int)GEVAGraphPane.this.model.getSeriesValue(GEVAGraphPane.this.serii.get("Gen").seriesId);
                GEVAGraphPane.this.removeStatus(GEVAGraphPane.this.guiStatus);
                GEVAGraphPane.this.redraw();
            }
        }
    }

    public class LabelListener
    implements GEVAStreamParser.Listener<GEVAGraphStreamParser.LabelStreamParser.Event> {
        @Override
        public void lineParsed(GEVAGraphStreamParser.LabelStreamParser.Event event) {
            GEVAGraphPane.super.viewMe("data");
            for (String label : event.getLabels()) {
                GEVAGraphPaneItem item = null;
                GEVAGraphPaneCategory category = GEVAGraphPaneConfig.getCategoryWithItem("GEVA", label);
                if (category != null) {
                    item = category.getItem(label);
                }
                GEVAGraphPaneSeries series = new GEVAGraphPaneSeries(label, GEVAGraphPane.this.model.addSeries(), category);
                GEVAGraphPane.this.serii.add(series);
                if (item != null) {
                    boolean show = false;
                    boolean bold = false;
                    if (item.getVisible() == GEVAGraphPaneItem.VISIBLE_SHOW) {
                        show = true;
                    } else if (item.getVisible() == GEVAGraphPaneItem.VISIBLE_BOLD) {
                        bold = true;
                        show = true;
                    }
                    GEVAGraphPane.this.model.setSeriesVisible(series.seriesId, show);
                    GEVAGraphPane.this.model.setSeriesSelected(series.seriesId, bold);
                    if (bold) {
                        GEVAGraphPane.this.model.setSeriesOnTop(series.seriesId);
                    }
                    GEVAGraphPane.this.model.setSeriesColour(series.seriesId, item.getColour());
                    series.setColour(GEVAGraphPane.this.model.getSeriesColour(series.seriesId));
                    continue;
                }
                GEVAGraphPane.this.model.setSeriesVisible(series.seriesId, false);
            }
            for (String label : event.getLabels()) {
                GEVAGraphPaneItem item = GEVAGraphPaneConfig.getItem("GEVA", label);
                if (item == null || item.getErrorName() == null) continue;
                GEVAGraphPane.this.model.setSeriesErrorSeries(GEVAGraphPane.this.serii.get(item.getName()).seriesId, GEVAGraphPane.this.serii.get(item.getErrorName()).seriesId);
                GEVAGraphPane.this.serii.get(item.getErrorName()).setErrorSeries(true);
            }
        }

        @Override
        public void streamParsed() {
        }
    }
}

