/*
 * Decompiled with CFR 0.152.
 */
package UI;

import Fractal.LSystem2Control;
import Util.GEVAUncaught;
import Util.I18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class LSystemViewer
extends JFrame {
    private static final String[][] cmdFlags = new String[][]{{"1", "-x", "--axiom", I18N.get("ui.lsv.args.1", new Object[0])}, {"2", "-g", "--grammar", I18N.get("ui.lsv.args.2", new Object[0])}, {"3", "-d", "--depth", I18N.get("ui.lsv.args.3", new Object[0])}, {"4", "-a", "--angle", I18N.get("ui.lsv.args.4", new Object[0])}, {"5", "--help", "-h", "-?", "/?", I18N.get("ui.lsv.args.5", new Object[0])}};
    private LSystem2Control guiLSystem;
    private JButton cmdClose = new JButton(I18N.get("ui.lsv.exit", new Object[0]));

    public LSystemViewer(String[] args) {
        super(I18N.get("ui.lsv.name", new Object[0]));
        if (this.initialiseConfig(args)) {
            this.initialiseWindow();
        }
    }

    public LSystemViewer(String axiom, String grammar, String depth, String angle) {
        this(new String[]{cmdFlags[0][1], axiom, cmdFlags[1][1], grammar, cmdFlags[2][1], depth, cmdFlags[3][1], angle});
    }

    public LSystemViewer(String axiom, String grammar, int depth, float angle) {
        this.guiLSystem = new LSystem2Control(axiom, grammar, depth, angle, this.cmdClose);
        this.initialiseWindow();
    }

    private boolean initialiseConfig(String[] args) {
        int flag = 0;
        boolean help = false;
        String axiom = "";
        String grammar = "";
        int depth = 0;
        float angle = 0.0f;
        try {
            block9: for (String arg : args) {
                switch (flag) {
                    case 0: {
                        flag = this.parseFlag(arg);
                        if (flag != -1) continue block9;
                        help = true;
                        break;
                    }
                    case 1: {
                        axiom = arg;
                        break;
                    }
                    case 2: {
                        grammar = arg;
                        break;
                    }
                    case 3: {
                        depth = Integer.parseInt(arg);
                        break;
                    }
                    case 4: {
                        angle = Float.parseFloat(arg);
                        break;
                    }
                    default: {
                        help = true;
                    }
                }
                flag = 0;
            }
            if (flag != 0) {
                help = true;
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, e.toString());
        }
        if (help) {
            this.displayHelp();
            return false;
        }
        this.guiLSystem = new LSystem2Control(axiom, grammar, depth, angle, this.cmdClose);
        return true;
    }

    private void initialiseWindow() {
        super.setDefaultCloseOperation(2);
        super.setSize(400, 500);
        super.setLayout(new BorderLayout());
        this.cmdClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LSystemViewer.this.dispose();
            }
        });
        super.add((Component)this.guiLSystem, "Center");
        super.setVisible(true);
    }

    private int parseFlag(String arg) {
        int index = 0;
        for (String[] flag : cmdFlags) {
            for (index = 1; index < flag.length - 1; ++index) {
                if (flag[index].compareToIgnoreCase(arg) != 0) continue;
                return Integer.parseInt(flag[0]);
            }
        }
        return -1;
    }

    private void displayHelp() {
        int index = 0;
        StringBuilder help = new StringBuilder();
        help.append(I18N.get("ui.lsv.args.u", new Object[0]));
        help.append("\n");
        help.append("  ");
        help.append(I18N.get("ui.lsv.args.f", new Object[0]));
        help.append("\n");
        for (String[] flag : cmdFlags) {
            for (index = 1; index < flag.length - 1; ++index) {
                if (index == 1) {
                    help.append("  ");
                } else {
                    help.append(" ");
                }
                help.append(flag[index]);
            }
            help.append("\n");
            help.append("  ");
            help.append("  ");
            help.append(flag[flag.length - 1] + "\n");
        }
        JOptionPane.showMessageDialog(this, help);
        super.dispose();
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new GEVAUncaught.GEVAGlobalUncaught());
        new LSystemViewer(args);
    }
}

