/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.GEVADirtyListener;
import UI.GEVAPropertyContainer;
import UI.GEVAPropertyControl;
import Util.I18N;
import java.awt.Color;
import java.awt.Component;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GEVAStringProperty
extends GEVAPropertyControl
implements DocumentListener {
    public static String PT_READWRITE = "";
    public static String PP_ACCEPT_ALL = "";
    private JTextField txtValue;
    private JTextArea strValue;

    public GEVAStringProperty(GEVADirtyListener dirtyListener, GEVAPropertyContainer parent, String type, String title, String name, String comment, String initial, String params) {
        super(dirtyListener, parent, type, title, name, comment, initial, params);
        if (this.isType("rout")) {
            this.strValue = new JTextArea();
            this.strValue.setEditable(false);
        } else {
            this.txtValue = new JTextField();
            this.txtValue.getDocument().addDocumentListener(this);
        }
        parent.add(this);
        this.dirtyListener.setDirtyable(false);
        this.setText(initial);
        this.validate();
        this.dirtyListener.setDirtyable(true);
    }

    @Override
    public String getText() {
        return (this.txtValue != null ? this.txtValue : this.strValue).getText();
    }

    @Override
    public void setText(String text) {
        (this.txtValue != null ? this.txtValue : this.strValue).setText(text);
    }

    public void addText(String text) {
        if (this.txtValue != null) {
            this.txtValue.setText(this.txtValue.getText() + text);
        } else {
            this.strValue.append(text);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        (this.txtValue != null ? this.txtValue : this.strValue).setEnabled(enabled);
    }

    @Override
    public boolean load(Properties properties) {
        if (this.name == null) {
            return true;
        }
        (this.txtValue != null ? this.txtValue : this.strValue).setText(properties.getProperty(this.name, this.initial));
        return this.valid();
    }

    @Override
    public boolean save(Properties properties) {
        if (this.name == null) {
            return true;
        }
        properties.setProperty(this.name, (this.txtValue != null ? this.txtValue : this.strValue).getText().toString());
        return this.valid();
    }

    @Override
    public Component getComponent(int index) {
        if (index == 1) {
            return this.txtValue != null ? this.txtValue : this.strValue;
        }
        return super.getComponent(index);
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.dirtyListener.setDirty();
        this.validate();
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.dirtyListener.setDirty();
        this.validate();
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.dirtyListener.setDirty();
        this.validate();
    }

    @Override
    public void validate() {
        if (this.valid()) {
            (this.txtValue != null ? this.txtValue : this.strValue).setBackground(Color.white);
        } else {
            (this.txtValue != null ? this.txtValue : this.strValue).setBackground(Color.red);
        }
    }

    public boolean valid() {
        this.resetInvalidReason();
        if (super.getParam(0, null) != null && !Pattern.matches(super.getParam(0, ".*"), this.getText())) {
            this.addInvalidReason(super.getParam(1, I18N.get("ui.ctl.strg.miss.err", super.getParam(0, ""))));
            return false;
        }
        return true;
    }
}

