/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.GEVAControl;
import UI.GEVADirtyListener;
import UI.GEVAPropertyContainer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;

public abstract class GEVAPropertyControl
extends GEVAControl {
    private JLabel lblName;
    private JLabel lblReason;
    protected String initial;
    protected String[] params;

    GEVAPropertyControl(GEVADirtyListener dirtyListener, GEVAPropertyContainer parent, String type, String title, String name, String comment, String initial, String params) {
        super(dirtyListener, parent, type, title, name, comment);
        this.lblName = new JLabel(title);
        this.lblReason = new JLabel();
        this.lblReason.setForeground(Color.red);
        this.resetInvalidReason();
        this.initial = initial;
        if (params != null) {
            this.params = params.split(",");
        }
    }

    public String getParam(int index, String alternative) {
        if (this.params != null && index >= 0 && index < this.params.length && this.params[index].trim().length() != 0) {
            return this.params[index];
        }
        return alternative;
    }

    public String getParam(int index) {
        return this.getParam(index, null);
    }

    public int getParamInt(int index, int alternative) {
        try {
            if (this.params != null && index >= 0 && index < this.params.length && this.params[index].trim().length() != 0) {
                return Integer.parseInt(this.params[index]);
            }
            return alternative;
        }
        catch (NumberFormatException e) {
            return alternative;
        }
    }

    public int getParamInt(int index) {
        return this.getParamInt(index, 0);
    }

    public double getParamDouble(int index, double alternative) {
        try {
            if (this.params != null && index >= 0 && index < this.params.length && this.params[index].trim().length() != 0) {
                return Double.parseDouble(this.params[index]);
            }
            return alternative;
        }
        catch (NumberFormatException e) {
            return alternative;
        }
    }

    public double getParamDouble(int index) {
        return this.getParamDouble(index, 0.0);
    }

    public boolean getParamBoolean(int index, boolean alternative) {
        try {
            if (this.params != null && index >= 0 && index < this.params.length && this.params[index].trim().length() != 0) {
                return Boolean.parseBoolean(this.params[index]);
            }
            return alternative;
        }
        catch (NumberFormatException e) {
            return alternative;
        }
    }

    public boolean getParamBoolean(int index) {
        return this.getParamBoolean(index, false);
    }

    public boolean getParamEqual(int index, String value) {
        return this.getParam(index, "").equalsIgnoreCase(value);
    }

    @Override
    public Component getComponent(int index) {
        switch (index) {
            case 0: {
                return this.lblName;
            }
            case 2: {
                return this.lblReason;
            }
        }
        return null;
    }

    @Override
    public int countComponents() {
        return 3;
    }

    @Override
    public void setVisibleControlGroup(String name, boolean show) {
        this.parent.setVisibleControlGroup(name, show);
    }

    @Override
    public void setVisible(boolean show) {
        this.getComponent(0).setVisible(show);
        this.getComponent(1).setVisible(show);
        if (this.lblReason.getText().length() != 0) {
            this.getComponent(2).setVisible(show);
        }
    }

    protected void resetInvalidReason() {
        this.lblReason.setText("");
        this.lblReason.setVisible(false);
    }

    protected boolean addInvalidReason(String reason) {
        String text;
        if (this.getComponent(0).isVisible()) {
            this.lblReason.setVisible(true);
        }
        text = (text = this.lblReason.getText()).length() == 0 ? "<html>" + reason : text + "<br>" + reason;
        this.lblReason.setText(text);
        return false;
    }
}

