/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.GEVAActionEvent;
import UI.GEVAActionListener;
import UI.GEVABookContainer;
import UI.GEVAChoiceProperty;
import UI.GEVAConfig;
import UI.GEVAConfigGUI;
import UI.GEVAControl;
import UI.GEVAControlGroup;
import UI.GEVADirtyListener;
import UI.GEVAFileProperty;
import UI.GEVAFitness;
import UI.GEVAJarHunter;
import UI.GEVAMessage;
import UI.GEVANumberProperty;
import UI.GEVAPageContainer;
import UI.GEVAPropertyRowContainer;
import UI.GEVASplash;
import UI.GEVASpringContainer;
import UI.Run.GEVAGraphPaneCategory;
import UI.Run.GEVAGraphPaneConfig;
import UI.Run.GEVAGraphPaneItem;
import UI.Run.GEVARun;
import UI.Run.GEVARunning;
import UI.Run.JSci.GEVAGraphColours;
import Util.GEVAHelper;
import Util.GEVAUncaught;
import Util.I18N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class GEVAPropertiesGUI
extends JFrame
implements ActionListener,
WindowListener,
MouseListener,
GEVAActionListener,
GEVADirtyListener {
    private static final int SCF_PROMPT = 0;
    private static final int SCF_MARK = 1;
    private String propertiesFile;
    private Properties properties;
    private String grammarFiles;
    private FitnessDetails fitnessDetails = new FitnessDetails();
    private GEVAFitness fitness;
    private boolean initialising;
    private boolean isDirty = false;
    private boolean canDirty = true;
    private int resultOption;
    private JLabel lblPropertiesFiles;
    private JComboBox cboPropertiesFiles;
    private JButton cmdPropertiesFilesNew;
    private JButton cmdPropertiesFilesDelete;
    private GEVABookContainer guiProperties;
    private GEVAChoiceProperty guiFitnessFunctions;
    private GEVAChoiceProperty guiGrammarFiles;
    private GEVAControl guiPopulationSize;
    private GEVAControl guiReplacementType;
    private GEVAControl guiEliteSize;
    private GEVAControl guiSelection;
    private GEVAControl guiTournamentSize;
    private GEVAControl guiPickSize;
    private JButton cmdRun;
    private JButton cmdSave;
    private JButton cmdClose;
    private JButton cmdConfig;

    private GEVAPropertiesGUI() {
        if (this.initialiseUI()) {
            this.showUI();
        }
    }

    private boolean initialiseUI() {
        boolean initOk = true;
        this.initialising = true;
        new GEVASplash((Window)this);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        super.setBounds((screen.width - 500) / 2, (screen.height - 740) / 2, 500, 740);
        super.setTitle(I18N.get("ui.gui", new Object[0]));
        super.addWindowListener(this);
        super.setDefaultCloseOperation(0);
        super.getContentPane().setLayout(new BorderLayout());
        this.initialisePropertiesFilesUI();
        initOk = this.initialiseFFConfig() & initOk;
        initOk = this.initialiseGraphConfig() & initOk;
        this.initialisePropertiesUI();
        this.initialiseCommandUI();
        this.initialising = false;
        this.cboPropertiesFiles.setSelectedItem(GEVAConfig.getSelectedPropertiesFile());
        if (this.cboPropertiesFiles.getSelectedItem() == null) {
            this.unloadPropertiesFile();
        }
        if (!initOk) {
            return this.configure(true);
        }
        return true;
    }

    private void initialisePropertiesFilesUI() {
        int i;
        JPanel guiPropertiesFiles = new JPanel();
        guiPropertiesFiles.setLayout(new GridBagLayout());
        this.lblPropertiesFiles = new JLabel(I18N.get("ui.gui.labl.prop", new Object[0]));
        this.cboPropertiesFiles = new JComboBox();
        this.cmdPropertiesFilesNew = new JButton(I18N.get("ui.gui.ctrl.pnew", new Object[0]));
        this.cmdPropertiesFilesDelete = new JButton(I18N.get("ui.gui.ctrl.pdel", new Object[0]));
        File file = new File(GEVAConfig.getPropertiesAbsPath());
        String[] files = file.list();
        if (files != null) {
            for (i = 0; i < files.length; ++i) {
                if (files[i].length() <= ".properties".length() || !files[i].substring(files[i].length() - ".properties".length()).equalsIgnoreCase(".properties")) continue;
                this.cboPropertiesFiles.addItem(files[i]);
            }
        }
        this.cboPropertiesFiles.addActionListener(this);
        this.cmdPropertiesFilesNew.addActionListener(this);
        this.cmdPropertiesFilesDelete.addActionListener(this);
        GEVAHelper.gridAdd(guiPropertiesFiles, this.lblPropertiesFiles, 0, 0, 0.0);
        GEVAHelper.gridAdd(guiPropertiesFiles, this.cboPropertiesFiles, 1, 0, 1.0);
        GEVAHelper.gridAdd(guiPropertiesFiles, this.cmdPropertiesFilesNew, 2, 0, 0.0);
        GEVAHelper.gridAdd(guiPropertiesFiles, this.cmdPropertiesFilesDelete, 3, 0, 0.0);
        file = new File(GEVAConfig.getGrammarAbsPath());
        files = file.list();
        if (files != null) {
            for (i = 0; i < files.length; ++i) {
                if (files[i].length() <= ".bnf".length() || !files[i].substring(files[i].length() - ".bnf".length()).equalsIgnoreCase(".bnf")) continue;
                this.grammarFiles = this.grammarFiles == null ? files[i] : this.grammarFiles + "," + files[i];
            }
        }
        this.getContentPane().add((Component)guiPropertiesFiles, "North");
    }

    private boolean initialiseFFConfig() {
        int mode = 0;
        try {
            String line;
            FileInputStream stream = new FileInputStream(GEVAConfig.getConfigAbsPath() + "ff.config");
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                if (line.indexOf(35) != -1) {
                    line = line.substring(0, line.indexOf(35));
                }
                if ((line = line.trim()).length() == 0) continue;
                if (line.charAt(0) == '-') {
                    if (line.equals("-class")) {
                        mode = 0;
                        continue;
                    }
                    if (line.equals("-jar")) {
                        mode = 1;
                        continue;
                    }
                    if (line.equals("-cmd")) {
                        mode = 2;
                        continue;
                    }
                    mode = -1;
                    continue;
                }
                if (line.indexOf(44) == -1) continue;
                switch (mode) {
                    case 0: {
                        this.initialiseFFConfigClass(line);
                        break;
                    }
                    case 1: {
                        this.initialiseFFConfigJar(line);
                        break;
                    }
                    case 2: {
                        this.initialiseFFConfigCmd(line);
                    }
                }
            }
        }
        catch (IOException e) {
            GEVAMessage.showMessage((Component)this, I18N.get("ui.gui.fflo.err", e.getMessage()), 64, new String[0]);
            e.printStackTrace();
            return false;
        }
        GEVAJarHunter.start();
        return true;
    }

    private void initialiseFFConfigClass(String line) {
        String[] parts = GEVAHelper.trim(line.split(","));
        GEVAFitness ff = new GEVAFitness();
        ff.grammarFile = parts[1];
        for (int i = 2; i < parts.length; ++i) {
            ff.names.add(parts[i]);
        }
        this.fitnessDetails.put(parts[0], ff);
    }

    private void initialiseFFConfigJar(String line) {
        String[] parts = GEVAHelper.trim(line.split(","));
        GEVAJarHunter.add(parts[0], parts[1]);
    }

    private void initialiseFFConfigCmd(String line) {
        int index = line.indexOf(44);
        GEVAFitness.fitnessCommands.put(line.substring(0, index), line.substring(index + 1));
    }

    private boolean initialiseGraphConfig() {
        GEVAGraphPaneCategory category = null;
        try {
            String line;
            FileInputStream stream = new FileInputStream(GEVAConfig.getConfigAbsPath() + "graph.config");
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                if (line.indexOf(35) != -1) {
                    line = line.substring(0, line.indexOf(35));
                }
                if ((line = line.trim()).length() == 0) continue;
                if (line.charAt(0) == '-') {
                    category = new GEVAGraphPaneCategory(line.substring(1));
                    GEVAGraphPaneConfig.addCategory("GEVA", category);
                    continue;
                }
                if (line.length() == 0 || category == null) continue;
                this.initialiseGraphConfigItem(category, line);
            }
        }
        catch (IOException e) {
            GEVAMessage.showMessage((Component)this, I18N.get("ui.gui.fflo.err", e.getMessage()), 64, new String[0]);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void initialiseGraphConfigItem(GEVAGraphPaneCategory category, String line) {
        String[] parts = GEVAHelper.trim(line.split(","));
        String name = "";
        int visible = GEVAGraphPaneItem.VISIBLE_HIDE;
        Color colour = null;
        String title = "";
        String measure = "";
        String errorName = "";
        if (parts.length < 1) {
            return;
        }
        name = parts[0];
        if (parts.length > 1) {
            if (parts[1].equalsIgnoreCase("show")) {
                visible = GEVAGraphPaneItem.VISIBLE_SHOW;
            } else if (parts[1].equalsIgnoreCase("bold")) {
                visible = GEVAGraphPaneItem.VISIBLE_BOLD;
            }
        }
        if (parts.length > 2) {
            colour = this.initialiseGraphConfigItemColour(parts[2]);
        }
        if (parts.length > 3) {
            title = parts[3];
        }
        if (parts.length > 4) {
            measure = parts[4];
        }
        if (parts.length > 5) {
            errorName = parts[5];
        }
        category.addItem(new GEVAGraphPaneItem(name, visible, colour, title, measure, errorName));
    }

    private Color initialiseGraphConfigItemColour(String colour) {
        if ((colour.length() == 3 || colour.length() == 6) && Pattern.matches("[0-9a-fA-F]*", colour)) {
            if (colour.length() == 3) {
                int red = Integer.parseInt(colour.substring(0, 1), 16);
                int green = Integer.parseInt(colour.substring(1, 2), 16);
                int blue = Integer.parseInt(colour.substring(2, 3), 16);
                return new Color(red * 16 + red, green * 16 + green, blue * 16 + blue);
            }
            int red = Integer.parseInt(colour.substring(0, 2), 16);
            int green = Integer.parseInt(colour.substring(2, 4), 16);
            int blue = Integer.parseInt(colour.substring(4, 6), 16);
            return new Color(red, green, blue);
        }
        return GEVAGraphColours.getNamedColour(colour);
    }

    private void initialiseCommandUI() {
        JPanel guiCommand = new JPanel();
        JPanel guiSeparator = new JPanel();
        guiCommand.setLayout(new GridBagLayout());
        this.cmdRun = new JButton(I18N.get("ui.gui.ctrl.prun", new Object[0]));
        this.cmdSave = new JButton(I18N.get("ui.gui.ctrl.save", new Object[0]));
        this.cmdClose = new JButton(I18N.get("ui.ctrl.exit", new Object[0]));
        this.cmdConfig = new JButton(I18N.get("ui.gui.ctrl.conf", new Object[0]));
        this.cmdRun.addActionListener(this);
        this.cmdSave.addActionListener(this);
        this.cmdSave.addMouseListener(this);
        this.cmdClose.addActionListener(this);
        this.cmdConfig.addActionListener(this);
        this.cmdSave.setEnabled(false);
        GEVAHelper.gridAdd(guiCommand, this.cmdRun, 0, 0, 0.0);
        GEVAHelper.gridAdd(guiCommand, guiSeparator, 1, 0, 1.0);
        GEVAHelper.gridAdd(guiCommand, this.cmdConfig, 2, 0, 0.0);
        GEVAHelper.gridAdd(guiCommand, this.cmdSave, 3, 0, 0.0);
        GEVAHelper.gridAdd(guiCommand, this.cmdClose, 4, 0, 0.0);
        this.getContentPane().add((Component)guiCommand, "South");
    }

    private void initialisePropertiesUI() {
        this.guiProperties = new GEVABookContainer(this, I18N.get("ui.gui.tip", new Object[0]));
        this.initialisePropGeneralUI();
        this.getContentPane().add(this.guiProperties.getComponent(), "Center");
    }

    private void initialisePropGeneralUI() {
        GEVAControlGroup tournamentGroup = new GEVAControlGroup();
        GEVAControlGroup userpickGroup = new GEVAControlGroup();
        GEVAControlGroup generationGapGroup = new GEVAControlGroup();
        GEVAControlGroup initialiserGroup = new GEVAControlGroup();
        GEVAControlGroup rampedInitGroup = new GEVAControlGroup();
        GEVAControlGroup lSysGroup = new GEVAControlGroup();
        this.guiProperties.addControlGroup("lSysGroup", lSysGroup);
        this.guiProperties.addControlGroup("tournamentGroup", tournamentGroup);
        this.guiProperties.addControlGroup("userpickGroup", userpickGroup);
        this.guiProperties.addControlGroup("generationGapGroup", generationGapGroup);
        this.guiProperties.addControlGroup("initialiserGroup", initialiserGroup);
        this.guiProperties.addControlGroup("rampedInitGroup", rampedInitGroup);
        String fitnessFunctions = null;
        GEVAPageContainer guiPageGeneral = new GEVAPageContainer(this, this.guiProperties, I18N.get("ui.gui.geva", new Object[0]), I18N.get("ui.gui.geva.tip", new Object[0]));
        GEVAPropertyRowContainer container = new GEVAPropertyRowContainer(this, guiPageGeneral, I18N.get("ui.gui.gene", new Object[0]), I18N.get("ui.gui.gene.tip", new Object[0]));
        new GEVAChoiceProperty(this, container, "bool", I18N.get("ui.gui.gene.solv", new Object[0]), "stopWhenSolved", I18N.get("ui.gui.gene.solv.tip", new Object[0]), I18N.get("ui.gui.gene.solv.true", new Object[0]), I18N.get("ui.gui.gene.solv.true", new Object[0]) + "," + I18N.get("ui.gui.gene.solv.fals", new Object[0]));
        new GEVAChoiceProperty(this, container, "group", I18N.get("ui.gui.gene.codo", new Object[0]), "null", I18N.get("ui.gui.gene.codo.tip", new Object[0]), I18N.get("ui.gui.gene.codo.int", new Object[0]), I18N.get("ui.gui.gene.codo.int", new Object[0]));
        new GEVANumberProperty(this, container, GEVANumberProperty.PT_INT, I18N.get("ui.gui.gene.gner", new Object[0]), "generations", I18N.get("ui.gui.gene.gner.tip", new Object[0]), "20", "1,0," + (GEVAConfig.isExpert() ? "" : "20000"));
        this.guiPopulationSize = new GEVANumberProperty(this, container, GEVANumberProperty.PT_INT, I18N.get("ui.gui.gene.popu", new Object[0]), "population_size", I18N.get("ui.gui.gene.popu.tip", new Object[0]), "100", "1,0," + (GEVAConfig.isExpert() ? "" : "5000"));
        this.guiPopulationSize.addActionListener(this);
        new GEVANumberProperty(this, container, GEVANumberProperty.PT_INT, I18N.get("ui.gui.gene.wrap", new Object[0]), "max_wraps", I18N.get("ui.gui.gene.wrap.tip", new Object[0]), "1", "1,0,");
        new GEVAFileProperty(this, container, GEVAFileProperty.PT_FILE_OR_FOLDER, I18N.get("ui.gui.gene.outf", new Object[0]), "output", I18N.get("ui.gui.gene.outf.tip", new Object[0]), "", ",," + GEVAFileProperty.PP_IGNORE_EXIST);
        container = new GEVAPropertyRowContainer(this, guiPageGeneral, I18N.get("ui.gui.fifu", new Object[0]), I18N.get("ui.gui.fifu.tip", new Object[0]));
        for (String fitnessFunctionEx : this.fitnessDetails.keySet()) {
            if (fitnessFunctions == null) {
                fitnessFunctions = fitnessFunctionEx;
                continue;
            }
            fitnessFunctions = fitnessFunctions + "," + fitnessFunctionEx;
        }
        this.guiFitnessFunctions = new GEVAChoiceProperty(this, container, "", I18N.get("ui.gui.fifu.fifu", new Object[0]), "fitness_function", I18N.get("ui.gui.fifu.fifu.tip", new Object[0]), "FitnessEvaluation.PatternMatch.WordMatch", fitnessFunctions);
        this.guiFitnessFunctions.addActionListener(this);
        this.guiGrammarFiles = new GEVAChoiceProperty(this, container, "", I18N.get("ui.gui.fifu.gram", new Object[0]), "grammar_file", I18N.get("ui.gui.fifu.gram.tip", new Object[0]), null, this.grammarFiles);
        this.guiGrammarFiles.addActionListener(this);
        container = new GEVAPropertyRowContainer(this, guiPageGeneral, I18N.get("ui.gui.rese", new Object[0]), I18N.get("ui.gui.rese.tip", new Object[0]));
        this.guiReplacementType = new GEVAChoiceProperty(this, container, "group", I18N.get("ui.gui.rese.rety", new Object[0]), "replacement_type", I18N.get("ui.gui.rese.rety.tip", new Object[0]), "steady_state", "steady_state,,generational,generationGapGroup");
        this.guiReplacementType.addActionListener(this);
        this.guiEliteSize = new GEVANumberProperty(this, container, GEVANumberProperty.PT_INT, I18N.get("ui.gui.rese.elit", new Object[0]), "elite_size", I18N.get("ui.gui.rese.elit.tip", new Object[0]), "1", "1,0,");
        this.guiEliteSize.addActionListener(this);
        this.guiSelection = new GEVAChoiceProperty(this, container, "group", I18N.get("ui.gui.rese.seop", new Object[0]), "selection_operation", I18N.get("ui.gui.rese.seop.tip", new Object[0]), "Operator.Operations.TournamentSelect", "Operator.Operations.TournamentSelect,tournamentGroup,Operator.Operations.ScaledRouletteWheel,,Operator.Operations.ProportionalRouletteWheel,,Operator.Operations.SimpleUserSelect,userpickGroup,Operator.Operations.LSystemSelect,lSysGroup,");
        this.guiTournamentSize = new GEVANumberProperty(this, container, GEVANumberProperty.PT_INT, I18N.get("ui.gui.rese.tosi", new Object[0]), "tournament_size", I18N.get("ui.gui.rese.tosi.tip", new Object[0]), "3", "1,1,");
        this.guiTournamentSize.addActionListener(this);
        tournamentGroup.add(this.guiTournamentSize);
        lSysGroup.add(this.guiEliteSize);
        lSysGroup.add(this.guiReplacementType);
        lSysGroup.setHiding(true);
        this.guiPickSize = new GEVANumberProperty(this, container, GEVANumberProperty.PT_INT, I18N.get("ui.gui.rese.pisi", new Object[0]), "userpick_size", I18N.get("ui.gui.rese.pisi.tip", new Object[0]), "10", "1,2,");
        this.guiPickSize.addActionListener(this);
        userpickGroup.add(this.guiPickSize);
        container = new GEVAPropertyRowContainer(this, guiPageGeneral, I18N.get("ui.gui.init", new Object[0]), I18N.get("ui.gui.init.tip", new Object[0]));
        new GEVAChoiceProperty(this, container, "group", I18N.get("ui.gui.init.init", new Object[0]), "initialiser", I18N.get("ui.gui.init.init.tip", new Object[0]), "Operator.Initialiser", "Operator.Initialiser,initialiserGroup,Operator.RampedHalfAndHalfInitialiser,rampedInitGroup");
        rampedInitGroup.add(new GEVANumberProperty(this, container, GEVANumberProperty.PT_INT, I18N.get("ui.gui.init.mxdp", new Object[0]), "max_depth", I18N.get("ui.gui.init.mxdp.tip", new Object[0]), "10", "1,0,"));
        initialiserGroup.add(new GEVANumberProperty(this, container, GEVANumberProperty.PT_INT, I18N.get("ui.gui.init.crsi", new Object[0]), "initial_chromosome_size", I18N.get("ui.gui.init.crsi.tip", new Object[0]), "200", "1,0,"));
        rampedInitGroup.add(new GEVANumberProperty(this, container, GEVANumberProperty.PT_FLOAT, I18N.get("ui.gui.init.grpr", new Object[0]), "grow_probability", I18N.get("ui.gui.init.grpr.tip", new Object[0]), "0.5", "0.1,0,1"));
        container = new GEVAPropertyRowContainer(this, guiPageGeneral, I18N.get("ui.gui.othr", new Object[0]), I18N.get("ui.gui.othr.tip", new Object[0]));
        new GEVANumberProperty(this, container, GEVANumberProperty.PT_FLOAT, I18N.get("ui.gui.othr.crpr", new Object[0]), "crossover_probability", I18N.get("ui.gui.othr.crpr.tip", new Object[0]), "0.9", "0.1,0,1");
        new GEVAChoiceProperty(this, container, "bool", I18N.get("ui.gui.othr.crpo", new Object[0]), "fixed_point_crossover", I18N.get("ui.gui.othr.crpo.tip", new Object[0]), I18N.get("ui.gui.othr.crpo.true", new Object[0]), I18N.get("ui.gui.othr.crpo.true", new Object[0]) + "," + I18N.get("ui.gui.othr.crpo.fals", new Object[0]));
        new GEVANumberProperty(this, container, GEVANumberProperty.PT_FLOAT, I18N.get("ui.gui.othr.mupr", new Object[0]), "mutation_probability", I18N.get("ui.gui.othr.mupr.tip", new Object[0]), "0.01", "0.01,0,1");
        new GEVASpringContainer(this, guiPageGeneral);
    }

    private void runPropertiesFile() {
        String runPath;
        try {
            File file = File.createTempFile("gep", ".properties");
            file.deleteOnExit();
            this.savePropertiesFile(file.getAbsolutePath());
            runPath = file.getAbsolutePath();
        }
        catch (IOException e) {
            GEVAMessage.showMessage((Component)this, I18N.get("ui.gui.prus.err", e.getMessage()), 64, new String[0]);
            e.printStackTrace();
            return;
        }
        GEVARunning.add(new GEVARun((Frame)this, runPath, this.fitness));
    }

    private void unloadPropertiesFile() {
        this.cboPropertiesFiles.setSelectedItem(null);
        this.setClean(1);
        this.cmdRun.setEnabled(false);
        this.guiProperties.setEnabled(false);
        this.propertiesFile = null;
    }

    private void newPropertiesFile() {
        Properties cloneProperties = null;
        if (!this.setClean()) {
            return;
        }
        this.setClean(1);
        if (this.cboPropertiesFiles.getSelectedItem() != null) {
            cloneProperties = new Properties();
            this.guiProperties.save(cloneProperties);
        }
        this.cboPropertiesFiles.setSelectedItem(null);
        this.propertiesFile = null;
        if (cloneProperties != null) {
            this.guiProperties.load(cloneProperties);
            this.setClean(1);
        }
        this.cmdSave.setEnabled(true);
        this.savePropertiesFile();
    }

    private boolean loadPropertiesFile() {
        if (!this.setClean()) {
            this.cboPropertiesFiles.setSelectedItem(this.propertiesFile);
            return false;
        }
        try {
            this.properties = new Properties();
            if (this.cboPropertiesFiles.getSelectedItem() != null) {
                this.propertiesFile = this.cboPropertiesFiles.getSelectedItem().toString();
                FileInputStream stream = new FileInputStream(GEVAConfig.getPropertiesAbsPath() + this.propertiesFile);
                this.properties.load(stream);
            }
            if (!this.guiProperties.load(this.properties)) {
                GEVAMessage.showMessage((Component)this, I18N.get("ui.gui.prlo.wrn", new Object[0]), 48, new String[0]);
            }
            this.setClean(1);
            this.cmdRun.setEnabled(true);
            this.guiProperties.setEnabled(true);
            return true;
        }
        catch (IOException e) {
            this.unloadPropertiesFile();
            GEVAMessage.showMessage((Component)this, I18N.get("ui.gui.prlo.err", e), 64, new String[0]);
            e.printStackTrace();
            return false;
        }
    }

    private boolean savePropertiesFile() {
        return this.savePropertiesFile(null);
    }

    private boolean savePropertiesFile(String tempFilename) {
        String propertiesFileEx = null;
        boolean newFile = false;
        try {
            String filename;
            if (!this.guiProperties.save(this.properties) && GEVAMessage.showMessage((Component)this, I18N.get("ui.gui.prsa.wrn", new Object[0]), 51, new String[0]) == 2) {
                return false;
            }
            if (tempFilename == null) {
                propertiesFileEx = this.getActivePropertiesFile();
                this.setActivePropertiesFile();
                if (propertiesFileEx == null) {
                    propertiesFileEx = this.getNewPropertiesFile();
                    newFile = true;
                }
                if (propertiesFileEx == null) {
                    return false;
                }
                filename = GEVAConfig.getPropertiesAbsPath() + propertiesFileEx;
            } else {
                filename = tempFilename;
            }
            FileOutputStream stream = new FileOutputStream(filename);
            this.properties.store(stream, null);
            stream.close();
            if (tempFilename == null) {
                this.setClean(1);
                if (newFile) {
                    this.cboPropertiesFiles.removeItem(propertiesFileEx);
                    this.cboPropertiesFiles.addItem(propertiesFileEx);
                    if (this.cboPropertiesFiles.getSelectedItem() == null) {
                        this.cboPropertiesFiles.setSelectedItem(propertiesFileEx);
                    }
                }
            }
            return true;
        }
        catch (IOException e) {
            GEVAMessage.showMessage((Component)this, I18N.get("ui.gui.prsa.err", e), 64, new String[0]);
            e.printStackTrace();
            return false;
        }
    }

    private String getActivePropertiesFile() {
        String selectedPropertiesFile = null;
        if (this.cboPropertiesFiles.getSelectedItem() != null) {
            selectedPropertiesFile = this.cboPropertiesFiles.getSelectedItem().toString();
        }
        if (selectedPropertiesFile != null && !selectedPropertiesFile.equals(this.propertiesFile) || selectedPropertiesFile == null && this.propertiesFile != null) {
            selectedPropertiesFile = this.propertiesFile;
        }
        return selectedPropertiesFile;
    }

    private void setActivePropertiesFile() {
        if (this.cboPropertiesFiles.getSelectedItem() != null) {
            this.propertiesFile = this.cboPropertiesFiles.getSelectedItem().toString();
        }
    }

    private String getNewPropertiesFile() {
        String newPropertiesFile = null;
        boolean tryAgain = true;
        while (tryAgain) {
            boolean exists;
            newPropertiesFile = JOptionPane.showInputDialog(this, I18N.get("ui.gui.prsa.msg", new Object[0]), newPropertiesFile);
            if (newPropertiesFile == null) {
                return null;
            }
            if (!newPropertiesFile.endsWith(".properties")) {
                newPropertiesFile = newPropertiesFile + ".properties";
            }
            if (exists = new File(GEVAConfig.getPropertiesAbsPath() + newPropertiesFile).exists()) {
                switch (GEVAMessage.showMessage((Component)this, I18N.get("ui.gui.prow.wrn", new Object[0]), 55, new String[0])) {
                    case 1: {
                        tryAgain = false;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 4: {
                        return null;
                    }
                }
                continue;
            }
            tryAgain = false;
        }
        return newPropertiesFile;
    }

    public void deletePropertiesFile() {
        File file = null;
        String propertiesFileEx = null;
        if (this.cboPropertiesFiles.getSelectedItem() != null) {
            propertiesFileEx = this.cboPropertiesFiles.getSelectedItem().toString();
            file = new File(GEVAConfig.getPropertiesAbsPath() + propertiesFileEx);
            if (GEVAMessage.showMessage((Component)this, I18N.get("ui.gui.prde.wrn", GEVAConfig.getPropertiesAbsPath() + propertiesFileEx), 53, new String[0]) == 4) {
                return;
            }
        } else if (this.isDirty && GEVAMessage.showMessage((Component)this, I18N.get("ui.gui.prlc.wrn", new Object[0]), 53, new String[0]) == 4) {
            return;
        }
        if (propertiesFileEx == null || this.doDeletePropertiesFiles(file)) {
            this.setClean(1);
            if (propertiesFileEx != null) {
                this.cboPropertiesFiles.removeItem(propertiesFileEx);
            }
            this.unloadPropertiesFile();
        }
    }

    private boolean doDeletePropertiesFiles(File file) {
        System.gc();
        if (file != null && !file.delete()) {
            GEVAMessage.showMessage((Component)this, I18N.get("ui.gui.prde.err", file.getName()), 64, new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public void setDirty() {
        this.cmdSave.setEnabled(true);
        this.isDirty = true;
        this.setTitle(I18N.get("ui.gui", new Object[0]) + " *");
    }

    @Override
    public void setDirtyable(boolean dirtyable) {
        this.canDirty = dirtyable;
    }

    @Override
    public boolean canDirty() {
        return this.canDirty;
    }

    public boolean setClean() {
        return this.setClean(0);
    }

    private boolean setClean(int flag) {
        if (!this.isDirty) {
            return true;
        }
        if (flag == 0) {
            switch (GEVAMessage.showMessage((Component)this, I18N.get("ui.gui.lodi.wrn", new Object[0]), 55, new String[0])) {
                case 1: {
                    return this.savePropertiesFile();
                }
                case 2: {
                    return true;
                }
                case 4: {
                    return false;
                }
            }
        } else if (flag == 1) {
            this.cmdSave.setEnabled(false);
            this.isDirty = false;
            this.setTitle(I18N.get("ui.gui", new Object[0]));
            return true;
        }
        GEVAMessage.showMessage((Component)this, I18N.get("ui.unkn.bug", new Object[0]), 64, new String[0]);
        return false;
    }

    private int showUI() {
        this.setVisible(true);
        return this.resultOption;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.initialising) {
            return;
        }
        if (event.getSource() == this.cmdClose) {
            this.close();
        } else if (event.getSource() == this.cmdPropertiesFilesNew) {
            this.newPropertiesFile();
        } else if (event.getSource() == this.cmdPropertiesFilesDelete) {
            this.deletePropertiesFile();
        } else if (event.getSource() == this.cboPropertiesFiles) {
            if (this.cboPropertiesFiles.getSelectedItem() != null) {
                GEVAConfig.setSelectedPropertiesFile(this.cboPropertiesFiles.getSelectedItem().toString());
            }
            this.loadPropertiesFile();
        } else if (event.getSource() == this.cmdSave) {
            this.savePropertiesFile();
        } else if (event.getSource() == this.cmdRun) {
            this.runPropertiesFile();
        } else if (event.getSource() == this.cmdConfig) {
            this.configure(false);
        } else {
            GEVAMessage.showMessage((Component)this, I18N.get("ui.err.main.noim", event.getActionCommand()), new String[0]);
        }
    }

    public void close() {
        this.windowClosing(null);
    }

    boolean configure(boolean force) {
        GEVAConfigGUI config = new GEVAConfigGUI(this);
        if (config.forceReset()) {
            this.reset();
            return false;
        }
        if (config.needReset()) {
            if (force) {
                this.reset();
                return false;
            }
            if (GEVAMessage.showMessage((Component)this, I18N.get("ui.gui.rset.wrn", new Object[0]), 3, new String[0]) == 1) {
                this.reset();
                return false;
            }
        }
        return true;
    }

    private void reset() {
        if (this.setClean() && GEVARunning.closeAll()) {
            GEVAGraphPaneConfig.reset();
            this.dispose();
            new GEVAPropertiesGUI();
        }
    }

    @Override
    public void windowClosing(WindowEvent event) {
        if (this.setClean() && GEVARunning.closeAll()) {
            GEVAConfig.saveQuiet();
            System.exit(0);
        }
    }

    @Override
    public void windowActivated(WindowEvent event) {
    }

    @Override
    public void windowClosed(WindowEvent event) {
    }

    @Override
    public void windowDeactivated(WindowEvent event) {
    }

    @Override
    public void windowDeiconified(WindowEvent event) {
    }

    @Override
    public void windowIconified(WindowEvent event) {
    }

    @Override
    public void windowOpened(WindowEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.isDirty) {
            this.cmdSave.setEnabled(true);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.isDirty) {
            this.cmdSave.setEnabled(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public boolean actionPerformed(GEVAActionEvent event) {
        switch (event.getAction()) {
            case 2: {
                if (event.getSource() == this.guiFitnessFunctions) {
                    this.fitness = (GEVAFitness)this.fitnessDetails.get(event.getActionString());
                    this.guiGrammarFiles.setText(this.fitness.grammarFile);
                }
                if (event.getSource() != this.guiReplacementType || !this.guiReplacementType.getText().equals("steady_state")) break;
                this.guiEliteSize.setText("0");
                break;
            }
            case 0: {
                int slash;
                String grammar;
                if (event.getSource() == this.guiGrammarFiles && (grammar = event.getActionString()) != null && ((slash = (grammar = grammar.replace('\\', '/')).lastIndexOf(47)) != -1 || (slash = grammar.lastIndexOf(58)) != -1)) {
                    event.setActionString(grammar.substring(slash + 1));
                }
                return true;
            }
            case 1: {
                if (event.getSource() == this.guiGrammarFiles) {
                    event.setActionString(GEVAConfig.getGrammarRelPath() + event.getActionString());
                }
                return true;
            }
            case 3: {
                if (event.getSource() == this.guiPopulationSize) {
                    this.guiEliteSize.validate();
                    this.guiTournamentSize.validate();
                    this.guiPickSize.validate();
                    break;
                }
                if (event.getSource() != this.guiEliteSize && event.getSource() != this.guiTournamentSize && event.getSource() != this.guiPickSize) break;
                try {
                    if (Integer.parseInt(event.getActionString()) > Integer.parseInt(this.guiPopulationSize.getText())) {
                        event.addInvalidReason(I18N.get("ui.ctl.main.less.err", this.guiPopulationSize.getText()));
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    event.addInvalidReason(I18N.get("ui.ctl.main.pars.err", new Object[0]));
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new GEVAUncaught.GEVAGlobalUncaught());
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        if (GEVAConfig.initialise(args)) {
            new GEVAPropertiesGUI();
        }
    }

    private static class FitnessDetails
    extends HashMap<String, GEVAFitness> {
        private FitnessDetails() {
        }
    }
}

