/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.GEVAActionEvent;
import UI.GEVADirtyListener;
import UI.GEVAPropertyContainer;
import UI.GEVAPropertyControl;
import Util.I18N;
import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormatSymbols;
import java.util.Properties;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GEVANumberProperty
extends GEVAPropertyControl
implements ChangeListener,
DocumentListener {
    public static String PT_INT = "int";
    public static String PT_FLOAT = "float";
    private JSpinner numValue;

    public GEVANumberProperty(GEVADirtyListener dirtyListener, GEVAPropertyContainer parent, String type, String title, String name, String comment, String initial, String params) {
        super(dirtyListener, parent, type, title, name, comment, initial, params);
        if (this.isType(PT_INT)) {
            this.initialiseInt(initial);
        } else if (this.isType(PT_FLOAT)) {
            this.initialiseFloat(initial);
        }
        this.numValue.addChangeListener(this);
        JFormattedTextField textField = ((JSpinner.DefaultEditor)this.numValue.getEditor()).getTextField();
        textField.setHorizontalAlignment(2);
        textField.getDocument().addDocumentListener(this);
        parent.add(this);
    }

    private void initialiseInt(String initial) {
        int value = Integer.parseInt(initial);
        int min = this.getParamInt(1, Integer.MIN_VALUE);
        int max = this.getParamInt(2, Integer.MAX_VALUE);
        int step = this.getParamInt(0, 1);
        this.numValue = new JSpinner(new SpinnerNumberModel(value, min, max, step));
        this.numValue.setEditor(new JSpinner.NumberEditor(this.numValue));
    }

    private void initialiseFloat(String initial) {
        double value = Double.parseDouble(initial);
        double min = this.getParamDouble(1, Double.NEGATIVE_INFINITY);
        double max = this.getParamDouble(2, Double.POSITIVE_INFINITY);
        double step = this.getParamDouble(0, 0.1);
        this.numValue = new JSpinner(new SpinnerNumberModel(value, min, max, step));
        this.numValue.setEditor(new JSpinner.NumberEditor(this.numValue));
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.numValue.setEnabled(enabled);
    }

    @Override
    public boolean load(Properties properties) {
        String value = properties.getProperty(this.name, this.initial).replace(",", "");
        GEVAActionEvent event = new GEVAActionEvent(this, 0, value, -1);
        if (!this.fireActionEvent(event)) {
            value = this.initial;
        } else if (event.isDirty()) {
            value = event.getActionString();
        }
        this.setText(value);
        return this.valid() || !this.numValue.isVisible();
    }

    @Override
    public boolean save(Properties properties) {
        String value = this.getText();
        GEVAActionEvent event = new GEVAActionEvent(this, 1, value, -1);
        boolean write = this.fireActionEvent(event);
        if (event.isDirty()) {
            value = event.getActionString();
        }
        if (write) {
            properties.setProperty(this.name, value);
        }
        return this.valid() || !this.numValue.isVisible();
    }

    @Override
    public Component getComponent(int index) {
        if (index == 1) {
            return this.numValue;
        }
        return super.getComponent(index);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (this.eventFireAndSet(2)) {
            this.dirtyListener.setDirty();
        }
        this.validate();
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.validate();
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.validate();
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.validate();
    }

    public boolean valid() {
        boolean valid = true;
        this.resetInvalidReason();
        if (this.isType(PT_INT)) {
            try {
                int value = Integer.parseInt(this.getText());
                if (this.getParam(1) != null && value < this.getParamInt(1)) {
                    valid = this.addInvalidReason(I18N.get("ui.ctl.numb.less.err", this.getParamInt(1)));
                }
                if (this.getParam(2) != null && value > this.getParamInt(2)) {
                    valid = this.addInvalidReason(I18N.get("ui.ctl.numb.more.err", this.getParamInt(2)));
                }
            }
            catch (NumberFormatException e) {
                valid = this.addInvalidReason(I18N.get("ui.ctl.numb.bint.err", new Object[0]));
            }
        } else if (this.isType(PT_FLOAT)) {
            try {
                double value = Double.parseDouble(this.getText());
                if (this.getParam(1) != null && value < this.getParamDouble(1)) {
                    valid = this.addInvalidReason(I18N.get("ui.ctl.numb.less.err", this.getParamInt(1)));
                }
                if (this.getParam(2) != null && value > this.getParamDouble(2)) {
                    valid = this.addInvalidReason(I18N.get("ui.ctl.numb.more.err", this.getParamInt(2)));
                }
            }
            catch (NumberFormatException e) {
                valid = this.addInvalidReason(I18N.get("ui.ctl.numb.bflt.err", new Object[0]));
            }
        } else {
            valid = false;
        }
        return this.eventFireAndSet(3) & valid;
    }

    private boolean eventFireAndSet(int action) {
        String invalidReason;
        GEVAActionEvent event = new GEVAActionEvent(this, action, this.getText(), -1);
        boolean result = this.fireActionEvent(event);
        if (event.isDirty()) {
            this.setText(event.getActionString());
        }
        if (action == 3 && (invalidReason = event.getInvalidReason()) != null) {
            this.addInvalidReason(invalidReason);
        }
        return result;
    }

    @Override
    public void validate() {
        if (this.valid()) {
            ((JSpinner.DefaultEditor)this.numValue.getEditor()).getTextField().setBackground(Color.white);
        } else {
            ((JSpinner.DefaultEditor)this.numValue.getEditor()).getTextField().setBackground(Color.red);
        }
    }

    @Override
    public String getText() {
        String text = ((JSpinner.DefaultEditor)this.numValue.getEditor()).getTextField().getText();
        DecimalFormatSymbols symbols = ((JSpinner.NumberEditor)this.numValue.getEditor()).getFormat().getDecimalFormatSymbols();
        char groupSep = symbols.getGroupingSeparator();
        char floatSep = symbols.getDecimalSeparator();
        if (text == null || text.length() == 0) {
            text = String.valueOf(this.numValue.getValue());
        }
        return text.replace(String.valueOf(groupSep), "").replace(floatSep, '.');
    }

    @Override
    public void setText(String text) {
        if (this.isType(PT_INT)) {
            this.numValue.setValue(Integer.parseInt(text));
        } else {
            this.numValue.setValue(Double.parseDouble(text));
        }
    }
}

