/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.OptionPane;
import java.awt.Component;

public class GEVAMessage {
    public static final int DEFAULT = 0;
    public static final int OK_OPTION = 1;
    public static final int YES_OPTION = 1;
    public static final int NO_OPTION = 2;
    public static final int CANCEL_OPTION = 4;
    public static final int YES_NO_OPTION = 3;
    public static final int YES_NO_CANCEL_OPTION = 7;
    public static final int OK_CANCEL_OPTION = 5;
    public static final int INFORMATION_TYPE = 16;
    public static final int QUESTION_TYPE = 32;
    public static final int WARNING_TYPE = 48;
    public static final int ERROR_TYPE = 64;

    private GEVAMessage() {
    }

    public static int showMessage(Component owner, String message, String ... params) {
        return GEVAMessage.showMessage(owner, message, 0, params);
    }

    public static int showMessage(Component owner, String message, int flags, String ... params) {
        String brief = "";
        int jOption = -1;
        int jType = -1;
        if (params.length != 0) {
            message = GEVAMessage.applyParams(message, params);
        }
        int briefAtEx = message.indexOf(33);
        int briefAtQu = message.indexOf(63);
        if (briefAtQu != -1 && (briefAtEx != -1 && briefAtEx > briefAtQu || briefAtEx == -1)) {
            briefAtEx = briefAtQu;
        }
        if (briefAtEx != -1) {
            jType = message.charAt(briefAtEx) == '!' ? 2 : 3;
            if (GEVAMessage.getSpaceCount(briefAtEx, message) < 3) {
                brief = message.substring(0, briefAtEx + 1);
                message = message.substring(briefAtEx + 1).trim();
            }
        }
        jOption = GEVAMessage.mapToJOption(flags, jOption);
        jType = GEVAMessage.mapToJType(flags, jType);
        jOption = OptionPane.show(owner, message, brief, jOption, jType);
        return GEVAMessage.mapFromJResult(jOption);
    }

    private static String applyParams(String message, String[] params) {
        for (int i = 0; i < params.length; ++i) {
            message = message.replaceAll("([^\\\\]|^)((\\\\\\\\)*)\\{\\s*0*" + i + "\\s*\\}", "$1$2" + params[i]);
        }
        return message.replaceAll("\\\\\\\\", "\\\\");
    }

    private static int getSpaceCount(int length, String message) {
        int spaceCount = 0;
        for (int index = 0; spaceCount < 3 && index < length; ++index) {
            if (message.charAt(index) == ' ') {
                ++spaceCount;
                continue;
            }
            if (message.charAt(index) >= ' ') continue;
            spaceCount = 3;
        }
        return spaceCount;
    }

    private static int mapToJOption(int flags, int alternative) {
        switch (flags & 0xF) {
            case 3: {
                return 0;
            }
            case 7: {
                return 1;
            }
            case 5: {
                return 2;
            }
        }
        return alternative;
    }

    private static int mapToJType(int flags, int alternative) {
        switch (flags & 0xF0) {
            case 16: {
                return 1;
            }
            case 32: {
                return 3;
            }
            case 48: {
                return 2;
            }
            case 64: {
                return 0;
            }
        }
        return alternative;
    }

    private static int mapFromJResult(int jOption) {
        if (jOption == 0) {
            return 1;
        }
        if (jOption == 1) {
            return 2;
        }
        if (jOption == 2) {
            return 4;
        }
        if (jOption == 0) {
            return 1;
        }
        return 4;
    }
}

