/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.GEVAMessage;
import Util.GEVAHelper;
import Util.GEVAUncaught;
import Util.I18N;
import Util.PathTools;
import java.util.HashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class GEVAJarHunter
implements Runnable {
    static JarNames jarNames = new JarNames();
    static JarFiles jarFiles = new JarFiles();
    static Thread runJarHunter;
    static Semaphore waitForUpdate;

    private GEVAJarHunter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(String name, String paths) {
        JarNames jarNames = GEVAJarHunter.jarNames;
        synchronized (jarNames) {
            if (!GEVAJarHunter.jarNames.containsKey(name)) {
                GEVAJarHunter.jarNames.put(name, paths);
                jarFiles.put(name, null);
            }
        }
    }

    public static void start() {
        if (runJarHunter == null) {
            runJarHunter = new Thread((ThreadGroup)GEVAUncaught.jar, new GEVAJarHunter());
            runJarHunter.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String using = "";
        String paths = null;
        StringBuilder jarBuilder = null;
        while (using != null) {
            using = null;
            waitForUpdate.acquireUninterruptibly();
            HashMap hashMap = jarNames;
            synchronized (hashMap) {
                JarFiles jarFiles = GEVAJarHunter.jarFiles;
                synchronized (jarFiles) {
                    for (String name : jarNames.keySet()) {
                        if (!GEVAJarHunter.jarFiles.containsKey(name) || GEVAJarHunter.jarFiles.get(name) != null) continue;
                        using = name;
                        paths = (String)jarNames.get(name);
                        break;
                    }
                }
            }
            if (using != null) {
                if (paths != null) {
                    String[] jars;
                    for (String jar : jars = PathTools.fileList(paths)) {
                        if (jarBuilder == null) {
                            jarBuilder = new StringBuilder();
                            jarBuilder.append(GEVAHelper.quote(jar));
                            continue;
                        }
                        jarBuilder.append(System.getProperty("path.separator") + GEVAHelper.quote(jar));
                    }
                    if (jarBuilder == null) {
                        jarBuilder = new StringBuilder();
                    }
                    hashMap = jarFiles;
                    synchronized (hashMap) {
                        jarFiles.put(using, jarBuilder.toString());
                    }
                    jarBuilder = null;
                } else {
                    hashMap = jarFiles;
                    synchronized (hashMap) {
                        jarFiles.put(using, "");
                    }
                }
            }
            waitForUpdate.release();
        }
        runJarHunter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String name) {
        String files;
        JarFiles jarFiles = GEVAJarHunter.jarFiles;
        synchronized (jarFiles) {
            if (!GEVAJarHunter.jarFiles.containsKey(name)) {
                return "";
            }
            files = (String)GEVAJarHunter.jarFiles.get(name);
        }
        block12: while (files == null) {
            try {
                if (waitForUpdate.tryAcquire(5L, TimeUnit.SECONDS)) {
                    waitForUpdate.release();
                } else {
                    switch (GEVAMessage.showMessage(GEVAHelper.mainWindow, I18N.get("ui.jar.look.wrn", new Object[0]), 35, new String[0])) {
                        case 1: {
                            continue block12;
                        }
                        case 2: {
                            return null;
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                GEVAMessage.showMessage(GEVAHelper.mainWindow, I18N.get("ui.jar.wait.err", e), new String[0]);
                e.printStackTrace();
                return null;
            }
            jarFiles = GEVAJarHunter.jarFiles;
            synchronized (jarFiles) {
                files = (String)GEVAJarHunter.jarFiles.get(name);
            }
        }
        return files;
    }

    static {
        waitForUpdate = new Semaphore(1, true);
    }

    static class JarFiles
    extends HashMap<String, String> {
        JarFiles() {
        }
    }

    static class JarNames
    extends HashMap<String, String> {
        JarNames() {
        }
    }
}

