/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.GEVAActionEvent;
import UI.GEVADirtyListener;
import UI.GEVAPropertyContainer;
import UI.GEVAPropertyControl;
import Util.FileNameExtensionFilter;
import Util.GEVAHelper;
import Util.I18N;
import Util.PathTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GEVAFileProperty
extends GEVAPropertyControl
implements DocumentListener {
    public static String PT_FILE = "";
    public static String PT_FOLDER = "folder";
    public static String PT_FILE_OR_FOLDER = "any";
    public static String PP_RELATIVE = "";
    public static String PP_ABSOLUTE = "absolute";
    public static String PP_MUST_EXIST = "";
    public static String PP_IGNORE_EXIST = "ignorexist";
    private JPanel guiPane = new JPanel();
    private JTextField txtValue;
    private JButton cmdBrowse;
    private String workingPath;
    private boolean absolute;
    private boolean mustExist;
    private Filters filters;
    private boolean allFiles;
    private int pick;

    public GEVAFileProperty(GEVADirtyListener dirtyListener, GEVAPropertyContainer parent, String type, String title, String name, String comment, String initial, String params) {
        super(dirtyListener, parent, type, title, name, comment, initial, params);
        this.guiPane.setLayout(new BorderLayout());
        this.txtValue = new JTextField();
        this.txtValue.getDocument().addDocumentListener(this);
        this.txtValue.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                GEVAFileProperty.this.txtValue_onUpdate();
            }
        });
        this.cmdBrowse = new JButton(I18N.get("ui.more", new Object[0]));
        this.cmdBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GEVAFileProperty.this.cmdBrowse_onClick();
            }
        });
        this.guiPane.add((Component)this.txtValue, "Center");
        this.guiPane.add((Component)this.cmdBrowse, "East");
        this.pick = this.isType(PT_FOLDER) ? 1 : (this.isType(PT_FILE_OR_FOLDER) ? 2 : 0);
        this.workingPath = super.getParam(0);
        this.absolute = super.getParamEqual(1, PP_ABSOLUTE);
        this.mustExist = !super.getParamEqual(2, PP_IGNORE_EXIST);
        this.parseExtensions(super.getParam(3));
        parent.add(this);
        this.dirtyListener.setDirtyable(false);
        this.setText(initial);
        this.validate();
        this.dirtyListener.setDirtyable(true);
    }

    private void parseExtensions(String filterList) {
        String[] extensions = null;
        if (filterList == null) {
            this.allFiles = true;
            return;
        }
        String[] parseFilters = filterList.split("\\|");
        if (parseFilters.length == 0) {
            this.allFiles = true;
            return;
        }
        this.filters = new Filters(parseFilters.length / 2);
        for (int i = 0; i < parseFilters.length; i += 2) {
            if (i + 1 < parseFilters.length) {
                extensions = GEVAHelper.prune(parseFilters[i + 1].split(";"));
                if (extensions.length == 0) {
                    extensions = null;
                }
            } else {
                extensions = null;
            }
            if (extensions != null) {
                this.filters.add(new FileNameExtensionFilter(parseFilters[i], extensions));
                continue;
            }
            this.allFiles = true;
        }
    }

    @Override
    public String getText() {
        if (!this.mustExist && this.txtValue.getText().trim().length() == 0) {
            return "";
        }
        if (this.absolute) {
            return PathTools.getAbsolutePath(this.txtValue.getText(), this.workingPath);
        }
        return PathTools.getRelativePath(this.txtValue.getText(), this.workingPath);
    }

    public String getAbsoluteText() {
        return PathTools.getAbsolutePath(this.txtValue.getText(), this.workingPath);
    }

    @Override
    public void setText(String text) {
        if (!this.mustExist && text.trim().length() == 0) {
            this.txtValue.setText("");
        } else if (this.absolute || !new File(PathTools.getAbsolutePath(text, this.workingPath)).exists()) {
            this.txtValue.setText(PathTools.getAbsolutePath(text, this.workingPath));
        } else {
            this.txtValue.setText(PathTools.getRelativePath(text, this.workingPath));
        }
    }

    @Override
    public boolean load(Properties properties) {
        if (this.name == null) {
            return true;
        }
        String value = properties.getProperty(this.name, this.initial);
        GEVAActionEvent event = new GEVAActionEvent(this, 0, value, -1);
        if (!this.fireActionEvent(event)) {
            value = this.initial;
        } else if (event.isDirty()) {
            value = event.getActionString();
        }
        this.setText(value);
        return this.valid() || !this.txtValue.isVisible();
    }

    @Override
    public boolean save(Properties properties) {
        if (this.name == null) {
            return true;
        }
        String value = this.getText();
        GEVAActionEvent event = new GEVAActionEvent(this, 1, value, -1);
        boolean write = this.fireActionEvent(event);
        if (event.isDirty()) {
            value = event.getActionString();
        }
        if (write) {
            properties.setProperty(this.name, value);
        }
        return this.valid() || !this.txtValue.isVisible();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.txtValue.setEnabled(enabled);
        this.cmdBrowse.setEnabled(enabled);
    }

    @Override
    public Component getComponent(int index) {
        if (index == 1) {
            return this.guiPane;
        }
        return super.getComponent(index);
    }

    public boolean valid() {
        boolean valid = true;
        File file = null;
        this.resetInvalidReason();
        if (!this.mustExist && this.getText().length() == 0) {
            return true;
        }
        if (this.mustExist || this.pick == 0 || this.pick == 1) {
            file = new File(this.getAbsoluteText());
        }
        if (this.mustExist && !file.exists()) {
            valid = this.addInvalidReason(I18N.get("ui.ctl.file.path.err", new Object[0]));
        } else if (this.pick == 0 && !file.isFile() && (this.mustExist || file.exists())) {
            valid = this.addInvalidReason(I18N.get("ui.ctl.file.file.err", new Object[0]));
        } else if (this.pick == 1 && !file.isDirectory() && (this.mustExist || file.exists())) {
            valid = this.addInvalidReason(I18N.get("ui.ctl.file.fold.err", new Object[0]));
        }
        return this.eventFireAndSet(3) & valid;
    }

    @Override
    public void validate() {
        if (this.valid()) {
            this.txtValue.setBackground(Color.white);
        } else {
            this.txtValue.setBackground(Color.red);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.dirtyListener.canDirty() && this.eventFireAndSet(2)) {
            this.dirtyListener.setDirty();
        }
        this.validate();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.dirtyListener.canDirty() && this.eventFireAndSet(2)) {
            this.dirtyListener.setDirty();
        }
        this.validate();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.dirtyListener.canDirty() && this.eventFireAndSet(2)) {
            this.dirtyListener.setDirty();
        }
        this.validate();
    }

    private boolean eventFireAndSet(int action) {
        String invalidReason;
        GEVAActionEvent event = new GEVAActionEvent(this, action, this.getText(), -1);
        boolean result = this.fireActionEvent(event);
        if (event.isDirty()) {
            this.setText(event.getActionString());
        }
        if (action == 3 && (invalidReason = event.getInvalidReason()) != null) {
            this.addInvalidReason(invalidReason);
        }
        return result;
    }

    public void setWorkingPath(String workingPath) {
        String absolutePath = this.getAbsoluteText();
        this.workingPath = workingPath;
        this.setText(absolutePath);
        this.validate();
    }

    public String getWorkingPath() {
        return this.workingPath;
    }

    private void txtValue_onUpdate() {
        this.dirtyListener.setDirtyable(false);
        this.setText(this.getText());
        this.validate();
        this.dirtyListener.setDirtyable(true);
    }

    private void cmdBrowse_onClick() {
        JFileChooser fileBrowser = new JFileChooser();
        fileBrowser.setAcceptAllFileFilterUsed(this.allFiles);
        fileBrowser.setCurrentDirectory(new File(this.getAbsoluteText()));
        fileBrowser.setFileSelectionMode(this.pick);
        if (this.filters != null) {
            for (FileNameExtensionFilter filter : this.filters) {
                fileBrowser.addChoosableFileFilter(filter);
            }
        }
        if (fileBrowser.showOpenDialog(this.guiPane) == 0) {
            this.setText(fileBrowser.getSelectedFile().getAbsolutePath());
        }
    }

    private static class Filters
    extends ArrayList<FileNameExtensionFilter> {
        public Filters(int size) {
            super(size);
        }
    }
}

