/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.GEVAActionEvent;
import UI.GEVAActionListener;
import UI.GEVAContainerControl;
import UI.GEVADirtyListener;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Properties;

public abstract class GEVAControl {
    protected GEVADirtyListener dirtyListener;
    protected GEVAContainerControl parent;
    protected String type;
    protected String title;
    protected String name;
    protected String comment;
    private Listeners listeners = new Listeners();

    GEVAControl(GEVADirtyListener dirtyListener, GEVAContainerControl parent, String type, String title, String name, String comment) {
        this.dirtyListener = dirtyListener;
        this.parent = parent;
        this.type = type;
        this.title = title;
        this.name = name;
        this.comment = comment;
    }

    public GEVAContainerControl getParent() {
        return this.parent;
    }

    public String getType() {
        return this.type;
    }

    public boolean isType(String type) {
        return this.type.equalsIgnoreCase(type);
    }

    public String getTitle() {
        return this.title;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public abstract void setEnabled(boolean var1);

    public abstract boolean load(Properties var1);

    public abstract boolean save(Properties var1);

    public Component getComponent() {
        return this.getComponent(0);
    }

    public abstract Component getComponent(int var1);

    public abstract int countComponents();

    public void addActionListener(GEVAActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(GEVAActionListener listener) {
        this.listeners.remove(listener);
    }

    protected boolean fireActionEvent(GEVAActionEvent event) {
        boolean result = true;
        for (GEVAActionListener listener : this.listeners) {
            result &= listener.actionPerformed(event);
        }
        return result;
    }

    protected abstract void setVisibleControlGroup(String var1, boolean var2);

    public abstract void setVisible(boolean var1);

    public abstract String getText();

    public abstract void setText(String var1);

    public abstract void validate();

    private static class Listeners
    extends ArrayList<GEVAActionListener> {
        private Listeners() {
        }
    }
}

