/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.GEVAActionEvent;
import UI.GEVAActionListener;
import UI.GEVABookContainer;
import UI.GEVAConfig;
import UI.GEVADirtyListener;
import UI.GEVAFileProperty;
import UI.GEVAMessage;
import UI.GEVAPageContainer;
import UI.GEVAPropertyRowContainer;
import UI.GEVASpringContainer;
import UI.GEVAStringProperty;
import Util.GEVAHelper;
import Util.I18N;
import Util.PathTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class GEVAConfigGUI
extends JDialog
implements GEVADirtyListener,
WindowListener,
MouseListener,
GEVAActionListener {
    private static final int SCF_PROMPT = 0;
    private static final int SCF_MARK = 1;
    private static final int NRF_LOCK = -1;
    private static final int NRF_NO = 0;
    private static final int NRF_WARN = 1;
    private static final int NRF_YES = 2;
    private static final int NRF_FORCE = 3;
    private GEVABookContainer guiProperties;
    private JButton cmdReset = new JButton(I18N.get("ui.cfg.ctrl.rset", new Object[0]));
    private JButton cmdOk = new JButton(I18N.get("ui.ctrl.okay", new Object[0]));
    private JButton cmdApply = new JButton(I18N.get("ui.ctrl.aply", new Object[0]));
    private JButton cmdCancel = new JButton(I18N.get("ui.ctrl.exit", new Object[0]));
    private GEVAFileProperty guiPropertiesPath;
    private GEVAFileProperty guiGrammarPath;
    private GEVAFileProperty guiConfigPath;
    private GEVAFileProperty guiClassPath;
    private GEVAFileProperty guiWorkingAbsPath;
    private boolean isDirty = false;
    private boolean canDirty = true;
    private int needRestart = 0;

    public GEVAConfigGUI(Dialog owner) {
        super(owner, I18N.get("ui.cfg", new Object[0]));
        this.init();
    }

    public GEVAConfigGUI(Frame owner) {
        super(owner, I18N.get("ui.cfg", new Object[0]));
        this.init();
    }

    private void init() {
        super.setModal(true);
        super.setBounds(super.getOwner().getX() + super.getOwner().getWidth() / 2 - 200, super.getOwner().getY() + super.getOwner().getHeight() / 2 - 250, 400, 500);
        super.getContentPane().setLayout(new BorderLayout());
        super.setDefaultCloseOperation(0);
        super.addWindowListener(this);
        this.cmdReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GEVAConfigGUI.this.cmdReset_onClick();
            }
        });
        this.cmdOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GEVAConfigGUI.this.cmdOk_onClick();
            }
        });
        this.cmdApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GEVAConfigGUI.this.cmdApply_onClick();
            }
        });
        this.cmdApply.addMouseListener(this);
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GEVAConfigGUI.this.cmdCancel_onClick();
            }
        });
        this.cmdOk.setEnabled(false);
        this.cmdApply.setEnabled(false);
        JPanel guiCommand = new JPanel();
        JPanel guiSeparator = new JPanel();
        guiCommand.setLayout(new GridBagLayout());
        guiCommand.add(this.cmdReset);
        guiCommand.add(this.cmdOk);
        guiCommand.add(this.cmdApply);
        guiCommand.add(this.cmdCancel);
        GEVAHelper.gridAdd(guiCommand, this.cmdReset, 0, 0, 0.0);
        GEVAHelper.gridAdd(guiCommand, guiSeparator, 1, 0, 1.0);
        GEVAHelper.gridAdd(guiCommand, this.cmdOk, 2, 0, 0.0);
        GEVAHelper.gridAdd(guiCommand, this.cmdApply, 3, 0, 0.0);
        GEVAHelper.gridAdd(guiCommand, this.cmdCancel, 4, 0, 0.0);
        this.initialiseProperties();
        super.add(this.guiProperties.getComponent(), "Center");
        super.add((Component)guiCommand, "South");
        super.setVisible(true);
    }

    private void initialiseProperties() {
        this.guiProperties = new GEVABookContainer(this, I18N.get("ui.cfg.tip", new Object[0]));
        GEVAPageContainer guiPageGeva = new GEVAPageContainer(this, this.guiProperties, I18N.get("ui.cfg.geva", new Object[0]), I18N.get("ui.cfg.geva.tip", new Object[0]));
        GEVAPropertyRowContainer container = new GEVAPropertyRowContainer(this, guiPageGeva, I18N.get("ui.cfg.geva.path", new Object[0]), I18N.get("ui.cfg.geva.path.tip", new Object[0]));
        this.guiPropertiesPath = new GEVAFileProperty(this, container, GEVAFileProperty.PT_FOLDER, I18N.get("ui.cfg.geva.path.prop", new Object[0]), "propertiesPath", I18N.get("ui.cfg.geva.path.prop.tip", new Object[0]), GEVAConfig.getPropertiesRelPath(), GEVAConfig.getWorkingAbsPath());
        this.guiPropertiesPath.addActionListener(this);
        this.guiGrammarPath = new GEVAFileProperty(this, container, GEVAFileProperty.PT_FOLDER, I18N.get("ui.cfg.geva.path.gram", new Object[0]), "grammarPath", I18N.get("ui.cfg.geva.path.gram.tip", new Object[0]), GEVAConfig.getGrammarRelPath(), GEVAConfig.getWorkingAbsPath());
        this.guiGrammarPath.addActionListener(this);
        container = new GEVAPropertyRowContainer(this, guiPageGeva, I18N.get("ui.cfg.geva.uipa", new Object[0]), I18N.get("ui.cfg.geva.uipa.tip", new Object[0]));
        this.guiConfigPath = new GEVAFileProperty(this, container, GEVAFileProperty.PT_FOLDER, I18N.get("ui.cfg.geva.uipa.conf", new Object[0]), "configPath", I18N.get("ui.cfg.geva.uipa.conf.tip", new Object[0]), GEVAConfig.getConfigRelPath(), PathTools.getAbsolutePath("."));
        this.guiConfigPath.addActionListener(this);
        container = new GEVAPropertyRowContainer(this, guiPageGeva, I18N.get("ui.cfg.advn", new Object[0]), I18N.get("ui.cfg.advn.tip", new Object[0]));
        new GEVAStringProperty(this, container, GEVAStringProperty.PT_READWRITE, I18N.get("ui.cfg.advn.main", new Object[0]), "className", I18N.get("ui.cfg.advn.main.tip", new Object[0]), GEVAConfig.getClassName(), GEVAStringProperty.PP_ACCEPT_ALL);
        this.guiClassPath = new GEVAFileProperty(this, container, GEVAFileProperty.PT_FILE_OR_FOLDER, I18N.get("ui.cfg.advn.clpa", new Object[0]), "classPath", I18N.get("ui.cfg.advn.clpa.tip", new Object[0]), GEVAConfig.getClassRelPath(), GEVAConfig.getWorkingAbsPath() + ",,,All Files||JAR files|jar");
        this.guiWorkingAbsPath = new GEVAFileProperty(this, container, GEVAFileProperty.PT_FOLDER, I18N.get("ui.cfg.advn.wkpa", new Object[0]), "workingAbsPath", I18N.get("ui.cfg.advn.wkpa.tip", new Object[0]), GEVAConfig.getWorkingAbsPath(), "," + GEVAFileProperty.PP_ABSOLUTE);
        this.guiWorkingAbsPath.addActionListener(this);
        new GEVAStringProperty(this, container, GEVAStringProperty.PT_READWRITE, I18N.get("ui.cfg.advn.java", new Object[0]), "javaName", I18N.get("ui.cfg.advn.java.tip", new Object[0]), GEVAConfig.getJavaName(), GEVAStringProperty.PP_ACCEPT_ALL);
        new GEVASpringContainer(this, guiPageGeva);
    }

    @Override
    public void setDirty() {
        if (!this.canDirty) {
            return;
        }
        this.cmdOk.setEnabled(true);
        this.cmdApply.setEnabled(true);
        this.cmdCancel.setText(I18N.get("ui.ctrl.canl", new Object[0]));
        this.isDirty = true;
        this.setTitle(I18N.get("ui.cfg", new Object[0]) + " *");
    }

    @Override
    public void setDirtyable(boolean dirtyable) {
        this.canDirty = dirtyable;
    }

    @Override
    public boolean canDirty() {
        return this.canDirty;
    }

    public boolean setClean() {
        return this.setClean(0);
    }

    public boolean setClean(int flag) {
        if (!this.isDirty) {
            return true;
        }
        if (flag == 0) {
            switch (GEVAMessage.showMessage((Component)this, I18N.get("ui.cfg.lodi.wrn", new Object[0]), 55, new String[0])) {
                case 1: {
                    return this.saveConfigFile();
                }
                case 2: {
                    return true;
                }
                case 4: {
                    return false;
                }
            }
        } else if (flag == 1) {
            this.cmdOk.setEnabled(false);
            this.cmdApply.setEnabled(false);
            this.cmdCancel.setText(I18N.get("ui.ctrl.exit", new Object[0]));
            this.isDirty = false;
            this.setTitle(I18N.get("ui.cfg", new Object[0]));
            return true;
        }
        GEVAMessage.showMessage((Component)this, I18N.get("ui.unkn.bug", new Object[0]), 64, new String[0]);
        return false;
    }

    private void cmdReset_onClick() {
        this.needRestart = 3;
        this.close();
    }

    private void cmdOk_onClick() {
        if (this.saveConfigFile()) {
            this.close();
        }
    }

    private void cmdApply_onClick() {
        this.saveConfigFile();
    }

    private void cmdCancel_onClick() {
        this.close();
    }

    private boolean saveConfigFile() {
        try {
            if (!this.guiProperties.save(GEVAConfig.getProperties()) && GEVAMessage.showMessage((Component)this, I18N.get("ui.cfg.prsa.wrn", new Object[0]), 51, new String[0]) == 2) {
                return false;
            }
            GEVAConfig.save();
            if (this.needRestart == 1) {
                this.needRestart = 2;
            }
            this.setClean(1);
            return true;
        }
        catch (IOException e) {
            GEVAMessage.showMessage((Component)this, I18N.get("ui.cfg.cosa.err", e), 64, new String[0]);
            e.printStackTrace();
            return false;
        }
    }

    private void close() {
        this.windowClosing(null);
    }

    @Override
    public boolean actionPerformed(GEVAActionEvent e) {
        switch (e.getAction()) {
            case 3: {
                if (e.getSource() != this.guiWorkingAbsPath) break;
                if (this.needRestart == 0) {
                    this.needRestart = -1;
                }
                this.guiPropertiesPath.setWorkingPath(e.getActionString());
                this.guiGrammarPath.setWorkingPath(e.getActionString());
                this.guiClassPath.setWorkingPath(e.getActionString());
                if (this.needRestart == -1) {
                    this.needRestart = 0;
                }
                return true;
            }
            case 2: {
                if (this.needRestart != 0 || e.getSource() != this.guiPropertiesPath && e.getSource() != this.guiGrammarPath && e.getSource() != this.guiConfigPath) break;
                this.needRestart = 1;
                return true;
            }
        }
        return true;
    }

    public boolean needReset() {
        return this.needRestart == 2 || this.needRestart == 3;
    }

    public boolean forceReset() {
        return this.needRestart == 3;
    }

    @Override
    public void windowClosing(WindowEvent event) {
        if (this.setClean()) {
            this.dispose();
        }
    }

    @Override
    public void windowActivated(WindowEvent event) {
    }

    @Override
    public void windowClosed(WindowEvent event) {
    }

    @Override
    public void windowDeactivated(WindowEvent event) {
    }

    @Override
    public void windowDeiconified(WindowEvent event) {
    }

    @Override
    public void windowIconified(WindowEvent event) {
    }

    @Override
    public void windowOpened(WindowEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.isDirty) {
            this.cmdApply.setEnabled(true);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.isDirty) {
            this.cmdApply.setEnabled(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

