/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.GEVAMessage;
import Util.Constants;
import Util.GEVAHelper;
import Util.I18N;
import Util.PathTools;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class GEVAConfig {
    private static Properties properties = new Properties();
    private static Properties commands = new Properties();
    private static boolean properto = false;
    private static boolean commando = false;

    private GEVAConfig() {
    }

    private static String get(String name) {
        String value = commands.getProperty(name);
        if (value == null) {
            value = properties.getProperty(name);
        }
        return value;
    }

    private static void set(String name, String value) {
        if (!commando) {
            properties.setProperty(name, value);
        }
        if (!properto) {
            commands.setProperty(name, value);
        }
    }

    public static String getSelectedPropertiesFile() {
        return GEVAConfig.get("selectedPropertiesFile");
    }

    public static void setSelectedPropertiesFile(String selectedPropertiesFile) {
        GEVAConfig.set("selectedPropertiesFile", selectedPropertiesFile);
    }

    private static String getConfigPath() {
        return GEVAConfig.get("configPath");
    }

    public static String getConfigRelPath() {
        return PathTools.getSafePath(PathTools.getRelativePath(GEVAConfig.getConfigPath(), PathTools.getAbsolutePath(".")));
    }

    public static String getConfigAbsPath() {
        return PathTools.getSafePath(PathTools.getAbsolutePath(GEVAConfig.getConfigPath(), PathTools.getAbsolutePath(".")));
    }

    public static void setConfigPath(String configPath) {
        GEVAConfig.set("configPath", configPath);
    }

    public static String getHeapSize() {
        String ret = null;
        String tmpHeapSize = GEVAConfig.get("heapSize");
        if (tmpHeapSize != null && tmpHeapSize.matches("^\\d+[mk]?$")) {
            ret = tmpHeapSize;
        }
        return ret;
    }

    public static void setHeapSize(String heapSize) {
        GEVAConfig.set("heapSize", heapSize);
    }

    public static boolean isServer() {
        return GEVAConfig.get("server") != null;
    }

    public static void setServer() {
        GEVAConfig.set("server", "server");
    }

    private static String getPropertiesPath() {
        return GEVAConfig.get("propertiesPath");
    }

    public static String getPropertiesRelPath() {
        return PathTools.getSafePath(PathTools.getRelativePath(GEVAConfig.getPropertiesPath(), GEVAConfig.getWorkingAbsPath()));
    }

    public static String getPropertiesAbsPath() {
        return PathTools.getSafePath(PathTools.getAbsolutePath(GEVAConfig.getPropertiesPath(), GEVAConfig.getWorkingAbsPath()));
    }

    public static void setPropertiesPath(String configPath) {
        GEVAConfig.set("propertiesPath", configPath);
    }

    private static String getGrammarPath() {
        return GEVAConfig.get("grammarPath");
    }

    public static String getGrammarRelPath() {
        return PathTools.getSafePath(PathTools.getRelativePath(GEVAConfig.getGrammarPath(), GEVAConfig.getWorkingAbsPath()));
    }

    public static String getGrammarAbsPath() {
        return PathTools.getSafePath(PathTools.getAbsolutePath(GEVAConfig.getGrammarPath(), GEVAConfig.getWorkingAbsPath()));
    }

    public static void setGrammarPath(String grammarPath) {
        GEVAConfig.set("grammarPath", grammarPath);
    }

    public static String getJavaName() {
        return GEVAConfig.get("javaName");
    }

    public static void setJavaName(String javaName) {
        GEVAConfig.set("javaName", javaName);
    }

    public static String getClassRelPath() {
        return GEVAConfig.get("classPath");
    }

    public static void setClassPath(String classPath) {
        GEVAConfig.set("classPath", PathTools.getRelativePath(classPath, GEVAConfig.getWorkingAbsPath()));
    }

    public static String getClassName() {
        return GEVAConfig.get("className");
    }

    public static void setClassName(String className) {
        GEVAConfig.set("className", className);
    }

    public static String getWorkingAbsPath() {
        return PathTools.getSafePath(GEVAConfig.get("workingAbsPath"));
    }

    public static void setWorkingPath(String workingAbsPath) {
        GEVAConfig.set("workingAbsPath", PathTools.getAbsolutePath(workingAbsPath));
    }

    public static boolean isExpert() {
        String expert = GEVAConfig.get("expert");
        if (expert == null) {
            return false;
        }
        return expert.equalsIgnoreCase("true");
    }

    public static void setExpert(boolean expert) {
        GEVAConfig.set("expert", expert ? "true" : "false");
    }

    public static boolean initialise(String[] args) {
        properto = true;
        GEVAConfig.setSelectedPropertiesFile("HelloWorld.properties");
        GEVAConfig.setConfigPath("./param/");
        GEVAConfig.setPropertiesPath("./param/Parameters/");
        GEVAConfig.setGrammarPath("./param/Grammar/");
        GEVAConfig.setJavaName("java");
        GEVAConfig.setClassPath("GEVA.jar");
        GEVAConfig.setClassName("Main.Run");
        GEVAConfig.setWorkingPath(".");
        properto = false;
        GEVAConfig.load();
        return GEVAConfig.parseCommandLine(args);
    }

    public static Properties getProperties() {
        return properties;
    }

    public static Properties getCommands() {
        return commands;
    }

    public static void save() throws IOException {
        FileOutputStream stream = new FileOutputStream("./gui.config");
        properties.store(stream, null);
        stream.close();
    }

    public static void saveQuiet() {
        try {
            GEVAConfig.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean load() {
        try {
            FileInputStream stream = new FileInputStream("./gui.config");
            properties.load(stream);
            stream.close();
        }
        catch (IOException e) {
            GEVAMessage.showMessage(GEVAHelper.mainWindow, I18N.get("ui.cfg.colo.err", e), 64, new String[0]);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static boolean parseCommandLine(String[] args) {
        boolean help = false;
        int flag = 0;
        boolean wait = false;
        commando = true;
        for (String arg : args) {
            if (flag == 0) {
                flag = GEVAConfig.parseFlag(arg);
                wait = true;
            } else {
                wait = false;
            }
            if (flag < 0) {
                switch (flag) {
                    case -1: {
                        help = true;
                        break;
                    }
                    case -2: {
                        GEVAConfig.setExpert(true);
                        break;
                    }
                    case -3: {
                        GEVAConfig.setServer();
                        break;
                    }
                    default: {
                        help = true;
                        break;
                    }
                }
            } else if (flag > 0 && !wait) {
                switch (flag) {
                    case 1: {
                        GEVAConfig.setConfigPath(arg);
                        break;
                    }
                    case 2: {
                        GEVAConfig.setPropertiesPath(arg);
                        break;
                    }
                    case 3: {
                        GEVAConfig.setGrammarPath(arg);
                        break;
                    }
                    case 4: {
                        GEVAConfig.setJavaName(arg);
                        break;
                    }
                    case 5: {
                        GEVAConfig.setClassPath(arg);
                        break;
                    }
                    case 6: {
                        GEVAConfig.setClassName(arg);
                        break;
                    }
                    case 7: {
                        GEVAConfig.setWorkingPath(arg);
                        break;
                    }
                    case 8: {
                        GEVAConfig.setHeapSize(arg);
                        break;
                    }
                    default: {
                        help = true;
                    }
                }
            }
            if (flag >= 0 && (flag <= 0 || wait)) continue;
            flag = 0;
        }
        if (flag != 0) {
            help = true;
        }
        commando = false;
        if (help) {
            GEVAConfig.displayHelp();
            return false;
        }
        return true;
    }

    private static int parseFlag(String arg) {
        int index = 0;
        for (String[] flag : Constants.cmdFlags) {
            for (index = 1; index < flag.length - 1; ++index) {
                if (flag[index].compareToIgnoreCase(arg) != 0) continue;
                return Integer.parseInt(flag[0]);
            }
        }
        return 0;
    }

    private static void displayHelp() {
        int index = 0;
        System.out.println(I18N.get("ui.gui.args.u", new Object[0]));
        System.out.println();
        System.out.println("  " + I18N.get("ui.gui.args.f", new Object[0]));
        System.out.println();
        for (String[] flag : Constants.cmdFlags) {
            for (index = 1; index < flag.length - 1; ++index) {
                if (index == 1) {
                    System.out.print("  ");
                } else {
                    System.out.print(" ");
                }
                System.out.print(flag[index]);
            }
            System.out.println();
            System.out.print("    ");
            System.out.println(flag[flag.length - 1]);
        }
    }
}

