/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.GEVAActionEvent;
import UI.GEVADirtyListener;
import UI.GEVAPropertyContainer;
import UI.GEVAPropertyControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JComboBox;

public class GEVAChoiceProperty
extends GEVAPropertyControl
implements ActionListener {
    public static final String PT_BOOL = "bool";
    public static final String PT_GROUP = "group";
    public static final String PT_ENUM = "";
    private static final String[] boolValues = new String[]{"true", "false"};
    private static final int BV_TRUE = 0;
    private static final int BV_FALSE = 1;
    private JComboBox cboValue = new JComboBox();
    private ControlGroups controlGroups;

    public GEVAChoiceProperty(GEVADirtyListener dirtyListener, GEVAPropertyContainer parent, String type, String title, String name, String comment, String initial, String params) {
        super(dirtyListener, parent, type, title, name, comment, initial, params);
        if (this.isType(PT_BOOL)) {
            int i;
            for (i = 0; i < this.params.length && i < 2; ++i) {
                if (this.params[i].trim().length() == 0) {
                    this.cboValue.addItem(boolValues[i]);
                    continue;
                }
                this.cboValue.addItem(this.params[i]);
            }
            while (i < 2) {
                this.cboValue.addItem(boolValues[i]);
                ++i;
            }
        } else if (this.isType(PT_GROUP)) {
            this.controlGroups = new ControlGroups();
            for (int i = 0; i < this.params.length; ++i) {
                if (i % 2 == 0) {
                    this.cboValue.addItem(this.params[i]);
                    continue;
                }
                this.controlGroups.add(this.params[i]);
            }
        } else if (this.params != null) {
            for (int i = 0; i < this.params.length; ++i) {
                this.cboValue.addItem(this.params[i]);
            }
        }
        this.cboValue.setSelectedItem(initial);
        this.cboValue.addActionListener(this);
        this.cboValue.setBackground(Color.white);
        parent.add(this);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.cboValue.setEnabled(enabled);
    }

    @Override
    public boolean load(Properties properties) {
        String value = properties.getProperty(this.name, this.initial);
        GEVAActionEvent event = new GEVAActionEvent(this, 0, value, -1);
        if (!this.fireActionEvent(event)) {
            value = this.initial;
        } else if (event.isDirty()) {
            value = event.getActionString();
        }
        if (this.isType(PT_BOOL)) {
            if (value.equalsIgnoreCase(boolValues[0])) {
                this.cboValue.setSelectedIndex(0);
            } else if (value.equalsIgnoreCase(boolValues[1])) {
                this.cboValue.setSelectedIndex(1);
            } else {
                this.cboValue.setSelectedItem(value);
            }
        } else {
            this.cboValue.setSelectedItem(value);
        }
        return this.valid();
    }

    @Override
    public boolean save(Properties properties) {
        String value = this.isType(PT_BOOL) ? (this.cboValue.getSelectedIndex() == 0 ? boolValues[0] : boolValues[1]) : String.valueOf(this.cboValue.getSelectedItem());
        GEVAActionEvent event = new GEVAActionEvent(this, 1, value, this.cboValue.getSelectedIndex());
        boolean write = this.fireActionEvent(event);
        if (event.isDirty()) {
            value = event.getActionString();
        }
        if (write) {
            properties.setProperty(this.name, value);
        }
        return this.valid();
    }

    @Override
    public Component getComponent(int index) {
        if (index == 1) {
            return this.cboValue;
        }
        return super.getComponent(index);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int visibleIndex = -1;
        if (this.isType(PT_GROUP)) {
            for (int groupIndex = 0; groupIndex < this.controlGroups.size(); ++groupIndex) {
                if (this.cboValue.getSelectedIndex() == groupIndex) {
                    visibleIndex = groupIndex;
                    continue;
                }
                this.parent.setVisibleControlGroup((String)this.controlGroups.get(groupIndex), false);
            }
            if (visibleIndex != -1) {
                this.parent.setVisibleControlGroup((String)this.controlGroups.get(visibleIndex), true);
            }
        }
        if (this.eventFireAndSet(2)) {
            this.dirtyListener.setDirty();
        }
        this.validate();
    }

    public boolean valid() {
        this.resetInvalidReason();
        return this.eventFireAndSet(3) & true;
    }

    private boolean eventFireAndSet(int action) {
        String invalidReason;
        GEVAActionEvent event = new GEVAActionEvent(this, action, String.valueOf(this.cboValue.getSelectedItem()), this.cboValue.getSelectedIndex());
        boolean result = this.fireActionEvent(event);
        if (event.isDirty()) {
            this.cboValue.setSelectedItem(event.getActionString());
        }
        if (action == 3 && (invalidReason = event.getInvalidReason()) != null) {
            this.addInvalidReason(invalidReason);
        }
        return result;
    }

    @Override
    public void validate() {
        if (this.valid()) {
            this.cboValue.setBackground(Color.white);
        } else {
            this.cboValue.setBackground(Color.red);
        }
    }

    @Override
    public String getText() {
        return String.valueOf(this.cboValue.getSelectedItem());
    }

    @Override
    public void setText(String text) {
        this.cboValue.setSelectedItem(text);
    }

    private static class ControlGroups
    extends ArrayList<String> {
        private ControlGroups() {
        }
    }
}

