/*
 * Decompiled with CFR 0.152.
 */
package UI;

import UI.GEVAContainerControl;
import UI.GEVAControl;
import UI.GEVAControlGroup;
import UI.GEVADirtyListener;
import java.awt.Component;
import java.util.Hashtable;
import javax.swing.JTabbedPane;

public class GEVABookContainer
extends GEVAContainerControl {
    private JTabbedPane guiBook;
    private ControlGroups controlGroups = new ControlGroups();

    public GEVABookContainer(GEVADirtyListener dirtyListener, String comment) {
        super(dirtyListener, null, "book", null, comment);
        this.guiBook = new JTabbedPane();
    }

    public void setPage(String title) {
        int i = 0;
        for (GEVAControl control : this.controls) {
            if (control.getTitle().equalsIgnoreCase(title)) {
                this.guiBook.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }

    @Override
    public void add(GEVAControl page) {
        super.add(page);
        this.guiBook.addTab(page.getTitle(), page.getComponent());
    }

    @Override
    public Component getComponent(int index) {
        return this.guiBook;
    }

    @Override
    public int countComponents() {
        return 1;
    }

    public void addControlGroup(String name, GEVAControlGroup controlGroup) {
        this.controlGroups.put(name, controlGroup);
    }

    @Override
    public void setVisibleControlGroup(String name, boolean show) {
        GEVAControlGroup controlGroup = (GEVAControlGroup)this.controlGroups.get(name);
        if (name != null && name.length() != 0) {
            if (controlGroup != null) {
                if (controlGroup.isHiding()) {
                    show = !show;
                }
                for (GEVAControl control : controlGroup) {
                    control.setVisible(show);
                }
            } else assert (false) : "Group " + name + " does not exist";
        }
    }

    @Override
    public void setVisible(boolean show) {
        this.guiBook.setVisible(show);
    }

    @Override
    public String getText() {
        return this.guiBook.getTitleAt(this.guiBook.getSelectedIndex());
    }

    @Override
    public void setText(String text) {
        this.setPage(text);
    }

    private static class ControlGroups
    extends Hashtable<String, GEVAControlGroup> {
        private ControlGroups() {
        }
    }
}

