/*
 * Decompiled with CFR 0.152.
 */
package Fractal;

import Fractal.FractalDimension;
import Fractal.LSystem2Renderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;

public class LSystem2FDBoxCounting
extends LSystem2Renderer
implements FractalDimension {
    private BufferedImage image;

    public LSystem2FDBoxCounting(String axiom, String grammar, int depth, float angle, int size) {
        super(axiom, grammar, depth, angle);
        this.setBoxSize(size);
    }

    public void setBoxSize(int size) {
        if (size <= 1) {
            throw new IllegalArgumentException(">1");
        }
        this.image = new BufferedImage(size, size, 10);
    }

    @Override
    public double calcFractalDimension() {
        byte[] pixels;
        assert (this.image != null) : "setBoxSize must have failed!";
        int size = this.image.getWidth();
        int count = 0;
        Graphics graphics = this.image.getGraphics();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, size, size);
        super.setDimension(size, size);
        super.render((Object)null);
        for (byte pixel : pixels = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData()) {
            if (pixel == 0) continue;
            ++count;
        }
        return Math.log(count) / Math.log(size);
    }

    @Override
    protected void drawLine(Object user, int x, int y, int u, int v) {
        Graphics graphics = this.image.getGraphics();
        graphics.setColor(Color.white);
        graphics.drawLine(x, y, u, v);
    }
}

