/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.statistics;

import JSci.maths.statistics.OutOfRangeException;
import JSci.maths.statistics.ProbabilityDistribution;

public final class ParetoDistribution
extends ProbabilityDistribution {
    private double shape;
    private double scale;

    public ParetoDistribution(double d, double d2) {
        if (d < 0.0) {
            throw new OutOfRangeException("The shape parameter should be positive.");
        }
        this.shape = d;
        if (d2 < 0.0) {
            throw new OutOfRangeException("The scale paremeter should be positive.");
        }
        this.scale = d2;
    }

    public double getShapeParameter() {
        return this.shape;
    }

    public double getScaleParameter() {
        return this.scale;
    }

    public double getMean() {
        return this.shape * this.scale / (this.shape - 1.0);
    }

    public double getVariance() {
        return this.shape * this.scale * this.scale / ((this.shape - 2.0) * (this.shape - 1.0) * (this.shape - 1.0));
    }

    public double probability(double d) {
        if (d < this.scale) {
            throw new OutOfRangeException("X should be greater than or equal to the scale.");
        }
        return this.shape * Math.pow(this.scale / d, this.shape) / d;
    }

    public double cumulative(double d) {
        if (d < this.scale) {
            throw new OutOfRangeException("X should be greater than or equal to the scale.");
        }
        return 1.0 - Math.pow(this.scale / d, this.shape);
    }

    public double inverse(double d) {
        this.checkRange(d);
        return this.scale / Math.pow(1.0 - d, 1.0 / this.shape);
    }
}

