/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.io.ObjectStreamException;
import java.io.Serializable;
import jscheme.SchemePair;
import jsint.E;
import jsint.Scheme;
import jsint.Symbol;
import jsint.U;

public class Pair
implements Serializable,
SchemePair {
    public Object first;
    public Object rest;
    public static final Pair EMPTY = new Pair(null, null);

    public Pair(Object first, Object rest) {
        this.first = first;
        this.rest = rest;
    }

    public Object getFirst() {
        return this.first;
    }

    public Object getRest() {
        return this.rest;
    }

    public Object setFirst(Object x) {
        Object y = this.first;
        this.first = x;
        return y;
    }

    public Object setRest(Object x) {
        Object y = this.rest;
        this.rest = x;
        return y;
    }

    public Object first() {
        return this.first;
    }

    public Object rest() {
        return this.rest;
    }

    public Object second() {
        return U.toPair((Object)this.rest).first;
    }

    public Object third() {
        return U.second(this.rest);
    }

    public Object reverse() {
        Pair result = EMPTY;
        Pair list = this;
        while (list != EMPTY) {
            if (Scheme.isInterruptable()) {
                Scheme.interruptCheck();
            }
            result = new Pair(list.first, result);
            list = U.toList(list.rest);
        }
        return result;
    }

    public int hashCode() {
        if (this == EMPTY) {
            return super.hashCode();
        }
        int head = Pair.hashCode0(this.first);
        int tail = Pair.hashCode0(this.rest);
        return head + tail * 37;
    }

    private static int hashCode0(Object it) {
        if (it == null) {
            return 17;
        }
        if (it instanceof Object[]) {
            return Pair.arrayHashCode((Object[])it);
        }
        return it.hashCode();
    }

    private static int arrayHashCode(Object[] xs) {
        int code = 0;
        for (int i = 0; i < xs.length; ++i) {
            code += xs[i].hashCode() * 37;
        }
        return code;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        return that instanceof Pair && that != EMPTY && this != EMPTY && this.equalsFirst((Pair)that) && U.equal(this.rest, ((Pair)that).rest);
    }

    private boolean equalsFirst(Pair that) {
        return this.first == null ? that.first == null : U.equal(this.first, that.first);
    }

    public String toString() {
        if (this == EMPTY) {
            return "()";
        }
        return this.stringifyPair(true, new StringBuffer()).toString();
    }

    public StringBuffer stringifyPair(boolean quoted, StringBuffer buf) {
        String special = null;
        if (U.isPair(this.rest) && U.rest(this.rest) == EMPTY) {
            String string = this.first == Symbol.QUOTE ? "'" : (this.first == Symbol.QUASIQUOTE ? "`" : (this.first == Symbol.UNQUOTE ? "," : (special = this.first == Symbol.UNQUOTE_SPLICING ? ",@" : null)));
        }
        if (special != null) {
            buf.append(special);
            U.stringify(U.second(this), quoted, buf);
        } else {
            buf.append('(');
            U.stringify(this.first, quoted, buf);
            Object tail = this.rest;
            while (U.isPair(tail)) {
                if (Scheme.isInterruptable()) {
                    Scheme.interruptCheck();
                }
                buf.append(' ');
                U.stringify(((Pair)tail).first, quoted, buf);
                tail = ((Pair)tail).rest;
            }
            if (tail != EMPTY) {
                buf.append(" . ");
                U.stringify(tail, quoted, buf);
            }
            buf.append(')');
        }
        return buf;
    }

    public int length() {
        int len = 0;
        Object list = this;
        while (U.isPair(list)) {
            if (Scheme.isInterruptable()) {
                Scheme.interruptCheck();
            }
            ++len;
            list = U.rest(list);
        }
        return len;
    }

    public Object nth(int n) {
        return U.toPair((Object)this.listTail((int)n)).first;
    }

    public Object listTail(int n) {
        int orig = n;
        Pair list = this;
        while (n > 0) {
            --n;
            if (list.isEmpty()) {
                E.error("attempting to compute listTail " + orig + " which is greater than the length of the list", this);
                continue;
            }
            list = U.toList(list.rest);
        }
        return list;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public Object getEltNover2(int n) {
        Pair t = this;
        while (n > 1 && t.rest != null) {
            t = (Pair)t.rest;
            n -= 2;
        }
        if (n == 0) {
            return t;
        }
        if (n == 1) {
            return t.first;
        }
        return null;
    }

    public Object setEltNover2(int n, Object v) {
        Pair t = this;
        while (n > 1 && t.rest != null) {
            t = (Pair)t.rest;
            n -= 2;
        }
        if (n == 1) {
            t.first = v;
            return t.first;
        }
        E.warn("ERROR in setEltNover2");
        return null;
    }

    private Object readResolve() throws ObjectStreamException {
        return this.first == this && this.rest == this ? EMPTY : this;
    }

    static {
        Pair.EMPTY.first = Pair.EMPTY.rest = EMPTY;
    }
}

