/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.lang.reflect.Method;
import java.util.Hashtable;
import jsint.E;
import jsint.Evaluator;
import jsint.Import;
import jsint.Invoke;
import jsint.LexicalEnvironment;
import jsint.Pair;
import jsint.Reflector;
import jsint.U;

public class JavaMethod
extends Reflector {
    public static final Object[] ZERO_ARGS = new Object[0];
    private String methodClass;
    private transient Object[] methodTable;
    private boolean isStatic;
    private boolean isSpecific;
    private transient Hashtable classMethodTable;

    public boolean isStatic() {
        return this.isStatic;
    }

    public JavaMethod(String name, Class c, boolean isStatic, boolean isPrivileged) {
        this.name = name;
        if (c != null) {
            this.methodClass = c.getName();
        }
        this.isStatic = isStatic;
        this.isSpecific = c != null;
        this.minArgs = isStatic ? 0 : 1;
        this.isPrivileged = isPrivileged;
        this.reset();
    }

    public JavaMethod(String name, Class c, boolean isStatic) {
        this(name, c, isStatic, false);
    }

    public JavaMethod(String name, Class c) {
        this(name, c, c != null);
    }

    protected synchronized void reset() {
        if (this.isSpecific) {
            this.methodTable = Invoke.methodTable0(Import.classNamed(this.methodClass), this.name, this.isStatic, this.isPrivileged);
            if (this.methodTable.length == 0) {
                this.methodTable = null;
                E.warn("No such " + (this.isStatic ? " static " : " instance ") + " method \"" + this.name + (this.isSpecific ? "\" in class " + this.methodClass : ""));
            }
        } else {
            this.classMethodTable = new Hashtable(5);
        }
    }

    public Object[] instanceMethodTable(Class c) {
        Object[] ms = (Object[])this.classMethodTable.get(c);
        if (ms != null) {
            return ms;
        }
        ms = Invoke.methodTable0(c, this.name, this.isStatic, this.isPrivileged);
        if (ms != null && ms.length > 0) {
            this.classMethodTable.put(c, ms);
            return ms;
        }
        return (Object[])E.error(c + " has no methods for " + this.name);
    }

    public Object apply(Object[] args) {
        if (!this.isSpecific) {
            Object[] methodTable = this.instanceMethodTable(args[0].getClass());
            Object[] as = (Object[])args[1];
            Method m = (Method)Invoke.findMethod(methodTable, as);
            return Invoke.invokeRawMethod(m, args[0], as);
        }
        if (this.methodTable == null) {
            return E.error(this + " has no methods");
        }
        if (this.isStatic) {
            Method m = (Method)Invoke.findMethod(this.methodTable, args);
            return Invoke.invokeRawMethod(m, null, args);
        }
        Object[] as = (Object[])args[1];
        Method m = (Method)Invoke.findMethod(this.methodTable, as);
        return Invoke.invokeRawMethod(m, args[0], as);
    }

    public Object[] makeArgArray(Object[] code, Evaluator eval, LexicalEnvironment lexenv) {
        if (this.isStatic) {
            int L = code.length - 1;
            if (L == 0) {
                return ZERO_ARGS;
            }
            Object[] args = new Object[L];
            for (int i = 0; i < L; ++i) {
                args[i] = eval.execute(code[i + 1], lexenv);
            }
            return args;
        }
        int L = code.length - 2;
        if (L < 0) {
            return (Object[])E.error("Wrong number of arguments in application: " + U.stringify(code));
        }
        Object target = eval.execute(code[1], lexenv);
        if (L == 0) {
            return new Object[]{target, ZERO_ARGS};
        }
        Object[] args = new Object[L];
        for (int i = 0; i < L; ++i) {
            args[i] = eval.execute(code[i + 2], lexenv);
        }
        return new Object[]{target, args};
    }

    public Object[] makeArgArray(Pair args) {
        if (this.isStatic) {
            return U.listToVector(args);
        }
        return new Object[]{args.first, U.listToVector(args.rest)};
    }
}

