/*
 * Decompiled with CFR 0.152.
 */
package interact;

import java.io.IOException;
import java.io.Writer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;

public class OutputDocument
extends PlainDocument {
    Position outputPos = this.newPosition(0);

    public int getOutputOffset() {
        return this.outputPos.getOffset();
    }

    public int handleNewline(Writer w, int dot) {
        int outPos = this.getOutputOffset();
        int eob = this.getLength();
        if (dot >= outPos && w != null) {
            try {
                super.insertString(eob, "\n", null);
                w.write(this.getText(outPos, eob + 1 - outPos));
                w.flush();
                this.outputPos = this.newPosition(eob + 1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            return eob + 1;
        }
        return dot;
    }

    private Position newPosition(int offset) {
        try {
            return this.createPosition(offset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            System.out.println("Return Position(0)!");
            return this.newPosition(0);
        }
    }

    public void insertString(int offset, String text, AttributeSet as) throws BadLocationException {
        int oldOffset = this.outputPos.getOffset();
        super.insertString(offset, text, as);
        if (oldOffset == offset) {
            this.outputPos = this.newPosition(oldOffset);
        }
    }

    public synchronized void insertOutput(String text, AttributeSet as) {
        int oldOffset = this.outputPos.getOffset();
        int newOffset = oldOffset + text.length();
        try {
            super.insertString(oldOffset, text, as);
        }
        catch (BadLocationException e) {
            System.out.println("This shouldn't happen!");
            e.printStackTrace();
        }
        if (this.outputPos.getOffset() != newOffset) {
            this.outputPos = this.newPosition(newOffset);
        }
    }
}

