/*
 * Decompiled with CFR 0.152.
 */
package com.rie.rieps.simpletest;

import com.rie.rieps.engine.Document;
import com.rie.rieps.engine.Frame;
import com.rie.rieps.engine.Job;
import com.rie.rieps.engine.LineFormat;
import com.rie.rieps.engine.Page;
import com.rie.rieps.engine.TextParameter;
import com.rie.rieps.engine.color.Gray;
import com.rie.rieps.engine.image.SmallGrayImage;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import javax.imageio.ImageIO;

public class GenPSFile {
    public static void main(String[] args) {
        try {
            if (args.length <= 0) {
                System.out.println("Test the Rieps java postscript library.\nUSAGE : java -cp rieps.jar com.rie.rieps.simpletest.GenPSFile output.ps [AWTPSFontMapping.properties]");
                System.exit(0);
            }
            URL url = GenPSFile.class.getResource("duke.jpg");
            BufferedImage bufferedImage = ImageIO.read(url);
            SmallGrayImage bwi = new SmallGrayImage(0);
            bwi.load(bufferedImage);
            SmallGrayImage bwi2 = new SmallGrayImage(2);
            bwi2.load(bufferedImage);
            SmallGrayImage bwi3 = new SmallGrayImage(1);
            bwi3.load(bufferedImage);
            FileOutputStream os = new FileOutputStream(args[0]);
            Job job = Job.createPSTopLeftOriginJob(os, 595.0f, 842.0f);
            if (args.length > 1) {
                String mapfile = null;
                mapfile = args[1];
                File f = new File(mapfile);
                if (f.exists() && f.isFile()) {
                    job.addAwtPSFontMappingPropertiesFile(f);
                }
            }
            job.setAvailableDeviceFont(new String[]{"Times-Roman", "Helvetica", "Courier", "Times-Italic", "Times-Bold", "Helvetica-Bold"});
            job.askForUnmappedAWTFont(true);
            job.echoFontMapping(true);
            job.open();
            Document doc = job.createDocument(10);
            doc.open();
            for (int i = 0; i < 10; ++i) {
                Page p = doc.createPage();
                p.setColor(new Gray(0.7f));
                p.setLineFormat(new LineFormat(5.0f, new int[]{10}, i, new Gray(0.0f)));
                p.setAWTFont(new Font("DIALOG", 0, 7 + i));
                p.drawRect(100.0f, 200 + 10 * i, 300.0f, 50.0f, i * 5, i * 3, true, true);
                p.drawRect(10.0f, 300 + 10 * i, 100.0f, 70.0f, i * 7, 0.0f, true, false);
                p.drawCircle(400.0f, 500.0f, 75.0f, true, true);
                p.setColor(new Gray(1.0f - (float)i / 10.0f));
                p.setLineFormat(new LineFormat(2.0f, 2 * i + 1, new Gray((float)i / 10.0f)));
                p.drawEllipse(250.0f, 600.0f, 30 * (i + 1), 100.0f, i * 20, true, true);
                p.drawImage(50.0f, 100.0f, bwi, 100.0f, 100.0f);
                p.drawImage(150.0f, 100.0f, bwi2, 100.0f, 100.0f);
                p.drawImage(350.0f, 100.0f, bwi3, (i + 1) * 30, 100.0f);
                p.setColor(new Gray(0.0f));
                p.showText(50.0f, 400.0f, 100.0f, 50.0f, "Bonjour le monde (!!! : " + i, new TextParameter(2, 1, Gray.BLACK, i * 15, i % 2 == 0));
                LineFormat lf = new LineFormat(1.0f, new int[]{5}, 0, new Gray(0.0f));
                String txt = "this is a very long text to test the frame metode of RIEPS. A frame can display text into a box with vertical and horizontal justification.";
                Frame frm = new Frame(200.0f, 500.0f, 100.0f, 70.0f + (float)(i * 5), i, i, i, i, lf, null, lf, null, true, new Gray(0.8f), (float)i * 20.0f, txt, p.getCurrentFont(), new TextParameter(1, 1, Gray.BLACK, i * 20, i % 2 == 0));
                p.drawFrame(frm);
                frm = new Frame(200.0f, 300.0f, 100.0f, 70.0f + (float)(i * 5), i, i, i, i, lf, lf, lf, lf, true, new Gray(0.8f), (float)i * 20.0f * -1.0f, txt, p.getCurrentFont(), new TextParameter(1, 1, Gray.BLACK, i * 20 * -1, i % 2 == 0));
                p.drawFrame(frm);
                p.setLineFormat(new LineFormat(2.0f, new int[]{5, 5, 2, 5}, 0, new Gray(0.0f)));
                p.drawLine(200.0f, 500.0f, 100.0f, 0.0f);
                p.drawLine(200.0f, 500.0f, 0.0f, 100.0f);
                doc.showPage(p);
            }
            doc.close();
            job.close();
        }
        catch (Exception ex) {
            System.err.println("Erreur lors du test : " + ex);
            ex.printStackTrace();
        }
    }
}

