/*
 * Decompiled with CFR 0.152.
 */
package com.rie.rieps.engine.factories;

import com.rie.rieps.engine.DeviceParameter;
import com.rie.rieps.engine.Frame;
import com.rie.rieps.engine.LineFormat;
import com.rie.rieps.engine.Page;
import com.rie.rieps.engine.TextParameter;
import com.rie.rieps.engine.color.Color;
import com.rie.rieps.engine.color.Gray;
import com.rie.rieps.engine.factories.Factory;
import com.rie.rieps.engine.fonts.PSFont;
import com.rie.rieps.engine.image.Image;
import com.rie.rieps.exception.RiepsException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PSFactory
implements Factory {
    private static final String PROTECTED_ANTI_SLASH = "\\\\";
    private static final String ANTI_SLASH = "\\";
    private static final String PROTECTED_LEFT_BRACKET = "\\(";
    private static final String PROTECTED_RIGHT_BRACKET = "\\)";
    private static final String LEFT_BRACKET = "(";
    private static final String RIGHT_BRACKET = ")";
    private static final String SLASH = "/";
    private static final String LEFT_HOOK = "[";
    private static final String RIGHT_HOOK = "]";
    private static final String SP = " ";
    private static final String RET = "\n";
    private static final String PAGE_NUMBER = "%%Page :";
    private static final String SHOW_PAGE = "%%EndPage\nshowpage\n";
    private static final String SET_FNT = "makefont setfont-setlh";
    private static final String FIND_FNT = "findfont";
    private static final String ROLL = "roll";
    private static final String MAKELINES = "makelines";
    private static final String APPEND_ARRAY = "aa";
    private static final String XPRINTLINES = "xprintlines";
    private static final String LINE = "line";
    private static final String RECTAR = "rectar";
    private static final String ELLIPSE = "ellipse";
    private static final String GSAVE = "gs";
    private static final String GRESTORE = "gr";
    private static final String TRANSLATE = "trl";
    private static final String ROTATE = "rt";
    private static final String SCALE = "scale";
    private static final String pd_open = "<< ";
    private static final String pd_close = " >> setpagedevice\n";
    private static final String pd_ps = "/PageSize [ ";

    private BufferedReader getResourceReader(String s) throws IOException {
        BufferedReader br = null;
        InputStream is = this.getClass().getResourceAsStream(s);
        br = new BufferedReader(new InputStreamReader(is));
        return br;
    }

    @Override
    public StringBuffer getBeginJob(int totalPageNumber, float width, float height) {
        StringBuffer sb = new StringBuffer(5000);
        sb.append("%!PS-Adobe-3.0\n");
        sb.append("%%Pages: ");
        if (totalPageNumber > 0) {
            sb.append(totalPageNumber);
        } else {
            sb.append("(attend)");
        }
        sb.append("\n%%Creator: RiePS\n");
        sb.append("%%CreationDate: ");
        sb.append(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date()));
        sb.append("\n%%BoundingBox: 0 0 ");
        sb.append(width);
        sb.append(SP);
        sb.append(height);
        sb.append("\n%%EndComments\n");
        try {
            BufferedReader br = this.getResourceReader("/com/rie/rieps/engine/resources/PSFactory.begin.ps");
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append(RET);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb;
    }

    @Override
    public StringBuffer getEndJob() {
        StringBuffer sb = new StringBuffer(5000);
        try {
            BufferedReader br = this.getResourceReader("/com/rie/rieps/engine/resources/PSFactory.end.ps");
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append(RET);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        sb.append("%%EOF");
        return sb;
    }

    @Override
    public StringBuffer showPage(Page page, int pageNumber, int totalPageNumber) {
        StringBuffer nbp = new StringBuffer();
        nbp.append(PAGE_NUMBER);
        nbp.append(SP);
        nbp.append(pageNumber);
        nbp.append(SP);
        if (totalPageNumber > 0) {
            nbp.append(totalPageNumber);
        } else {
            nbp.append(pageNumber);
        }
        nbp.append(RET);
        nbp.append(this.makePageDevice(page));
        StringBuffer sbp = new StringBuffer(page.getPageStringBuffer().length() + nbp.length() + 50);
        sbp.append(nbp);
        sbp.append(page.getPageStringBuffer());
        sbp.append(SHOW_PAGE);
        return sbp;
    }

    @Override
    public void showText(Page page, float x, float y, float weight, float height, String txt, TextParameter tp) {
        int i;
        StringBuffer sb = new StringBuffer();
        String[] stxts = txt.split(RET);
        StringBuffer[] sbtxts = new StringBuffer[stxts.length];
        for (i = 0; i < stxts.length; ++i) {
            sbtxts[i] = this.escapeText(stxts[i]);
        }
        if (page.getCurrentFont() != null) {
            StringBuffer fnt = this.makeFont(page.getCurrentFont(), tp.getColor());
            sb.append(fnt);
            sb.append(RET);
        }
        if (tp == null) {
            tp = new TextParameter(0, 0, Gray.BLACK, 0.0f, true);
        }
        for (i = 0; i < sbtxts.length; ++i) {
            if (i > 0) {
                sb.append(SP);
            }
            sb.append(weight);
            sb.append(SP);
            sb.append(LEFT_BRACKET);
            sb.append(sbtxts[i].toString());
            sb.append(RIGHT_BRACKET);
            sb.append(SP);
            sb.append(MAKELINES);
            if (i <= 0) continue;
            sb.append(SP);
            sb.append(APPEND_ARRAY);
        }
        sb.append(RET);
        sb.append(tp.isClip());
        sb.append(SP);
        sb.append(tp.getVertical());
        sb.append(SP);
        sb.append(height);
        sb.append(SP);
        sb.append(tp.getHorizontal());
        sb.append(SP);
        sb.append(tp.getRotate());
        sb.append(SP);
        sb.append(weight);
        sb.append(SP);
        sb.append(x);
        sb.append(SP);
        sb.append(y);
        sb.append(SP);
        sb.append(9);
        sb.append(SP);
        sb.append(-1);
        sb.append(SP);
        sb.append(ROLL);
        sb.append(SP);
        sb.append(XPRINTLINES);
        sb.append(RET);
        page.getPageStringBuffer().append(sb);
    }

    @Override
    public void drawLine(Page page, float x1, float y1, float weight, float height) {
        StringBuffer sb = new StringBuffer();
        LineFormat lf = page.getCurrentLineFormat();
        float[] cc = lf.getColor().getComposite();
        for (int i = 0; i < cc.length; ++i) {
            sb.append(cc[i]);
            sb.append(SP);
        }
        sb.append(LEFT_HOOK);
        int[] dp = lf.getDashPattern();
        for (int i = 0; i < dp.length; ++i) {
            if (i > 0) {
                sb.append(SP);
            }
            sb.append(dp[i]);
        }
        sb.append(RIGHT_HOOK);
        sb.append(SP);
        sb.append(lf.getDashOffset());
        sb.append(SP);
        sb.append(lf.getWidth());
        sb.append(SP);
        sb.append(x1);
        sb.append(SP);
        sb.append(y1);
        sb.append(SP);
        sb.append(weight);
        sb.append(SP);
        sb.append(height);
        sb.append(SP);
        sb.append(LINE);
        sb.append(RET);
        page.getPageStringBuffer().append(sb);
    }

    @Override
    public void drawRect(Page page, float x, float y, float width, float height, float rotate, float radius, boolean border, boolean fill) {
        float[] cc;
        StringBuffer sb = new StringBuffer();
        LineFormat lf = page.getCurrentLineFormat();
        if (border) {
            cc = lf.getColor().getComposite();
            for (int i = 0; i < cc.length; ++i) {
                sb.append(cc[i]);
                sb.append(SP);
            }
            sb.append(LEFT_HOOK);
            int[] dp = lf.getDashPattern();
            for (int i = 0; i < dp.length; ++i) {
                if (i > 0) {
                    sb.append(SP);
                }
                sb.append(dp[i]);
            }
            sb.append(RIGHT_HOOK);
            sb.append(SP);
            sb.append(lf.getDashOffset());
            sb.append(SP);
            sb.append(lf.getWidth());
            sb.append(SP);
        }
        sb.append(border);
        sb.append(SP);
        if (fill) {
            cc = page.getCurrentFillColor().getComposite();
            for (int i = 0; i < cc.length; ++i) {
                sb.append(cc[i]);
                sb.append(SP);
            }
        }
        sb.append(fill);
        sb.append(SP);
        sb.append(rotate);
        sb.append(SP);
        sb.append(x);
        sb.append(SP);
        sb.append(y);
        sb.append(SP);
        sb.append(width);
        sb.append(SP);
        sb.append(height);
        sb.append(SP);
        sb.append(radius);
        sb.append(SP);
        sb.append(RECTAR);
        sb.append(RET);
        page.getPageStringBuffer().append(sb);
    }

    @Override
    public void drawEllipse(Page page, float x, float y, float width, float height, float rotate, boolean border, boolean fill) {
        float[] cc;
        StringBuffer sb = new StringBuffer();
        LineFormat lf = page.getCurrentLineFormat();
        if (border) {
            cc = lf.getColor().getComposite();
            for (int i = 0; i < cc.length; ++i) {
                sb.append(cc[i]);
                sb.append(SP);
            }
            sb.append(LEFT_HOOK);
            int[] dp = lf.getDashPattern();
            for (int i = 0; i < dp.length; ++i) {
                if (i > 0) {
                    sb.append(SP);
                }
                sb.append(dp[i]);
            }
            sb.append(RIGHT_HOOK);
            sb.append(SP);
            sb.append(lf.getDashOffset());
            sb.append(SP);
            sb.append(lf.getWidth());
            sb.append(SP);
        }
        sb.append(border);
        sb.append(SP);
        if (fill) {
            cc = page.getCurrentFillColor().getComposite();
            for (int i = 0; i < cc.length; ++i) {
                sb.append(cc[i]);
                sb.append(SP);
            }
        }
        sb.append(fill);
        sb.append(SP);
        sb.append(rotate);
        sb.append(SP);
        sb.append(x);
        sb.append(SP);
        sb.append(y);
        sb.append(SP);
        sb.append(width);
        sb.append(SP);
        sb.append(height);
        sb.append(SP);
        sb.append(ELLIPSE);
        sb.append(RET);
        page.getPageStringBuffer().append(sb);
    }

    @Override
    public void drawImage(Page page, float x, float y, Image img, float width, float height) throws RiepsException {
        StringBuffer sb = new StringBuffer();
        sb.append(GSAVE);
        sb.append(SP);
        sb.append(x);
        sb.append(SP);
        sb.append(y);
        sb.append(SP);
        sb.append(TRANSLATE);
        sb.append(SP);
        sb.append(width);
        sb.append(SP);
        sb.append(height);
        sb.append(SP);
        sb.append(SCALE);
        sb.append(RET);
        sb.append(img.getPSImage());
        sb.append(RET);
        sb.append(GRESTORE);
        sb.append(RET);
        page.getPageStringBuffer().append(sb);
    }

    @Override
    public void drawFrame(Page page, Frame frm) {
        LineFormat lf;
        if (frm.isFill()) {
            Color c = page.getCurrentFillColor();
            page.setColor(frm.getFillColor());
            this.drawRect(page, frm.getLeft(), frm.getTop(), frm.getWidth(), frm.getHeight(), frm.getRotate(), 0.0f, false, true);
            page.setColor(c);
        }
        page.getPageStringBuffer().append(GSAVE);
        page.getPageStringBuffer().append(SP);
        page.getPageStringBuffer().append(frm.getLeft());
        page.getPageStringBuffer().append(SP);
        page.getPageStringBuffer().append(frm.getTop());
        page.getPageStringBuffer().append(SP);
        page.getPageStringBuffer().append(TRANSLATE);
        page.getPageStringBuffer().append(SP);
        page.getPageStringBuffer().append(frm.getRotate());
        page.getPageStringBuffer().append(SP);
        page.getPageStringBuffer().append(ROTATE);
        page.getPageStringBuffer().append(RET);
        LineFormat clf = page.getCurrentLineFormat();
        if (frm.getLfTop() != null) {
            lf = frm.getLfTop();
            page.setLineFormat(lf);
            this.drawLine(page, 0.0f, 0.0f, frm.getWidth(), 0.0f);
        }
        if (frm.getLfRight() != null) {
            lf = frm.getLfRight();
            page.setLineFormat(lf);
            this.drawLine(page, frm.getWidth(), 0.0f, 0.0f, frm.getHeight() * -1.0f);
        }
        if (frm.getLfBottom() != null) {
            lf = frm.getLfBottom();
            page.setLineFormat(lf);
            this.drawLine(page, 0.0f, frm.getHeight() * -1.0f, frm.getWidth(), 0.0f);
        }
        if (frm.getLfLeft() != null) {
            lf = frm.getLfLeft();
            page.setLineFormat(lf);
            this.drawLine(page, 0.0f, 0.0f, 0.0f, frm.getHeight() * -1.0f);
        }
        page.setLineFormat(clf);
        page.getPageStringBuffer().append(GRESTORE);
        page.getPageStringBuffer().append(SP);
        this.showText(page, frm.getLeft(), frm.getTop(), frm.getWidth(), frm.getHeight(), frm.getText(), frm.getTextParameter());
    }

    private StringBuffer escapeText(String s) {
        StringBuffer tmp = new StringBuffer(s);
        int ind = -2;
        while ((ind = tmp.indexOf(ANTI_SLASH, ind + 2)) >= 0) {
            tmp = tmp.replace(ind, ind + 1, PROTECTED_ANTI_SLASH);
        }
        ind = -2;
        while ((ind = tmp.indexOf(LEFT_BRACKET, ind + 2)) >= 0) {
            tmp = tmp.replace(ind, ind + 1, PROTECTED_LEFT_BRACKET);
        }
        ind = -2;
        while ((ind = tmp.indexOf(RIGHT_BRACKET, ind + 2)) >= 0) {
            tmp = tmp.replace(ind, ind + 1, PROTECTED_RIGHT_BRACKET);
        }
        if (tmp.length() >= 255) {
            int n = tmp.length() / 255;
            for (int i = 1; i <= n; ++i) {
                tmp.insert(i * 255 + (i - 1), RET);
            }
        }
        return tmp;
    }

    private StringBuffer makeFont(PSFont fnt, Color color) {
        StringBuffer sb = new StringBuffer(160);
        if (fnt == null) {
            fnt = PSFont.DEFAULT;
        }
        sb.append(this.makeColor(color));
        sb.append(SLASH);
        sb.append(fnt.getName());
        sb.append(SP);
        sb.append(FIND_FNT);
        sb.append(SP);
        sb.append(LEFT_HOOK);
        sb.append(fnt.getMatrix_a());
        sb.append(SP);
        sb.append(fnt.getMatrix_b());
        sb.append(SP);
        sb.append(fnt.getMatrix_c());
        sb.append(SP);
        sb.append(fnt.getMatrix_d());
        sb.append(SP);
        sb.append(fnt.getMatrix_e());
        sb.append(SP);
        sb.append(fnt.getMatrix_f());
        sb.append(RIGHT_HOOK);
        sb.append(SP);
        sb.append(SET_FNT);
        sb.append(SP);
        return sb;
    }

    private StringBuffer makeColor(Color color) {
        StringBuffer sb = new StringBuffer(25);
        if (color == null) {
            color = Gray.BLACK;
        }
        float[] compo = color.getComposite();
        for (int i = 0; i < compo.length; ++i) {
            sb.append(compo[i]);
            sb.append(SP);
        }
        sb.append(color.getPSCommande());
        sb.append(SP);
        return sb;
    }

    private StringBuffer makeLineFormat(LineFormat lf) {
        StringBuffer sb = new StringBuffer(10);
        float[] cc = lf.getColor().getComposite();
        for (int i = 0; i < cc.length; ++i) {
            sb.append(cc[i]);
            sb.append(SP);
        }
        sb.append(LEFT_HOOK);
        int[] dp = lf.getDashPattern();
        for (int i = 0; i < dp.length; ++i) {
            if (i > 0) {
                sb.append(SP);
            }
            sb.append(dp[i]);
        }
        sb.append(RIGHT_HOOK);
        sb.append(SP);
        sb.append(lf.getDashOffset());
        sb.append(SP);
        sb.append(lf.getWidth());
        return sb;
    }

    private StringBuffer makePageDevice(Page page) {
        StringBuffer sb = new StringBuffer();
        sb.append(pd_open);
        if (page.getDeviceParameters().containsKey(DeviceParameter.PAGE_SIZE)) {
            try {
                float[] pz = (float[])page.getDeviceParameters().get(DeviceParameter.PAGE_SIZE);
                sb.append(pd_ps);
                sb.append(pz[0]);
                sb.append(SP);
                sb.append(pz[1]);
                sb.append(SP);
                sb.append(RIGHT_HOOK);
            }
            catch (Exception e) {
                System.err.print("PAGE_SIZE value is not float[2] : " + e);
            }
        }
        sb.append(pd_close);
        return sb;
    }
}

