/*
 * Decompiled with CFR 0.152.
 */
package com.rie.rieps.engine;

import com.rie.rieps.engine.color.Color;
import com.rie.rieps.engine.color.Gray;

public class TextParameter {
    public static final int HZ_LEFT = 0;
    public static final int HZ_CENTER = 1;
    public static final int HZ_RIGHT = 2;
    public static final int HZ_JUSTIFY = 3;
    public static final int VERT_TOP = 0;
    public static final int VERT_MIDDLE = 1;
    public static final int VERT_BOTTOM = 2;
    private int horizontal;
    private int vertical;
    private Color color = Gray.BLACK;
    private float rotate = 0.0f;
    private boolean clip = false;

    public TextParameter(int hz, int v, Color col, float rotate, boolean verticalclip) {
        this.horizontal = hz;
        this.vertical = v;
        this.color = col;
        this.rotate = rotate;
        this.clip = verticalclip;
    }

    public TextParameter setHorizontal(int hz) {
        return new TextParameter(hz, this.getVertical(), this.getColor(), this.getRotate(), this.isClip());
    }

    public TextParameter setVertical(int v) {
        return new TextParameter(this.getHorizontal(), v, this.getColor(), this.getRotate(), this.isClip());
    }

    public int getHorizontal() {
        return this.horizontal;
    }

    public int getVertical() {
        return this.vertical;
    }

    public Color getColor() {
        return this.color;
    }

    public TextParameter setColor(Color color) {
        return new TextParameter(this.getHorizontal(), this.getVertical(), color, this.getRotate(), this.isClip());
    }

    public float getRotate() {
        return this.rotate;
    }

    public TextParameter setRotate(float rotate) {
        return new TextParameter(this.getHorizontal(), this.getVertical(), this.getColor(), rotate, this.isClip());
    }

    public boolean isClip() {
        return this.clip;
    }

    public TextParameter setClip(boolean clip) {
        return new TextParameter(this.getHorizontal(), this.getVertical(), this.getColor(), this.getRotate(), clip);
    }
}

