/*
 * Decompiled with CFR 0.152.
 */
package Util.Structures;

import Mapper.Rule;
import java.util.ArrayList;

public class TreeNode<E>
extends ArrayList<TreeNode<E>> {
    private TreeNode<E> parent;
    private E data;
    private int depth;
    private int id;
    private int info;

    public TreeNode() {
        this.info = 0;
    }

    public TreeNode(TreeNode<E> parent, E data) {
        this.parent = parent;
        this.data = data;
        this.info = 0;
        this.id = 0;
    }

    public TreeNode(TreeNode<E> copy) {
        this(copy, copy.getParent());
    }

    public TreeNode(TreeNode<E> copy, TreeNode<E> parent) {
        this.parent = parent;
        this.data = copy.data;
        this.info = copy.info;
        this.id = copy.id;
        for (TreeNode treeNode : copy) {
            this.add(new TreeNode<E>(treeNode, this));
        }
    }

    @Override
    public boolean add(TreeNode<E> child) {
        child.setParent(this);
        child.setDepth(this.getDepth() + 1);
        return super.add(child);
    }

    public TreeNode<E> getParent() {
        return this.parent;
    }

    public void setParent(TreeNode<E> tn) {
        this.parent = tn;
        this.setDepth(this.parent.getDepth() + 1);
    }

    public E getData() {
        return this.data;
    }

    public void setData(E data) {
        this.data = data;
    }

    public int getInfo() {
        return this.info;
    }

    public void setInfo(int info) {
        this.info = info;
    }

    public int getID() {
        return this.id;
    }

    public void setID(int id) {
        this.id = id;
    }

    public void setDepth(int i) {
        this.depth = i;
        for (int n = 0; n < this.size(); ++n) {
            TreeNode node = (TreeNode)this.get(n);
            node.setDepth(i + 1);
        }
    }

    public int getMaxDepth() {
        int max = this.depth;
        for (TreeNode node : this) {
            max = Math.max(max, node.getMaxDepth());
        }
        return max;
    }

    public int getDepth() {
        return this.depth;
    }

    public TreeNode<E> getEnd() {
        return (TreeNode)this.get(this.size() - 1);
    }

    public String collapse() {
        StringBuffer s = new StringBuffer();
        s.append(this.getData());
        if (this.getParent() != null) {
            s.append(this.getParent().collapse());
        }
        for (TreeNode e : this) {
            s.append(e.getData().toString());
            s.append(e.getParent().collapse());
        }
        return s.toString();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder, "");
        return builder.toString();
    }

    private boolean toString(StringBuilder builder, String indent) {
        builder.append(indent.replaceAll("\u0001", "|_").replaceAll("\u0002", "|_"));
        builder.append(this.getData());
        if (super.size() != 0) {
            builder.append("\n");
            for (int i = 0; i < super.size(); ++i) {
                if (((TreeNode)super.get(i)).toString(builder, indent.replaceAll("\u0001", "| ").replaceAll("\u0002", "  ") + (i < super.size() - 1 ? "\u0001" : "\u0002"))) continue;
                if (i < super.size() - 1) {
                    builder.append("\n");
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        TreeNode tn = new TreeNode();
        TreeNode tn2 = new TreeNode();
        Rule c = new Rule();
        c.setMinimumDepth(1);
        tn.setParent(tn);
        tn.setData(c);
        tn.add(tn2);
        tn2.setParent(tn);
        tn2.setData(new Rule(c));
        ((Rule)tn2.getData()).setMinimumDepth(2);
        TreeNode tn3 = new TreeNode(tn2);
        System.out.println(((Rule)tn.getParent().getData()).getMinimumDepth());
        System.out.println(((Rule)tn2.getData()).getMinimumDepth());
        System.out.println(((Rule)tn3.getParent().getData()).getMinimumDepth());
        ((Rule)tn2.getData()).setMinimumDepth(4);
        tn3.setParent(tn2);
        System.out.println(((Rule)tn.getParent().getData()).getMinimumDepth());
        System.out.println(((Rule)tn2.getData()).getMinimumDepth());
        System.out.println(((Rule)tn3.getParent().getData()).getMinimumDepth());
    }
}

