/*
 * Decompiled with CFR 0.152.
 */
package Util.Structures;

import Util.Structures.IntIterator;
import Util.Structures.IntList;
import Util.Structures.StaticIntIterator;

public class StaticIntList
implements IntList {
    public int[] data;
    public int currentSize;
    public final int initialSize;
    public static int maxSize = Integer.MAX_VALUE;

    public StaticIntList(int size) {
        this.data = new int[size];
        this.currentSize = 0;
        this.initialSize = size;
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0;
        }
    }

    public StaticIntList(StaticIntList list) {
        this.data = new int[list.data.length];
        if (list.data != null) {
            System.arraycopy(list.data, 0, this.data, 0, list.data.length);
        }
        this.currentSize = list.currentSize;
        this.initialSize = list.initialSize;
    }

    public void setMaxSize(int i) {
        maxSize = i;
    }

    public int getMaxSize() {
        return maxSize;
    }

    @Override
    public int get(int index) {
        return this.data[index];
    }

    @Override
    public void set(int index, int item) {
        this.data[index] = item;
    }

    public void setAll(int[] data) {
        this.data = data;
        this.currentSize = this.data.length;
    }

    @Override
    public void clear() {
        this.currentSize = 0;
    }

    @Override
    public int[] toArray() {
        int[] arr = new int[this.currentSize];
        if (this.data != null) {
            System.arraycopy(this.data, 0, arr, 0, this.currentSize);
        }
        return arr;
    }

    @Override
    public IntIterator iterator() {
        return new StaticIntIterator(this.data, this.currentSize);
    }

    @Override
    public void add(int item) throws IndexOutOfBoundsException {
        if (this.currentSize < maxSize) {
            if (this.currentSize == this.data.length) {
                int[] newData = new int[(int)Math.ceil((double)this.data.length * 1.1)];
                System.arraycopy(this.data, 0, newData, 0, this.data.length);
                this.data = newData;
            }
            this.data[this.currentSize] = item;
            ++this.currentSize;
        } else {
            throw new IndexOutOfBoundsException("No adding, too long, length:" + this.data.length);
        }
    }

    public static void main(String[] args) {
        StaticIntList l = new StaticIntList(10);
        for (int i = 0; i <= 8; ++i) {
            l.add(i);
        }
        IntIterator itr = l.iterator();
        while (itr.hasNext()) {
            System.out.println(itr.next());
        }
        System.out.println(l.size());
    }

    @Override
    public int size() {
        return this.currentSize;
    }

    public int allocationSize() {
        return this.data.length;
    }
}

