/*
 * Decompiled with CFR 0.152.
 */
package Util.Structures;

import Individuals.Phenotype;
import Mapper.Symbol;
import Util.Enums;
import Util.Structures.BinaryNode;
import Util.Structures.Operators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;

public class ReversePolish {
    private BinaryNode<Symbol> root;
    private ArrayList<Symbol> postfix = new ArrayList();
    private ArrayList<Symbol> tokens;
    private int global_cnt;
    private Operators operators;

    public ReversePolish() {
        this.operators = new Operators();
    }

    public ReversePolish(String s) {
        this.setTokens(s);
        this.operators = new Operators();
    }

    public void clear() {
        this.root = null;
        this.postfix.clear();
        if (this.tokens != null) {
            this.tokens.clear();
        }
        this.global_cnt = 0;
    }

    public void setTokens(String s) {
        this.tokens = new ArrayList();
        List<String> als = Arrays.asList(s.split("\\s+"));
        for (int i = 0; i < als.size(); ++i) {
            this.tokens.add(new Symbol(als.get(i), Enums.SymbolType.TSymbol));
        }
    }

    public void setTokens(ArrayList<Symbol> tokens) {
        this.tokens = tokens;
    }

    public ArrayList<Symbol> getTokens() {
        return this.tokens;
    }

    public BinaryNode<Symbol> getRoot() {
        return this.root;
    }

    public ArrayList<Symbol> getPostfix() {
        return this.postfix;
    }

    public Phenotype toPrefixPhenotype(Phenotype phenotype) {
        this.setTokens(phenotype);
        this.toReversePolish();
        this.treeFromPostfix();
        Phenotype prefixPhenotype = new Phenotype();
        this.treeToPrefixPhenotype(prefixPhenotype, this.root);
        return prefixPhenotype;
    }

    public void treeFromPostfix() {
        this.global_cnt = this.postfix.size() - 1;
        this.root = this.buildTreeFromPostfix();
    }

    public BinaryNode<Symbol> buildTreeFromPostfix() {
        BinaryNode<Symbol> new_node = null;
        if (this.global_cnt > -1) {
            new_node = new BinaryNode<Symbol>();
            Symbol s = this.postfix.get(this.global_cnt);
            --this.global_cnt;
            if (!this.operators.containsKey(s)) {
                new_node.setValue(s);
                return new_node;
            }
            new_node.setLeft(this.buildTreeFromPostfix());
            if (!this.operators.isUnary(s)) {
                new_node.setRight(this.buildTreeFromPostfix());
            }
            new_node.setValue(s);
        }
        return new_node;
    }

    public String toReversePolish() {
        Symbol operator = null;
        Stack<Symbol> siding = new Stack<Symbol>();
        for (int index = 0; index < this.tokens.size(); ++index) {
            Symbol nextToken = this.tokens.get(index);
            if (nextToken.equals(")")) {
                operator = (Symbol)siding.pop();
                while (!operator.equals("(")) {
                    this.postfix.add(operator);
                    operator = (Symbol)siding.pop();
                }
                continue;
            }
            if (nextToken.equals("(")) {
                siding.push(nextToken);
                continue;
            }
            if (this.operators.containsKey(nextToken) && !nextToken.equals("(")) {
                while (!siding.empty() && this.operators.priority(nextToken) <= this.operators.priority(siding.peek())) {
                    operator = (Symbol)siding.pop();
                    this.postfix.add(operator);
                }
                siding.push(nextToken);
                continue;
            }
            this.postfix.add(nextToken);
        }
        while (!siding.empty()) {
            this.postfix.add((Symbol)siding.pop());
        }
        return this.postfix.toString();
    }

    public String toPrefixString(BinaryNode<Symbol> node) {
        StringBuffer sb = new StringBuffer();
        if (node != null) {
            sb.append(node.getValue());
            sb.append(" ");
            sb.append(this.toPrefixString(node.getLeft()));
            if (!this.operators.isUnary(node.getValue())) {
                sb.append(this.toPrefixString(node.getRight()));
            }
        }
        return sb.toString();
    }

    private void treeToPrefixPhenotype(Phenotype phenotype, BinaryNode<Symbol> node) {
        if (node != null) {
            phenotype.add(node.getValue());
            this.treeToPrefixPhenotype(phenotype, node.getLeft());
            if (!this.operators.isUnary(node.getValue())) {
                this.treeToPrefixPhenotype(phenotype, node.getRight());
            }
        }
    }
}

