/*
 * Decompiled with CFR 0.152.
 */
package Util.Structures;

import Mapper.Symbol;
import java.util.HashSet;
import java.util.Hashtable;

public class Operators<E> {
    private final Hashtable<String, Integer> operators = new Hashtable();
    private final HashSet<String> unaryOperators = new HashSet();

    public Operators() {
        this.operators.put("(", 10);
        this.operators.put("-", 20);
        this.operators.put("+", 20);
        this.operators.put("/", 30);
        this.operators.put("*", 30);
        this.operators.put("^", 50);
        this.operators.put("&", 40);
        this.operators.put("|", 60);
        this.operators.put("~", 61);
        this.operators.put("not", 61);
        this.unaryOperators.add("~");
        this.unaryOperators.add("not");
    }

    public int priority(String operator) {
        int value = !this.operators.containsKey(operator) ? -1 : this.operators.get(operator);
        return value;
    }

    public boolean isUnary(String operator) {
        boolean value = this.unaryOperators.contains(operator);
        return value;
    }

    public boolean containsKey(String s) {
        return this.operators.containsKey(s);
    }

    public int priority(E operator) {
        int value;
        if (operator instanceof Symbol) {
            value = this.priority(((Symbol)operator).getSymbolString());
        } else if (operator instanceof String) {
            value = this.priority((String)operator);
        } else {
            throw new IllegalArgumentException("Bad type for:" + operator + " Must be String or Symbol. Is:" + operator.getClass());
        }
        return value;
    }

    public boolean isUnary(E operator) {
        boolean value;
        if (operator instanceof Symbol) {
            value = this.isUnary(((Symbol)operator).getSymbolString());
        } else if (operator instanceof String) {
            value = this.isUnary((String)operator);
        } else {
            throw new IllegalArgumentException("Bad type for:" + operator + " Must be String or Symbol. Is:" + operator.getClass());
        }
        return value;
    }

    public boolean containsKey(E operator) {
        boolean value;
        if (operator instanceof Symbol) {
            value = this.containsKey(((Symbol)operator).getSymbolString());
        } else if (operator instanceof String) {
            value = this.containsKey((String)operator);
        } else {
            throw new IllegalArgumentException("Bad type for:" + operator + " Must be String or Symbol. Is:" + operator.getClass());
        }
        return value;
    }
}

