/*
 * Decompiled with CFR 0.152.
 */
package Util.Structures;

import Util.Structures.TreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Stack;
import java.util.StringTokenizer;

public class NimbleTree<E> {
    private TreeNode<E> root;
    private TreeNode<E> currentNode;
    private Stack<TreeNode<E>> freeNodes;
    private int nodeCount;
    private int depth;
    private int currentLevel;
    private int maxStackSize;

    public NimbleTree() {
        this.root = this.newNode();
        this.currentNode = this.root;
        this.nodeCount = 1;
        this.depth = 0;
        this.currentLevel = 0;
        this.freeNodes = new Stack();
        this.maxStackSize = 10;
    }

    public NimbleTree(E data) {
        this.root = this.newNode();
        this.root.setData(data);
        this.currentNode = this.root;
        this.nodeCount = 1;
        this.depth = 0;
        this.currentLevel = 0;
        this.freeNodes = new Stack();
        this.maxStackSize = 10;
    }

    public NimbleTree(NimbleTree<E> n) {
        this.root = n.root;
        this.currentNode = n.currentNode;
        this.nodeCount = n.nodeCount;
        this.freeNodes = new Stack();
        this.depth = n.depth;
        this.currentLevel = n.currentLevel;
    }

    protected TreeNode<E> newNode() {
        return new TreeNode();
    }

    public void setMaxStackSize(int i) {
        this.maxStackSize = i;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public void populateStack() {
        for (int i = 0; i < this.maxStackSize; ++i) {
            TreeNode<E> tn = this.newNode();
            this.freeNodes.push(tn);
        }
    }

    public TreeNode<E> getRoot() {
        return this.root;
    }

    public void setRoot(TreeNode<E> tn) {
        this.root = tn;
    }

    public TreeNode<E> getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(TreeNode<E> tn) {
        this.currentNode = tn;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public void setNodeCount(int i) {
        this.nodeCount = i;
    }

    public void setDepth(int i) {
        this.depth = i;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public void setCurrentLevel(int i) {
        this.currentLevel = i;
    }

    public static NimbleTree<String> makeTreeOverStringFromSExpression(String input) {
        NimbleTree<String> tree = new NimbleTree<String>();
        Stack<TreeNode<String>> previousParents = new Stack<TreeNode<String>>();
        input = input.replace("(", " ( ");
        input = input.replace(")", " ) ");
        StringTokenizer st = new StringTokenizer(input);
        boolean firstTimeThrough = true;
        while (st.hasMoreTokens()) {
            String currTok = st.nextToken().trim();
            if (currTok.equals("")) continue;
            if (currTok.equals("(")) {
                currTok = st.nextToken().trim();
                if (firstTimeThrough) {
                    firstTimeThrough = false;
                    tree.getRoot().setData(currTok);
                    continue;
                }
                tree.addChild(currTok);
                tree.getCurrentNode().getEnd().setID(tree.getNodeCount());
                previousParents.push(tree.getCurrentNode());
                tree.setCurrentNode(tree.getCurrentNode().getEnd());
                continue;
            }
            if (currTok.equals(")")) {
                if (previousParents.empty()) continue;
                tree.setCurrentNode((TreeNode)previousParents.pop());
                continue;
            }
            if (firstTimeThrough) {
                firstTimeThrough = false;
                tree.getRoot().setData(currTok);
                continue;
            }
            tree.addChild(currTok);
            tree.getCurrentNode().getEnd().setID(tree.getNodeCount());
        }
        return tree;
    }

    public ArrayList<ArrayList<TreeNode<E>>> getRootToLeafPaths() {
        ArrayList<TreeNode<E>> leafNodes = new ArrayList<TreeNode<E>>();
        for (TreeNode<E> node : this.depthFirstTraversal(this.getRoot())) {
            if (node.size() != 0) continue;
            leafNodes.add(node);
        }
        ArrayList paths = new ArrayList();
        for (TreeNode leaf : leafNodes) {
            TreeNode current;
            ArrayList path = new ArrayList();
            for (current = leaf; current != this.getRoot(); current = current.getParent()) {
                path.add(current);
            }
            path.add(current);
            Collections.reverse(path);
            paths.add(path);
        }
        return paths;
    }

    public ArrayList<ArrayList<TreeNode<E>>> getAncestorChains(int n) {
        ArrayList<ArrayList<TreeNode<ArrayList<TreeNode<E>>>>> retval = new ArrayList<ArrayList<TreeNode<ArrayList<TreeNode<E>>>>>();
        for (TreeNode<E> node : this.depthFirstTraversal(this.getRoot())) {
            ArrayList<TreeNode<E>> chain = this.getAncestorChain(node, n);
            if (chain.size() != n) continue;
            Collections.reverse(chain);
            retval.add(chain);
        }
        return retval;
    }

    public ArrayList<TreeNode<E>> getAncestorChain(TreeNode<E> node, int n) {
        ArrayList<TreeNode<TreeNode<E>>> retval = new ArrayList<TreeNode<TreeNode<E>>>();
        for (TreeNode<E> current = node; retval.size() < n && current != null && current.getData() != null; current = current.getParent()) {
            retval.add(current);
        }
        return retval;
    }

    public ArrayList<TreeNode<E>> depthFirstTraversal(TreeNode<E> root) {
        ArrayList<TreeNode<TreeNode<E>>> retval = new ArrayList<TreeNode<TreeNode<E>>>();
        retval.add(root);
        for (TreeNode treeNode : root) {
            retval.addAll(this.depthFirstTraversal(treeNode));
        }
        return retval;
    }

    public ArrayList<Integer> getBranchLengths() {
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        this.getBranchLengths(this.getRoot(), lengths);
        return lengths;
    }

    public ArrayList<Integer> getBranchLengths(TreeNode<E> root) {
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        this.getBranchLengths(root, lengths);
        return lengths;
    }

    private void getBranchLengths(TreeNode<E> root, ArrayList<Integer> lengths) {
        for (TreeNode treeNode : root) {
            if (treeNode.isEmpty()) {
                lengths.add(treeNode.getDepth());
                continue;
            }
            this.getBranchLengths(treeNode, lengths);
        }
    }

    public void addChild(E data) {
        TreeNode<E> n = new TreeNode<E>();
        n.setData(data);
        n.setParent(this.currentNode);
        n.clear();
        this.currentNode.add(n);
        if (n.getDepth() > this.getDepth()) {
            this.setDepth(n.getDepth());
        }
        ++this.nodeCount;
        n.setID(this.nodeCount);
    }

    public String toString() {
        return this.root.toString();
    }
}

