/*
 * Decompiled with CFR 0.152.
 */
package Util;

import Individuals.Chromosome;
import Individuals.GEChromosome;
import Individuals.GEIndividual;
import Individuals.Individual;
import Individuals.Phenotype;
import Mapper.DerivationNode;
import Mapper.DerivationTree;
import Mapper.GEGrammar;
import Mapper.Production;
import Mapper.Rule;
import Mapper.Symbol;
import Mapper.TreeMill;
import Util.Enums;
import Util.Structures.TreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Stack;

public class GenotypeHelper {
    private GenotypeHelper() {
    }

    public static DerivationTree buildDerivationTree(Individual individual, DerivationNode node) {
        assert (individual.getGenotype().get(0) instanceof GEChromosome) : ((Chromosome)individual.getGenotype().get(0)).getClass().getName();
        assert (individual.getMapper() instanceof GEGrammar) : individual.getMapper().getClass().getName();
        GEGrammar grammar = (GEGrammar)individual.getMapper();
        if (node != null) {
            grammar.setStartSymbol((Symbol)node.getData());
        }
        grammar.getPhenotype().clear();
        DerivationTree tree = TreeMill.getDerivationTree(grammar);
        if (tree.buildDerivationTree()) {
            return tree;
        }
        return null;
    }

    public static DerivationTree buildInvalidTree(Individual individual, DerivationNode node) {
        assert (individual.getGenotype().get(0) instanceof GEChromosome) : ((Chromosome)individual.getGenotype().get(0)).getClass().getName();
        assert (individual.getMapper() instanceof GEGrammar) : individual.getMapper().getClass().getName();
        GEGrammar grammar = (GEGrammar)individual.getMapper();
        if (node != null) {
            grammar.setStartSymbol((Symbol)node.getData());
        }
        grammar.getPhenotype().clear();
        DerivationTree tree = TreeMill.getDerivationTree(grammar);
        tree.buildDerivationTree();
        return tree;
    }

    public static DerivationTree buildInvalidTree(Individual individual) {
        return GenotypeHelper.buildInvalidTree(individual, null);
    }

    public static DerivationTree buildDerivationTree(Individual individual) {
        return GenotypeHelper.buildDerivationTree(individual, null);
    }

    public static DerivationNode findNodeFromCodonIndex(DerivationTree tree, int codonIndex) {
        return GenotypeHelper.findNodeFromCodonIndex(tree, codonIndex, -1);
    }

    public static DerivationNode findNodeFromCodonIndex(DerivationTree tree, int codonIndex, int usedGenes) {
        Stack<DerivationNode> nodeStack = new Stack<DerivationNode>();
        nodeStack.push((DerivationNode)tree.getRoot());
        while (!nodeStack.empty()) {
            DerivationNode nodes = (DerivationNode)nodeStack.pop();
            if (nodes.getCodonIndex() == codonIndex) {
                return nodes;
            }
            for (TreeNode node : nodes) {
                nodeStack.push((DerivationNode)node);
            }
        }
        throw new AssertionError((Object)"Indexed node not found");
    }

    public static int calcNodeLength(DerivationNode nodes) {
        Stack<DerivationNode> nodeStack = new Stack<DerivationNode>();
        nodeStack.push(nodes);
        int size = 0;
        while (!nodeStack.empty()) {
            nodes = (DerivationNode)nodeStack.pop();
            if (nodes.getCodonIndex() != -1) {
                ++size;
            }
            for (TreeNode node : nodes) {
                nodeStack.push((DerivationNode)node);
            }
        }
        assert (size > 0) : size;
        return size;
    }

    public static GEChromosome makeNewChromosome(Individual i1, int point1, int length1, Individual i2, int point2, int length2) {
        return GenotypeHelper.makeNewChromosome(i1, point1, length1, i2, point2, length2, null);
    }

    public static GEChromosome makeNewChromosome(Individual i1, int point1, int length1, Individual i2, int point2, int length2, DerivationTree tree) {
        int i;
        GEChromosome c1 = (GEChromosome)i1.getGenotype().get(0);
        GEChromosome c2 = (GEChromosome)i2.getGenotype().get(0);
        i1.map(0);
        i2.map(0);
        int total = ((GEIndividual)i1).getUsedCodons() - length1 + length2;
        GEChromosome c = new GEChromosome(total);
        c.setMaxChromosomeLength(c1.getMaxChromosomeLength());
        for (i = 0; i < point1; ++i) {
            c.add(c1.get(i % c1.size()));
        }
        for (i = point2; i < point2 + length2; ++i) {
            c.add(c2.get(i % c2.size()));
        }
        for (i = point1 + length1; i < ((GEIndividual)i1).getUsedCodons(); ++i) {
            c.add(c1.get(i % c1.size()));
        }
        c.setUsedGenes(total);
        assert (c.size() == c.allocationSize() && c.size() == total) : c.size() + "==" + c.allocationSize() + "==" + total;
        return c;
    }

    public static GEChromosome makeNewChromosome(Individual i1, int point, int length, Individual i2, DerivationTree tree) {
        i2.map(0);
        return GenotypeHelper.makeNewChromosome(i1, point, length, i2, 0, ((GEIndividual)i2).getUsedCodons(), tree);
    }

    public static int getMaxDTIndex(DerivationTree dT) {
        TreeNode currItr = dT.getRoot();
        LinkedList visitNodes = new LinkedList();
        visitNodes.add(currItr);
        int maxIndex = 0;
        while (visitNodes.size() > 0) {
            currItr = (TreeNode)visitNodes.remove(0);
            DerivationNode DN = (DerivationNode)currItr;
            if (DN.getCodonIndex() > maxIndex) {
                maxIndex = DN.getCodonIndex();
            }
            Iterator nodeItr = currItr.iterator();
            while (nodeItr.hasNext()) {
                visitNodes.add(nodeItr.next());
            }
        }
        return maxIndex;
    }

    public static boolean derivationTreesEqual(DerivationTree t1, DerivationTree t2) {
        TreeNode currItr1 = t1.getRoot();
        TreeNode currItr2 = t2.getRoot();
        LinkedList visitNodes1 = new LinkedList();
        LinkedList visitNodes2 = new LinkedList();
        visitNodes1.add(currItr1);
        visitNodes2.add(currItr2);
        while (visitNodes1.size() > 0 && visitNodes2.size() > 0) {
            Symbol s2;
            if (visitNodes1.size() != visitNodes2.size()) {
                return false;
            }
            currItr1 = (TreeNode)visitNodes1.remove(0);
            currItr2 = (TreeNode)visitNodes2.remove(0);
            Symbol s1 = (Symbol)currItr1.getData();
            if (!s1.equals(s2 = (Symbol)currItr2.getData())) {
                return false;
            }
            Iterator nodeItr1 = currItr1.iterator();
            Iterator nodeItr2 = currItr2.iterator();
            while (nodeItr1.hasNext()) {
                visitNodes1.add(nodeItr1.next());
            }
            while (nodeItr2.hasNext()) {
                visitNodes2.add(nodeItr2.next());
            }
        }
        return true;
    }

    public static int[] getRecursiveNodeIndeces(DerivationTree dt, GEGrammar gram) {
        TreeNode currItr = dt.getRoot();
        LinkedList visitNodes = new LinkedList();
        visitNodes.add(currItr);
        ArrayList<Integer> recIndexList = new ArrayList<Integer>();
        while (visitNodes.size() > 0) {
            currItr = (TreeNode)visitNodes.remove(0);
            Symbol currentSym = (Symbol)currItr.getData();
            Rule currentRule = gram.findRule(currentSym);
            DerivationNode dN = (DerivationNode)currItr;
            Iterator nodeItr = currItr.iterator();
            if (nodeItr.hasNext() && currentSym.getType().equals((Object)Enums.SymbolType.NTSymbol) && dN.getCodonIndex() != -1 && currentRule.getRecursive()) {
                recIndexList.add(dN.getCodonIndex());
            }
            while (nodeItr.hasNext()) {
                visitNodes.add(nodeItr.next());
            }
        }
        int[] recIndex = new int[recIndexList.size()];
        for (int i = 0; i < recIndex.length; ++i) {
            recIndex[i] = (Integer)recIndexList.get(i);
        }
        return recIndex;
    }

    public static Individual extendChromeAtRecursiveNode(Individual indiv, GEChromosome giver, Symbol giverSym, int mutatePoint) {
        GEChromosome receiver = (GEChromosome)indiv.getGenotype().get(0);
        GEGrammar gram = (GEGrammar)indiv.getMapper();
        int receiverUsedCodons = receiver.getUsedGenes();
        int giverUsedCodons = giver.getUsedGenes();
        int[] receiverArr = receiver.toArray();
        int[] giverArr = giver.toArray();
        int[] newArr = new int[receiverUsedCodons + giverUsedCodons];
        if (mutatePoint == 0) {
            System.arraycopy(giverArr, 0, newArr, 0, giverUsedCodons);
            System.arraycopy(receiverArr, 0, newArr, giverUsedCodons, receiverUsedCodons);
        } else {
            System.arraycopy(receiverArr, 0, newArr, 0, mutatePoint);
            System.arraycopy(giverArr, 0, newArr, mutatePoint, giverUsedCodons);
            System.arraycopy(receiverArr, mutatePoint, newArr, mutatePoint + giverUsedCodons, receiverUsedCodons - mutatePoint);
        }
        receiver.setAll(newArr);
        indiv.getGenotype().set(0, receiver);
        indiv.map(0);
        if (GenotypeHelper.numRecNodes(GenotypeHelper.buildDerivationTree(indiv), gram) <= 1) {
            int tempCodon = GenotypeHelper.extendRecursiveNode(newArr[mutatePoint], indiv, giverSym);
            if (tempCodon != newArr[mutatePoint]) {
                newArr[mutatePoint] = tempCodon;
                receiver.setAll(newArr);
            }
        } else {
            int lastRecIndex = GenotypeHelper.findLastRecIndex(indiv);
            int tempCodon = GenotypeHelper.extendRecursiveNode(newArr[lastRecIndex], indiv, giverSym);
            if (tempCodon != newArr[lastRecIndex]) {
                newArr[lastRecIndex] = tempCodon;
                receiver.setAll(newArr);
            }
        }
        indiv.getGenotype().set(0, receiver);
        return indiv;
    }

    public static int findLastRecIndex(Individual indiv) {
        GEGrammar gram = (GEGrammar)indiv.getMapper();
        DerivationTree tree = GenotypeHelper.buildDerivationTree(indiv);
        DerivationNode root = (DerivationNode)tree.getRoot();
        return GenotypeHelper.findLastRecIndex(root, gram);
    }

    public static int findLastRecIndex(DerivationNode dNode, GEGrammar gram) {
        int lastRecIndex = -1;
        TreeNode currItr = dNode;
        LinkedList<DerivationNode> visitNodes = new LinkedList<DerivationNode>();
        visitNodes.add((DerivationNode)currItr);
        while (visitNodes.size() > 0) {
            DerivationNode node;
            Rule currRule;
            currItr = (TreeNode)visitNodes.remove(0);
            Symbol currSym = (Symbol)currItr.getData();
            if (currSym.getType().equals((Object)Enums.SymbolType.NTSymbol) && (currRule = gram.findRule(currSym)).getRecursive() && (node = (DerivationNode)currItr).getCodonIndex() != -1) {
                lastRecIndex = node.getCodonIndex();
            }
            Iterator nodeItr = currItr.iterator();
            while (nodeItr.hasNext()) {
                visitNodes.add((DerivationNode)nodeItr.next());
            }
        }
        return lastRecIndex;
    }

    public static int extendRecursiveNode(int codonToChange, Individual indiv, Symbol childRootSym) {
        GEGrammar gram = (GEGrammar)indiv.getMapper();
        Rule recRule = gram.findRule(childRootSym);
        boolean foundRecursiveRule = false;
        for (int i = 0; i < recRule.size(); ++i) {
            Production p = (Production)recRule.get(i);
            for (Symbol newSym : p) {
                if (!newSym.getType().equals((Object)Enums.SymbolType.NTSymbol)) continue;
                Rule newRule = gram.findRule(newSym);
                if (newSym.equals(childRootSym)) {
                    foundRecursiveRule = true;
                    break;
                }
                if (!newRule.getRecursive()) continue;
                foundRecursiveRule = true;
                break;
            }
            if (!foundRecursiveRule) continue;
            int modValDiff = Math.abs(codonToChange % recRule.size() - i);
            codonToChange = codonToChange - modValDiff > 0 ? (codonToChange -= modValDiff) : (codonToChange += modValDiff);
            return codonToChange;
        }
        return codonToChange;
    }

    public static int numRecNodes(DerivationTree tree, GEGrammar gram) {
        int numRecNodes = 0;
        TreeNode currItr = tree.getRoot();
        LinkedList visitNodes = new LinkedList();
        visitNodes.add(currItr);
        while (visitNodes.size() > 0) {
            Rule currRule;
            currItr = (TreeNode)visitNodes.remove(0);
            Symbol currSym = (Symbol)currItr.getData();
            if (currSym.getType().equals((Object)Enums.SymbolType.NTSymbol) && (currRule = gram.findRule(currSym)).getRecursive()) {
                ++numRecNodes;
            }
            Iterator nodeItr = currItr.iterator();
            while (nodeItr.hasNext()) {
                visitNodes.add(nodeItr.next());
            }
        }
        return numRecNodes;
    }

    public static int nodesDifferentAtIndex(DerivationNode n1, DerivationNode n2) {
        int diffIndex = -1;
        TreeNode currIt1 = n1;
        TreeNode currIt2 = n2;
        LinkedList<DerivationNode> visitNodes1 = new LinkedList<DerivationNode>();
        LinkedList<DerivationNode> visitNodes2 = new LinkedList<DerivationNode>();
        visitNodes1.add((DerivationNode)currIt1);
        visitNodes2.add((DerivationNode)currIt2);
        while (visitNodes1.size() > 0 && visitNodes2.size() > 0) {
            currIt1 = (TreeNode)visitNodes1.remove(0);
            currIt2 = (TreeNode)visitNodes2.remove(0);
            Symbol currSym1 = (Symbol)currIt1.getData();
            Symbol currSym2 = (Symbol)currIt2.getData();
            System.out.println(currSym1 + " ---> " + currSym2);
            if (!currSym1.equals(currSym2)) {
                return diffIndex;
            }
            diffIndex = ((DerivationNode)currIt1).getCodonIndex();
            System.out.println("Diff index: " + diffIndex);
            Iterator nodeIt1 = currIt1.iterator();
            Iterator nodeIt2 = currIt2.iterator();
            while (nodeIt1.hasNext()) {
                visitNodes1.add((DerivationNode)nodeIt1.next());
            }
            while (nodeIt2.hasNext()) {
                visitNodes2.add((DerivationNode)nodeIt2.next());
            }
        }
        return diffIndex;
    }

    public static ArrayList<Integer> getDerivationTreeIndeces(DerivationTree dT) {
        ArrayList<Integer> indeces = new ArrayList<Integer>();
        TreeNode currIt = dT.getRoot();
        LinkedList visitNodes = new LinkedList();
        visitNodes.add(currIt);
        while (visitNodes.size() > 0) {
            currIt = (TreeNode)visitNodes.remove(0);
            int index = ((DerivationNode)currIt).getCodonIndex();
            if (index > -1) {
                indeces.add(index);
            }
            Iterator nodeIt = currIt.iterator();
            while (nodeIt.hasNext()) {
                visitNodes.add(nodeIt.next());
            }
        }
        return indeces;
    }

    public static Phenotype getNodePhenotype(DerivationNode node) {
        Phenotype phen = new Phenotype();
        Stack<DerivationNode> nodes = new Stack<DerivationNode>();
        nodes.push(node);
        while (!nodes.empty()) {
            DerivationNode dN = (DerivationNode)nodes.pop();
            Symbol sym = (Symbol)dN.getData();
            if (sym.getType().equals((Object)Enums.SymbolType.TSymbol)) {
                phen.add(sym);
            }
            ListIterator nodeIt = dN.listIterator(dN.size());
            while (nodeIt.hasPrevious()) {
                DerivationNode currNode = (DerivationNode)nodeIt.previous();
                if (currNode == null) continue;
                nodes.push(currNode);
            }
        }
        return phen;
    }
}

