/*
 * Decompiled with CFR 0.152.
 */
package Operator;

import Individuals.FitnessPackage.BasicFitness;
import Individuals.GEChromosome;
import Individuals.GEIndividual;
import Individuals.Genotype;
import Individuals.Individual;
import Individuals.Phenotype;
import Individuals.Populations.Population;
import Individuals.Populations.SimplePopulation;
import Mapper.GEGrammar;
import Operator.Operations.Operation;
import Operator.Operations.SelectionOperation;
import Operator.Operations.TournamentSelect;
import Operator.SplitOperator;
import Util.Random.MersenneTwisterFast;
import Util.Random.RandomNumberGenerator;
import java.util.Iterator;
import java.util.Properties;

public class SelectionScheme
extends SplitOperator {
    public SelectionScheme(RandomNumberGenerator rng, int size, Operation op) {
        super(rng, size, op);
        SelectionOperation sOp = (SelectionOperation)op;
        this.destinationPopulation = sOp.getSelectedPopulation();
    }

    public SelectionScheme(RandomNumberGenerator rng, Operation op) {
        super(rng, ((SelectionOperation)op).getSize(), op);
        SelectionOperation sOp = (SelectionOperation)op;
        this.destinationPopulation = sOp.getSelectedPopulation();
    }

    @Override
    public void setProperties(Properties p) {
    }

    @Override
    public void perform() {
        this.operation.doOperation(this.population.getAll());
    }

    @Override
    public void setOperation(Operation op) {
        this.operation = op;
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public Population getPopulation() {
        return this.destinationPopulation;
    }

    public static void main(String[] Args) {
        SimplePopulation p = new SimplePopulation();
        for (int i = 0; i < 100; ++i) {
            GEIndividual ind = new GEIndividual();
            GEChromosome c = new GEChromosome(100);
            Genotype g = new Genotype();
            g.add(c);
            ind.setGenotype(g);
            ind.setPhenotype(new Phenotype());
            ind.setMapper(new GEGrammar());
            BasicFitness f = new BasicFitness(i, ind);
            ind.setFitness(f);
            p.add(ind);
        }
        MersenneTwisterFast m = new MersenneTwisterFast();
        TournamentSelect t = new TournamentSelect(50, 3, m);
        SelectionScheme selecta = new SelectionScheme((RandomNumberGenerator)m, 100, t);
        selecta.setPopulation(p);
        int tests = 100;
        double totalavg = 0.0;
        for (int i = 0; i < tests; ++i) {
            selecta.perform();
            Population selected = selecta.getPopulation();
            Iterator<Individual> pItr = selected.iterator();
            double fitsofar = 0.0;
            while (pItr.hasNext()) {
                fitsofar += pItr.next().getFitness().getDouble();
            }
            double avgFitness = fitsofar / (double)p.size();
            totalavg += avgFitness;
        }
        double x = totalavg / (double)tests;
        System.out.println(x);
    }
}

