/*
 * Decompiled with CFR 0.152.
 */
package Operator;

import Exceptions.BadParameterException;
import Individuals.Individual;
import Individuals.Populations.SimplePopulation;
import Mapper.GEGrammar;
import Operator.Initialiser;
import Operator.Operations.CreationOperation;
import Operator.Operations.FullInitialiser;
import Operator.Operations.GrowInitialiser;
import Util.Random.RandomNumberGenerator;
import java.util.List;
import java.util.Properties;

public class RampedHalfAndHalfInitialiser
extends Initialiser {
    protected CreationOperation growInitialisation;
    protected double growProb;
    protected int currentDepth;
    protected int maxDepth;
    protected int depthInterval;

    public RampedHalfAndHalfInitialiser(RandomNumberGenerator rng, int size, CreationOperation op, CreationOperation op2, double growProb, int maxDepth) {
        super(rng, size, op);
        this.growProb = growProb;
        this.currentDepth = 0;
        this.maxDepth = maxDepth;
        this.population = new SimplePopulation();
        this.growInitialisation = op2;
        for (int i = 0; i < size; ++i) {
            this.population.add(this.operation.createIndividual());
        }
    }

    public RampedHalfAndHalfInitialiser() {
    }

    @Override
    public void setProperties(Properties p) {
        int valueI;
        double value;
        super.setProperties(p);
        String key = "grow_probability";
        try {
            value = Double.parseDouble(p.getProperty(key));
            if (value < 0.0 || value > 1.0) {
                throw new BadParameterException(key);
            }
        }
        catch (Exception e) {
            value = 0.5;
            p.setProperty(key, Double.toString(value));
            System.out.println(e + " using default: " + value);
        }
        this.growProb = value;
        key = "max_depth";
        try {
            valueI = Integer.parseInt(p.getProperty(key));
            if (valueI < 1) {
                throw new BadParameterException(key);
            }
        }
        catch (Exception e) {
            valueI = 10;
            p.setProperty(key, Integer.toString(valueI));
            System.out.println(e + " using default: " + valueI);
        }
        this.maxDepth = valueI;
    }

    @Override
    public void perform() {
        this.depthInterval = this.getDepthInterval(this.size);
        for (int i = 0; i < this.size; ++i) {
            Individual individual = this.population.get(i);
            if (i % this.depthInterval == 0) {
                ((FullInitialiser)this.operation).setMaxDepth(this.currentDepth);
                ((GrowInitialiser)this.growInitialisation).setMaxDepth(this.currentDepth);
                ++this.currentDepth;
            }
            if (this.getRNG().nextDouble() <= this.growProb) {
                this.growInitialisation.doOperation(individual);
                continue;
            }
            this.operation.doOperation(individual);
        }
    }

    public int getDepthInterval(int populationSize) {
        int depthInt;
        Individual individual = this.population.get(0);
        if (this.currentDepth < ((GEGrammar)individual.getMapper()).findRule(((GEGrammar)individual.getMapper()).getStartSymbol()).getMinimumDepth()) {
            this.currentDepth = ((GEGrammar)individual.getMapper()).findRule(((GEGrammar)individual.getMapper()).getStartSymbol()).getMinimumDepth();
        }
        if (this.currentDepth > this.maxDepth) {
            System.out.println("Max depth to small, must be larger then minDepth.");
            this.maxDepth = this.currentDepth;
        }
        if ((depthInt = populationSize / (this.maxDepth - this.currentDepth + 1)) < 1) {
            System.out.println("Too small population for initialisation on all depths");
            depthInt = 1;
        }
        return depthInt;
    }

    public void setOperations(List<CreationOperation> ops) {
        this.operation = ops.get(0);
        this.growInitialisation = ops.get(1);
    }
}

