/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Exceptions.BadParameterException;
import Individuals.Individual;
import Operator.Operations.SelectionOperation;
import Util.Random.MersenneTwisterFast;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class UserSelect
extends SelectionOperation {
    private JDialog dialog = null;
    private JPanel guiPanel = null;
    private JButton cmdDone = new JButton();
    private Rectangle rectangle;
    private int pickSize;
    private boolean userActive = true;
    private boolean doneUsed = false;

    public UserSelect(int size, int pickSize) {
        super(size);
        this.pickSize = pickSize;
    }

    public UserSelect() {
    }

    @Override
    public void setProperties(Properties p) {
        int value;
        super.setProperties(p);
        try {
            String key = "userpick_size";
            value = Integer.parseInt(p.getProperty(key));
            if (value < 1) {
                throw new BadParameterException(key);
            }
        }
        catch (Exception e) {
            value = 10;
            System.out.println(e + " using default: " + value);
        }
        this.pickSize = value;
    }

    @Override
    public void doOperation(Individual operand) {
    }

    @Override
    public void doOperation(List<Individual> operands) {
        int pickSizeEx = this.pickSize;
        ArrayList<Individual> sortedOperands = new ArrayList<Individual>();
        for (Individual operand : operands) {
            if (!operand.isValid()) continue;
            sortedOperands.add(operand);
        }
        Collections.sort(sortedOperands);
        if (pickSizeEx > sortedOperands.size()) {
            pickSizeEx = sortedOperands.size();
        }
        ArrayList<Individual> pickOperands = new ArrayList<Individual>(pickSizeEx);
        for (int index = 0; index < pickSizeEx; ++index) {
            pickOperands.add((Individual)sortedOperands.get(index));
        }
        this.userPick(pickOperands);
    }

    public void userPick(List<Individual> operands) {
        this.doneUsed = false;
        this.initialiseDialog();
        if (this.userActive) {
            this.display(operands);
            this.select(operands);
        }
        if (!this.doneUsed) {
            this.userActive = false;
        }
        this.defaultSelect(operands);
        this.terminateDialog();
    }

    private void initialiseDialog() {
        this.dialog = new JDialog();
        this.dialog.setLayout(new BorderLayout());
        if (this.rectangle != null) {
            this.dialog.setBounds(this.rectangle);
        } else {
            this.dialog.setSize(400, 300);
        }
        this.dialog.setModal(true);
        this.cmdDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserSelect.this.doneUsed = true;
                UserSelect.this.dialog.setVisible(false);
            }
        });
        this.enableDone(false);
        this.guiPanel = new JPanel();
        this.dialog.add((Component)new JScrollPane(this.guiPanel), "Center");
        this.dialog.add((Component)this.cmdDone, "South");
    }

    private void terminateDialog() {
        if (this.rectangle == null) {
            this.rectangle = new Rectangle();
        }
        this.dialog.getBounds(this.rectangle);
        this.dialog.dispose();
        this.dialog = null;
    }

    protected void display(List<Individual> operands) {
        this.dialog.setVisible(true);
    }

    protected abstract void select(List<Individual> var1);

    protected void defaultSelect(List<Individual> operands) {
        MersenneTwisterFast random = new MersenneTwisterFast();
        while (this.selectedPopulation.size() < 2) {
            this.selectedPopulation.add(operands.get(random.nextInt(operands.size())));
        }
    }

    protected void enableDone(boolean enable) {
        if (enable) {
            this.cmdDone.setText("Continue");
        } else {
            this.cmdDone.setText("Make a selection");
        }
        this.cmdDone.setEnabled(enable);
    }

    protected JPanel getPanel() {
        return this.guiPanel;
    }

    protected static void gridAdd(Container container, Container control, int gridX, int gridY, double weightX) {
        UserSelect.gridAdd(container, control, gridX, gridY, 1, 1, weightX, 0.0);
    }

    protected static void gridAdd(Container container, Container control, int gridX, int gridY, int gridW, int gridH, double weightX, double weightY) {
        container.add((Component)control, new GridBagConstraints(gridX, gridY, gridW, gridH, weightX, weightY, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
    }
}

