/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Individuals.Chromosome;
import Individuals.GEChromosome;
import Individuals.GEIndividual;
import Individuals.Genotype;
import Individuals.Individual;
import Individuals.Populations.SimplePopulation;
import Mapper.GEGrammar;
import Operator.CrossoverModule;
import Operator.Operations.CrossoverOperation;
import Util.Random.MersenneTwisterFast;
import Util.Random.RandomNumberGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class SinglePointCrossover
extends CrossoverOperation {
    protected boolean fixedCrossoverPoint = false;
    protected boolean codonsUsedSensitive = true;

    public SinglePointCrossover(RandomNumberGenerator m, double prob) {
        this(prob, m);
    }

    public SinglePointCrossover(double prob, RandomNumberGenerator m) {
        super(prob, m);
    }

    public SinglePointCrossover(RandomNumberGenerator m, Properties p) {
        super(m, p);
        this.setProperties(p);
    }

    @Override
    public void setProperties(Properties p) {
        String value;
        String key;
        super.setProperties(p);
        boolean b = false;
        try {
            key = "fixed_point_crossover";
            value = p.getProperty(key);
            if (value != null && value.equals("true")) {
                b = true;
            }
        }
        catch (Exception e) {
            System.out.println(this.getClass().getName() + ".setProperties " + e + " using default: " + b);
        }
        this.fixedCrossoverPoint = b;
        b = false;
        key = "codons_used_sensitive";
        value = p.getProperty(key);
        if (value != null && value.equals("true")) {
            b = true;
        }
        this.codonsUsedSensitive = b;
    }

    @Override
    public void doOperation(Individual operands) {
    }

    @Override
    public void doOperation(List<Individual> operands) {
        int p1maxXOPoint = 0;
        int p2maxXOPoint = 0;
        if (this.rand.nextDouble() < this.probability) {
            GEIndividual p1 = (GEIndividual)operands.get(0);
            GEIndividual p2 = (GEIndividual)operands.get(1);
            GEChromosome chrom1 = (GEChromosome)p1.getGenotype().get(0);
            GEChromosome chrom2 = (GEChromosome)p2.getGenotype().get(0);
            p1maxXOPoint = this.getMaxXOPoint(p1);
            p2maxXOPoint = this.getMaxXOPoint(p2);
            this.performCrossover(p1, p2, chrom1, chrom2, p1maxXOPoint, p2maxXOPoint);
        }
    }

    public int[] performCrossover(GEIndividual indiv1, GEIndividual indiv2, GEChromosome chrome1, GEChromosome chrome2, int chrome1MaxXOPoint, int chrome2MaxXOPoint) {
        int[] xoPoints = this.makeNewChromosome(chrome1, chrome2, chrome1MaxXOPoint, chrome2MaxXOPoint);
        indiv1.getParentUIDs().clear();
        indiv2.getParentUIDs().clear();
        if (xoPoints[0] == 0) {
            indiv1.getParentUIDs().add(indiv2.getUID());
        } else {
            indiv1.getParentUIDs().add(indiv1.getUID());
            indiv1.getParentUIDs().add(indiv2.getUID());
        }
        if (xoPoints[1] == 0) {
            indiv2.getParentUIDs().add(indiv1.getUID());
        } else {
            indiv2.getParentUIDs().add(indiv2.getUID());
            indiv2.getParentUIDs().add(indiv1.getUID());
        }
        return xoPoints;
    }

    protected int getMaxXOPoint(GEIndividual i) {
        int chromsomeSize = ((Chromosome)i.getGenotype().get(0)).getLength();
        int maxXOpoint = i.getPreviouslyUsedCodons() % chromsomeSize;
        if (maxXOpoint <= 0 || !this.codonsUsedSensitive) {
            maxXOpoint = chromsomeSize;
        }
        return maxXOpoint;
    }

    protected int getXoverPoint(int length1, int length2) {
        int crossoverPoint = length1 < length2 ? this.rand.nextInt(length1) : this.rand.nextInt(length2);
        return crossoverPoint;
    }

    public int[] makeNewChromosome(GEChromosome c1, GEChromosome c2, int p1maxXOPoint, int p2maxXOPoint) {
        int[] xoPoints = new int[2];
        if (this.fixedCrossoverPoint) {
            int point1;
            xoPoints[0] = point1 = this.getXoverPoint(p1maxXOPoint, p2maxXOPoint);
            xoPoints[1] = point1;
            for (int i = 0; i < point1; ++i) {
                int tmp1 = c1.get(i);
                int tmp2 = c2.get(i);
                c1.set(i, tmp2);
                c2.set(i, tmp1);
            }
        } else {
            int i;
            int point1 = this.rand.nextInt(p1maxXOPoint);
            int point2 = this.rand.nextInt(p2maxXOPoint);
            xoPoints[0] = point1;
            xoPoints[1] = point2;
            int[] tmp1 = c1.toArray();
            int[] tmp2 = c2.toArray();
            c1.clear();
            c2.clear();
            for (i = 0; i < point1; ++i) {
                c1.add(tmp1[i]);
            }
            for (i = point2; i < tmp2.length; ++i) {
                c1.add(tmp2[i]);
            }
            for (i = 0; i < point2; ++i) {
                c2.add(tmp2[i]);
            }
            for (i = point1; i < tmp1.length; ++i) {
                c2.add(tmp1[i]);
            }
        }
        return xoPoints;
    }

    public boolean isFixedCrossoverPoint() {
        return this.fixedCrossoverPoint;
    }

    public void setFixedCrossoverPoint(boolean fixedCrossoverPoint) {
        this.fixedCrossoverPoint = fixedCrossoverPoint;
    }

    public static void main(String[] args) {
        SinglePointCrossover cop = new SinglePointCrossover((RandomNumberGenerator)new MersenneTwisterFast(), 1.0);
        cop.setFixedCrossoverPoint(false);
        GEChromosome c1 = new GEChromosome(10);
        GEChromosome c2 = new GEChromosome(10);
        for (int i = 0; i < 20; ++i) {
            c1.add(1);
            c2.add(2);
        }
        cop.makeNewChromosome(c1, c2, c1.size(), c2.size());
        Genotype g1 = new Genotype();
        Genotype g2 = new Genotype();
        g1.add(c1);
        g2.add(c2);
        GEIndividual i1 = new GEIndividual();
        GEIndividual i2 = new GEIndividual();
        i1.setMapper(new GEGrammar());
        i1.setGenotype(g1);
        i2.setMapper(new GEGrammar());
        i2.setGenotype(g2);
        ArrayList<Individual> aI = new ArrayList<Individual>(2);
        aI.add(i1);
        aI.add(i2);
        cop.doOperation(aI);
        System.out.println();
        System.out.println("Testing operation crossover");
        System.out.println();
        c1 = (GEChromosome)i1.getGenotype().get(0);
        c2 = (GEChromosome)i2.getGenotype().get(0);
        System.out.println(c1.toString());
        System.out.println(c2.toString());
        CrossoverModule cm = new CrossoverModule(new MersenneTwisterFast(), cop);
        SimplePopulation p = new SimplePopulation();
        p.add(i1);
        p.add(i2);
        cm.setPopulation(p);
        long st = System.currentTimeMillis();
        for (int i = 1; i < 100000000; i += 20) {
            cm.perform();
        }
        long et = System.currentTimeMillis();
        System.out.println("Done running: Total time(Ms) for 100000000 generations was" + (et - st));
        System.out.println();
        System.out.println("Testing module crossover");
        System.out.println();
        c1 = (GEChromosome)i1.getGenotype().get(0);
        c2 = (GEChromosome)i2.getGenotype().get(0);
        System.out.println(c1.toString());
        System.out.println(c2.toString());
    }
}

