/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Individuals.Individual;
import Operator.Operations.SelectionOperation;
import Util.Random.RandomNumberGenerator;
import Util.Random.Stochastic;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public abstract class RouletteWheel
extends SelectionOperation
implements Stochastic {
    protected RandomNumberGenerator rng;
    protected double minFit;
    protected double sumFit;
    protected boolean smallFit = true;
    protected double[] accProbs;

    public RouletteWheel(int size, RandomNumberGenerator rng) {
        super(size);
        this.rng = rng;
    }

    public RouletteWheel() {
    }

    @Override
    public void setProperties(Properties p) {
        super.setProperties(p);
    }

    @Override
    public void doOperation(Individual operand) {
    }

    @Override
    public void doOperation(List<Individual> operands) {
        this.rankPopulation(operands);
        this.calculateFitnessSum(operands);
        this.calculateAccumulatedFitnessProbabilities(operands);
        this.spinRoulette(operands);
    }

    public void rankPopulation(List<Individual> operands) {
        Collections.sort(operands);
    }

    protected void spinRoulette(List<Individual> operands) {
        this.selectedPopulation.clear();
        while (this.selectedPopulation.size() < super.getSize()) {
            int cnt;
            double prob = this.rng.nextDouble();
            for (cnt = 0; cnt < operands.size() && this.accProbs[cnt] < prob; ++cnt) {
            }
            if (cnt >= operands.size()) {
                cnt = operands.size() - 1;
            }
            Individual selected = operands.get(cnt);
            this.selectedPopulation.add(selected.clone());
        }
    }

    protected abstract void calculateAccumulatedFitnessProbabilities(List<Individual> var1);

    protected void calculateFitnessSum(List<Individual> c) {
        double sum = 0.0;
        Iterator<Individual> itI = c.iterator();
        this.minFit = Double.MAX_VALUE;
        while (itI.hasNext()) {
            double tmp = itI.next().getFitness().getDouble();
            if (tmp > 1.0) {
                this.smallFit = false;
            }
            sum += tmp;
            if (!(this.minFit < tmp)) continue;
            this.minFit = tmp;
        }
        this.sumFit = sum;
    }

    @Override
    public RandomNumberGenerator getRNG() {
        return this.rng;
    }

    @Override
    public void setRNG(RandomNumberGenerator m) {
        this.rng = m;
    }
}

